package dressing.reporting.data.handle;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

import dressing.model.Space3DFree;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import dressing.ui.util.StaticUiObjects;

public class AccessoireGroupCoupe {
	private Space3DFree dressing;
	private double totalPrice=0;
	private double totalNumber=0;
	private List<ArticleCoupe> articles=new ArrayList<ArticleCoupe>();
	private List<List<ArticleCoupe>> articlespaginated=new ArrayList<List<ArticleCoupe>>();

	private String sTotalAccessoireCost;
	public int maxarticlesPageSize=1080;
	public AccessoireGroupCoupe(Space3DFree dressing, boolean isAccessoir) {
		this.dressing= dressing;
		int ordre=1;
		if (dressing != null) {

			if (isAccessoir && dressing.getAccessoires() != null && !dressing.getAccessoires().isEmpty()) {
				for (ModelAccessoire accessoire : dressing.getAccessoires()) {
					articles.add(new ArticleCoupe(accessoire, ordre));
					ordre++;
				}
			}
			if (!isAccessoir && dressing.getQuincailleries() != null && !dressing.getQuincailleries().isEmpty()) {
				for (ModelQuincaillerie accessoire : dressing.getQuincailleries()) {
					articles.add(new ArticleCoupe(accessoire, ordre));
					ordre++;
				}
			}
		}
		 calculate(articles);
	}
	public void calculate(List<ArticleCoupe> articles) {
		if(articles==null ||articles.isEmpty()) {
			return;
		}
		this.articles=articles;
		totalPrice = articles.stream().mapToDouble(ArticleCoupe::getTotalPrice).sum();
		totalNumber = articles.stream().mapToDouble(ArticleCoupe::getNumber).sum();
		sTotalAccessoireCost = StaticUiObjects.decimalMoneyFormat.format(totalPrice);

		List<ArticleCoupe> articlestruncated = new ArrayList<ArticleCoupe>();
		int size = 0;
		ConcurrentLinkedQueue<ArticleCoupe> queue = new ConcurrentLinkedQueue<ArticleCoupe>(articles);
		while (queue.size() > 0) {
			ArticleCoupe article = queue.poll();
			if (size > maxarticlesPageSize || size + article.getRowHeigh() > maxarticlesPageSize) {
				if (articlestruncated.size() > 0) {
					articlespaginated.add(articlestruncated);
				}
				articlestruncated = new ArrayList<ArticleCoupe>();
				size = 0;
			} else {
				articlestruncated.add(article);
				size += article.getRowHeigh();
			}
		}
		if (articlestruncated.size() > 0) {
			articlespaginated.add(articlestruncated);
		}
	}
	public Space3DFree getDressing() {
		return dressing;
	}

	public List<ArticleCoupe> getArticles() {
		return articles;
	}

	public double getTotalPrice() {
		return totalPrice;
	}

	public double getTotalNumber() {
		return totalNumber;
	}

	public String getsTotalAccessoireCost() {
		return sTotalAccessoireCost;
	}

	public List<List<ArticleCoupe>> getArticlespaginated() {
		return articlespaginated;
	}

	public int getMaxarticlesPageSize() {
		return maxarticlesPageSize;
	}
	
}
