package reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

import org.apache.lucene.util.MathUtil;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

import dressing.mathutils.MathUtilities;

public class Cotation {
	private String text;
	private ArrayList<Line> lines ;
	private Vector2 textPos ;
	private float textRot;

	public Cotation(String text, ArrayList<Line> ligne, Vector2 postext,float textrotation) {
		super();
		this.text = text;
		this.lines = ligne;
		this.textPos = postext;
	}
	
	public Cotation() {
		super();
		
	}
	
	public Cotation cpy() {
		Cotation copy = new Cotation();
		if(lines != null && !lines.isEmpty()) {
			for(Line line: lines) {
				copy.addline(line);
			}
		}
		copy.setText(text);
		copy.setTextPos(textPos.cpy());
		copy.setTextRot(textRot);
		return copy;
	}
	
	public void clearLines() {
		if(lines != null)
			lines.clear();
	}
	
	public void addline(Line... line) {
		if (this.lines==null) 
			this.lines=new  ArrayList<Line>();
		 this.lines.addAll(Arrays.asList(line));
			for(Line lineX: lines) {
				lineX.sort();
			}
	}
	
	Rectangle getArea() {
		ArrayList<Vector2> points = new ArrayList<Vector2>();
		for(Line line: lines) {
			points.add(line.getStart());
			points.add(line.getEnd());
		}
		Vector2[] bounds = MathUtilities.getBoundariesPlane(points);
		Vector2 dims = bounds[1].cpy().sub(bounds[0]);
		return new Rectangle(bounds[0].x-5, bounds[0].y-5, dims.x+5, dims.y+5);
	}
	
	public boolean overlap(Cotation other) {
		return getArea().overlaps(other.getArea());
	}
	
	public boolean overlap(Line line) {
		Rectangle rec = getArea();
		ArrayList<Line> lines = new ArrayList<Line>();
		Vector2 v0 = new Vector2(rec.x, rec.y);
		Vector2 v1 = new Vector2(rec.x + rec.width, rec.y);
		Vector2 v2 = new Vector2(rec.x + rec.width, rec.y + rec.height);
		Vector2 v3 = new Vector2(rec.x, rec.y + rec.height);
		
		lines.add(new Line(v0, v1, false));
		lines.add(new Line(v1, v2, false));
		lines.add(new Line(v2, v3, false));
		lines.add(new Line(v3, v0, false));
		for(Line lineX: lines) {
			Vector2 intersectionPoint = lineX.intersects(line);
			if(lineX.contains(intersectionPoint))
				return true;
		}
		return false;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public Vector2 getTextPos() {
		return textPos;
	}

	public void setTextPos(Vector2 textPos) {
		this.textPos = textPos;
	}

	public float getTextRot() {
		return textRot;
	}

	public void setTextRot(float textRot) {
		this.textRot = textRot;
	}

	public ArrayList<Line> getLines() {
		return lines;
	}

	@Override
	public String toString() {
		return "Cotation [text=" + text + ", lines=" + lines + ", textPos=" + textPos + ", textRot=" + textRot + "]";
	}
	
	
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		int linesHash = 0;
		if(lines != null) {
			for(Line line: lines) {
				linesHash += line.hashCode();
			}
		}
		
		result = prime * result + linesHash;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Cotation other = (Cotation) obj;
		if (lines == null) {
			if (other.lines != null)
				return false;
		} else if(lines.size() != other.getLines().size())
			return false;
		for(Line line: lines) {
			boolean present = false;
			for(Line otherLine: other.getLines()) {
				if(otherLine.equals(line)) {
					present = true;
					break;	
				}
			}
			if(!present)
				return false;
		}
		return true;
	}

	public static void main(String[] args) {
		Cotation cot1 = new Cotation();
		Cotation cot2 = new Cotation();
		cot1.addline(new Line( new Vector2(10, 0.0001f), new Vector2(), false));
		cot2.addline(new Line(new Vector2(), new Vector2(10.000001f, 0), false));
		System.out.println(cot1.equals(cot2));

	}
	
	
	
} 
	
	
