package dressing.ui;

import java.util.ArrayList;
import java.util.List;

public class CommandStack implements ChangeCommand {
	String name;
	String description;
	public List<ChangeCommand> stack=new ArrayList<ChangeCommand>();
	
	
	public CommandStack(String name, String description, List<ChangeCommand> stack) {
		super();
		this.name = name;
		this.description = description;
		this.stack = stack;
	}

	@Override
	public void redo() {
		if(stack!=null&& stack.size()>0) {
			for(ChangeCommand command:stack) {
				command.redo();
			}
		}

	}

	@Override
	public void verify() {
		// TODO Auto-generated method stub

	}

	@Override
	public void undo() {
		if(stack!=null&& stack.size()>0) {
			for(int i=stack.size()-1;i>=0;i--) {
				ChangeCommand command=stack.get(i);
				command.undo();
			}
		}

	}
	public void addCommand(ChangeCommand command) {
		if(stack!=null)
		{
			this.stack.add(command);
		}
	}
	public void addAll(CommandStack other) {
		addAll(other.getStack());
	}
	
	public void addAll(List<ChangeCommand> commands) {
		for(ChangeCommand command: commands)
			addCommand(command);
	}
	public String getID() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<ChangeCommand> getStack() {
		return stack;
	}

	public void setStack(List<ChangeCommand> stack) {
		this.stack = stack;
	}
	@Override
	public void dispose() {
		name=null;
		description=null;
		if(stack!=null) {
			for(int i=0;i<stack.size();i++) {
				stack.get(i).dispose();
			}
			stack.clear();
		}
		
	}
}
