package model.dressing.creator.srctcase;

import model.dressing.CommonDressing;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import org.junit.Test;

import dressing.controller.DressingCreator;
import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Piece2D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.Zone3DType;
import model.dressing.CommonDressing;
import utils.ParametersUtils;

public class Checks extends CommonDressing {

	protected void checkCaissonTypes(DressingCreator drcreator) {
		checkDressingTypes(drcreator);
		checkCanHold(drcreator.getDressingInstance());
		int caissoncounter = 0;
		int caissonlongeurCounter = 0;
		assertNotNull(drcreator.getDressingInstance());
		assertEquals(drcreator.getCaissoncount(), drcreator.getDressingInstance().getChilds().size());
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			caissonlongeurCounter += caisson.getLongeurext();
			assertEquals(Caisson.class, caisson.getClass());
			assertNotNull(caisson.getChilds());
			assertEquals(drcreator.getCaissonMontageType(), ((Caisson) caisson).getCaissonMontageType());
			assertEquals(drcreator.getDressingInstance().getBasematerial(), ((Caisson) caisson).getBasematerial());
			assertEquals(drcreator.getDressingInstance().getBackmaterial(), ((Caisson) caisson).getBackmaterial());
			assertEquals(drcreator.getLongeur() / drcreator.getCaissoncount(), ((Caisson) caisson).getLongeurext(),
					ParametersUtils.epsilon);
			assertEquals(drcreator.getHauteur(), ((Caisson) caisson).getHauteurext(), ParametersUtils.epsilon);
			assertEquals(drcreator.getProfondeur(), ((Caisson) caisson).getProfondeurext(), ParametersUtils.epsilon);
			assertEquals(drcreator.getPorttype(), ((Caisson) caisson).getPorttype());
			assertEquals(drcreator.getDressingInstance(), ((Caisson) caisson).getParentdesign());
			assertEquals(drcreator.getDressingInstance(), caisson.getParentdesign());

			if (drcreator.getCaissoncount() == 1) {
				if (caissoncounter == 0) {
					assertEquals(CaissonType.MONO_CAISSON, ((Caisson) caisson).getCuissontype());
				}
			}
			if (drcreator.getCaissoncount() == 2) {
				if (caissoncounter == 0) {
					assertEquals(CaissonType.EXTREME_GAUCHE, ((Caisson) caisson).getCuissontype());
				} else if (caissoncounter == 1) {
					assertEquals(CaissonType.EXTREME_DROITE, ((Caisson) caisson).getCuissontype());
				}
			}
			if (drcreator.getCaissoncount() == 3) {
				if (caissoncounter == 0) {
					assertEquals(CaissonType.EXTREME_GAUCHE, ((Caisson) caisson).getCuissontype());
				} else if (caissoncounter == 1) {
					assertEquals(CaissonType.MILIEU, ((Caisson) caisson).getCuissontype());
				} else if (caissoncounter == 2) {
					assertEquals(CaissonType.EXTREME_DROITE, ((Caisson) caisson).getCuissontype());
				}
			}

			caissoncounter++;
		}
		assertEquals(drcreator.getDressingInstance().getLongeurext(), caissonlongeurCounter, ParametersUtils.epsilon);

	}

	protected void checkDressingTypes(DressingCreator drcreator) {

		assertNotNull(drcreator.getDressingInstance());
		assertEquals(drcreator.getCaissoncount(), drcreator.getDressingInstance().getChilds().size());
		if (!(drcreator.getDressingInstance() instanceof Dressing)) {
			fail("le dressing creator doit créer un objet de type dressing");
		}
		assertEquals(drcreator.getAppartement(), ((Dressing) drcreator.getDressingInstance()).getAppartement());
		assertEquals(drcreator.getChantier(), ((Dressing) drcreator.getDressingInstance()).getChantier());
		assertEquals(drcreator.getEtage(), ((Dressing) drcreator.getDressingInstance()).getEtage());
		assertEquals(drcreator.getName(), ((Dressing) drcreator.getDressingInstance()).getName());
		assertEquals(drcreator.getCaissoncount(), ((Dressing) drcreator.getDressingInstance()).getChilds().size());
		assertEquals(drcreator.getCaissonMontageType(),((Dressing)drcreator.getDressingInstance()).getCaissonmontageType());
		assertEquals(drcreator.getDostype(), ((Dressing)drcreator.getDressingInstance()).getDostype());
		assertEquals(drcreator.getHauteur(), ((Dressing) drcreator.getDressingInstance()).getHauteurext(),ParametersUtils.epsilon);
		assertEquals(drcreator.getProfondeur(), ((Dressing) drcreator.getDressingInstance()).getProfondeurext(),ParametersUtils.epsilon);
		assertEquals(drcreator.getLongeur(), ((Dressing) drcreator.getDressingInstance()).getLongeurext(),ParametersUtils.epsilon);
		assertEquals(drcreator.getPorttype(), ((Dressing) drcreator.getDressingInstance()).getPorttype());
		// assertEquals(drcreator.getPositiontype(),
		// ((Dressing)drcreator.getDressingInstance()).getPositiontype());

	}

	protected void checkCaissonPieceTypes(DressingCreator drcreator) {
		CheckCaissonPieceMaterial(drcreator);
		CheckCaissonDosExistence(drcreator);
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			int cotedroiteexist = 0;
			int coteGaucheeexist = 0;
			int basCaissonexist = 0;
			int hautCaissonexist = 0;

			for (DesignObject3D piece : caisson.getChilds()) {
				if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)) {
					basCaissonexist++;
				}
				if (((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)) {
					hautCaissonexist++;
				}
				if (((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
					coteGaucheeexist++;
				}
				if (((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
					cotedroiteexist++;
				}
			}

			assertEquals(1, basCaissonexist);
			assertEquals(1, hautCaissonexist);
			assertEquals(1, coteGaucheeexist);
			assertEquals(1, cotedroiteexist);
		}
	}

	protected void checkCaissonDosTypes(DressingCreator drcreator) {
		// tester le type de dos du caisson par rapport du dressingCreator
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			Piece2D doscaisson = null;
			int dosexist = 0;
			for (DesignObject3D piece : caisson.getChilds()) {
				// recuperer le piece de dos
				if (piece instanceof Piece2D) {
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR))) {
						dosexist++;
						doscaisson = (Piece2D) piece;
					}
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.DOS_EXTERIRUR))) {
						doscaisson = (Piece2D) piece;
						dosexist++;
					}
				}
			}
			if (!drcreator.isWithseprator() && doscaisson == null) {
				fail("la creation de doit dans le dressing est obligatoire");
			}
			if (doscaisson != null) {
				// tester le type de dos , si non valide en appel le method fail de junit pour
				// reclamer un erreur
				if (drcreator.getDostype().equals(DosType.DOSEXTERIEUR)) {
					if (!doscaisson.getPiecetype().equals(PieceType.DOS_EXTERIRUR)) {
						fail("le type des dos des caisson doit egale a la type de dos de dressing  ");
					}
				} else if (drcreator.getDostype().equals(DosType.DOSINTERIEUR)) {
					if (dosexist!=0) {
						if (!doscaisson.getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
							fail("le type des dos des caisson doit egale a la type de dos de dressing  ");
						}
					}
				}
			}
			if(!drcreator.isWithseprator()) {
				assertEquals(1, dosexist);
			}

		}
	}

	protected void checkCaissonColissant(DressingCreator drcreator) {

		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					// tester si le type de porte est Francaise ou Francaise2V c.a.d diffirent du
					// collisant
					if (!drcreator.getPorttype().equals(PortType.COLISSANT)) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
							assertEquals(drcreator.getDressingInstance().getProfondeurext(), piece.getProfondeurext(),
									0);

						}
					}
					// tester si le type de porte est collisant
					if (drcreator.getPorttype().equals(PortType.COLISSANT)) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)) {
							assertEquals(drcreator.getDressingInstance().getProfondeurext(), piece.getProfondeurext(),
									ParametersUtils.epsilon);

						}
						if (((Caisson) caisson).getCuissontype().equals(CaissonType.EXTREME_GAUCHE)) {
							if (((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
								assertEquals(drcreator.getDressingInstance().getProfondeurext(),
										piece.getProfondeurext(), ParametersUtils.epsilon);

							}
							if (((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
								assertEquals(
										drcreator.getDressingInstance().getProfondeurext()
												- ParametersUtils.retraitcolissant,
										piece.getProfondeurext(), ParametersUtils.epsilon);

							}
						}
						if (((Caisson) caisson).getCuissontype().equals(CaissonType.EXTREME_DROITE)) {
							if (((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
								assertEquals(
										drcreator.getDressingInstance().getProfondeurext()
												- ParametersUtils.retraitcolissant,
										piece.getProfondeurext(), ParametersUtils.epsilon);

							}
							if (((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
								assertEquals(drcreator.getDressingInstance().getProfondeurext(),
										piece.getProfondeurext(), ParametersUtils.epsilon);

							}
						}
						if (((Caisson) caisson).getCuissontype().equals(CaissonType.MILIEU)) {
							if (((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)
									|| ((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
								assertEquals(
										drcreator.getDressingInstance().getProfondeurext()
												- ParametersUtils.retraitcolissant,
										piece.getProfondeurext(), ParametersUtils.epsilon);

							}
						}
						if (((Caisson) caisson).getCuissontype().equals(CaissonType.MONO_CAISSON)) {
							if (((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)
									|| ((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
								assertEquals(drcreator.getDressingInstance().getProfondeurext(),
										piece.getProfondeurext(), ParametersUtils.epsilon);

							}
						}
					}
				}
			}
		}
	}

	protected void checkCaissonDimensionPiece(DressingCreator drcreator) {

		// tester les dimension largeur et hauteur des cote,haut,bas du caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)) {
						if (piece.getLongeurext() > piece.getProfondeurext()) {
							assertEquals(piece.getLongeurext(), ((Piece2D) piece).getPieceL(), ParametersUtils.epsilon);
							assertEquals(piece.getProfondeurext(), ((Piece2D) piece).getPieceH(),
									ParametersUtils.epsilon);
						} else {
							assertEquals(piece.getLongeurext(), ((Piece2D) piece).getPieceH(), ParametersUtils.epsilon);
							assertEquals(piece.getProfondeurext(), ((Piece2D) piece).getPieceL(),
									ParametersUtils.epsilon);
						}
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						if (piece.getHauteurext() > piece.getProfondeurext()) {
							assertEquals(piece.getHauteurext(), ((Piece2D) piece).getPieceL(), ParametersUtils.epsilon);
							assertEquals(piece.getProfondeurext(), ((Piece2D) piece).getPieceH(),
									ParametersUtils.epsilon);
						} else {
							assertEquals(piece.getHauteurext(), ((Piece2D) piece).getPieceH(), ParametersUtils.epsilon);
							assertEquals(piece.getProfondeurext(), ((Piece2D) piece).getPieceL(),
									ParametersUtils.epsilon);
						}
					}
				}
			}
		}
		// tester les dimension largeur et hauteur du dos dans le caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_EXTERIRUR)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
						if (piece.getHauteurext() > piece.getLongeurext()) {
							assertEquals(piece.getHauteurext(), ((Piece2D) piece).getPieceL(), ParametersUtils.epsilon);
							assertEquals(piece.getLongeurext(), ((Piece2D) piece).getPieceH(), ParametersUtils.epsilon);
						} else {
							assertEquals(piece.getHauteurext(), ((Piece2D) piece).getPieceH(), ParametersUtils.epsilon);
							assertEquals(piece.getLongeurext(), ((Piece2D) piece).getPieceL(), ParametersUtils.epsilon);
						}
					}

				}
			}
		}
		// tester les dimension largeur et hauteur du seperateur dans le caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						if (drcreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
							if (piece.getHauteurext() > piece.getProfondeurext()) {
								assertEquals(piece.getHauteurext(), ((Piece2D) piece).getPieceL(),
										ParametersUtils.epsilon);
								assertEquals(piece.getProfondeurext(), ((Piece2D) piece).getPieceH(),
										ParametersUtils.epsilon);
							} else {
								assertEquals(piece.getHauteurext(), ((Piece2D) piece).getPieceH(),
										ParametersUtils.epsilon);
								assertEquals(piece.getProfondeurext(), ((Piece2D) piece).getPieceL(),
										ParametersUtils.epsilon);
							}
						} else if (drcreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
							if (piece.getLongeurext() > piece.getProfondeurext()) {
								assertEquals(piece.getLongeurext(), ((Piece2D) piece).getPieceL(),
										ParametersUtils.epsilon);
								assertEquals(piece.getProfondeurext(), ((Piece2D) piece).getPieceH(),
										ParametersUtils.epsilon);
							} else {
								assertEquals(piece.getLongeurext(), ((Piece2D) piece).getPieceH(),
										ParametersUtils.epsilon);
								assertEquals(piece.getProfondeurext(), ((Piece2D) piece).getPieceL(),
										ParametersUtils.epsilon);
							}
						} else if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
							if (piece.getLongeurext() > piece.getHauteurext()) {
								assertEquals(piece.getLongeurext(), ((Piece2D) piece).getPieceL(),
										ParametersUtils.epsilon);
								assertEquals(piece.getHauteurext(), ((Piece2D) piece).getPieceH(),
										ParametersUtils.epsilon);
							} else {
								assertEquals(piece.getLongeurext(), ((Piece2D) piece).getPieceH(),
										ParametersUtils.epsilon);
								assertEquals(piece.getHauteurext(), ((Piece2D) piece).getPieceL(),
										ParametersUtils.epsilon);
							}
						}
					}

				}
			}
		}
		// tester les dimension largeur et hauteur du dos dans le separator dans le
		// caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						assertNotNull(((Separator) piece).getChilds());
						for (DesignObject3D space : ((Separator) piece).getChilds()) {
							assertNotNull(space.getChilds());
							for (DesignObject3D piece2d : space.getChilds()) {
								if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
									if (piece2d.getHauteurext() > piece2d.getLongeurext()) {
										assertEquals(piece2d.getHauteurext(), ((Piece2D) piece2d).getPieceL(),
												ParametersUtils.epsilon);
										assertEquals(piece2d.getLongeurext(), ((Piece2D) piece2d).getPieceH(),
												ParametersUtils.epsilon);
									} else {
										assertEquals(piece2d.getHauteurext(), ((Piece2D) piece2d).getPieceH(),
												ParametersUtils.epsilon);
										assertEquals(piece2d.getLongeurext(), ((Piece2D) piece2d).getPieceL(),
												ParametersUtils.epsilon);
									}
								}

							}
						}
					}
				}
			}
		}
	}

	protected void checkCaissonMesuresPieces(DressingCreator drcreator) {
		// tester les dimension des cote, bas et haut du caisoon
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (drcreator.getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I)) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)) {

							assertEquals(caisson.getLongeurext(), piece.getLongeurext(), ParametersUtils.epsilon);
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getHauteurext(),
									ParametersUtils.epsilon);
							assertEquals(0, piece.getXpos(), ParametersUtils.epsilon);

							if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)) {
								assertEquals(0, piece.getYpos(), ParametersUtils.epsilon);
							} else {
								assertEquals(caisson.getBasematerial().getEpaisseur() + caisson.getHauteurint(),
										piece.getYpos(), ParametersUtils.epsilon);
							}

						}
						if (((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getLongeurext(),
									ParametersUtils.epsilon);
							assertEquals(caisson.getHauteurext(),
									piece.getHauteurext() + (2 * caisson.getBasematerial().getEpaisseur()),
									ParametersUtils.epsilon);
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getYpos(),
									ParametersUtils.epsilon);
							if (((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
								assertEquals(caisson.getLongeurint() + caisson.getBasematerial().getEpaisseur(),
										piece.getXpos(), ParametersUtils.epsilon);
							} else {
								assertEquals(0, piece.getXpos(), ParametersUtils.epsilon);
							}

						}
					} else if (drcreator.getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L)) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)) {
							assertEquals(caisson.getLongeurext(),
									piece.getLongeurext() + (2 * caisson.getBasematerial().getEpaisseur()),
									ParametersUtils.epsilon);
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getHauteurext(),
									ParametersUtils.epsilon);
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getXpos(),
									ParametersUtils.epsilon);
							if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)) {
								assertEquals(0, piece.getYpos(), ParametersUtils.epsilon);
							} else {
								assertEquals(caisson.getBasematerial().getEpaisseur() + caisson.getHauteurint(),
										piece.getYpos(), ParametersUtils.epsilon);
							}

						}
						if (((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getLongeurext(),
									ParametersUtils.epsilon);
							assertEquals(caisson.getHauteurext(), piece.getHauteurext(), ParametersUtils.epsilon);
							assertEquals(0, piece.getYpos(), ParametersUtils.epsilon);
							if (((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
								assertEquals(caisson.getBasematerial().getEpaisseur() + caisson.getLongeurint(),
										piece.getXpos(), ParametersUtils.epsilon);
							} else {
								assertEquals(0, piece.getXpos(), ParametersUtils.epsilon);
							}
						}
					}

				}
			}
		}
		// tester la hauteur est la longeur du dos
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR))) {
						assertEquals(caisson.getHauteurint() + 2 * ParametersUtils.dosRainureProf,
								piece.getHauteurext(), ParametersUtils.epsilon);
						assertEquals(caisson.getLongeurint() + 2 * ParametersUtils.dosRainureProf,
								piece.getLongeurext(), ParametersUtils.epsilon);
					}
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.DOS_EXTERIRUR))) {
						assertEquals(caisson.getHauteurext(), piece.getHauteurext(), ParametersUtils.epsilon);
						assertEquals(caisson.getLongeurext(), piece.getLongeurext(), ParametersUtils.epsilon);

					}
				}
			}
		}
		// tester la hauteur est la longeur et les position X,Y des portes
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.PORTE))) {
						assertEquals(caisson.getHauteurext() - ParametersUtils.porteJeu, piece.getHauteurext(),
								ParametersUtils.epsilon);
						assertEquals(caisson.getLongeurext() - ParametersUtils.porteJeu, piece.getLongeurext(),
								ParametersUtils.epsilon);
						assertEquals(ParametersUtils.porteJeu / 2, piece.getYpos(), ParametersUtils.epsilon);
						assertEquals(ParametersUtils.porteJeu / 2, piece.getXpos(), ParametersUtils.epsilon);
						assertEquals(caisson.getProfondeurext(), piece.getZpos(),ParametersUtils.epsilon);
					}
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_GAUCHE))) {
						assertEquals(caisson.getHauteurext() - ParametersUtils.porteJeu, piece.getHauteurext(),
								ParametersUtils.epsilon);
						assertEquals((caisson.getLongeurext() / 2) - ParametersUtils.porteJeu, piece.getLongeurext(),
								ParametersUtils.epsilon);
						assertEquals(ParametersUtils.porteJeu / 2, piece.getYpos(), ParametersUtils.epsilon);
						assertEquals(ParametersUtils.porteJeu / 2, piece.getXpos(), ParametersUtils.epsilon);
						assertEquals(caisson.getProfondeurext(), piece.getZpos(),ParametersUtils.epsilon);
					}
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_DROITE))) {
						assertEquals(caisson.getHauteurext() - ParametersUtils.porteJeu, piece.getHauteurext(),
								ParametersUtils.epsilon);
						assertEquals((caisson.getLongeurext() / 2) - ParametersUtils.porteJeu, piece.getLongeurext(),
								ParametersUtils.epsilon);
						assertEquals(ParametersUtils.porteJeu / 2, piece.getYpos(), ParametersUtils.epsilon);
						assertEquals(caisson.getLongeurext() / 2 + ParametersUtils.porteJeu / 2, piece.getXpos(),
								ParametersUtils.epsilon);
						assertEquals(caisson.getProfondeurext(), piece.getZpos(),ParametersUtils.epsilon);
					}

				}
			}
		}
	}

	protected void CheckCaissonPortetypes(DressingCreator drcreator) {
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			assertEquals(drcreator.getPorttype(), ((Caisson) caisson).getPorttype());
			int caissonportecount = 0;
			for (DesignObject3D piece : caisson.getChilds()) {
				if (drcreator.isWithporte()) {
					if (piece instanceof Piece2D) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.PORTE)) {
							caissonportecount++;
						}
					}
				}
			}
			
			//tester l'existence du porte Francaise2V
			int caissonporte2Vcount = 0;
			for (DesignObject3D piece : caisson.getChilds()) {
				if (drcreator.isWithporte()) {
					if (piece instanceof Piece2D) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_DROITE)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_GAUCHE)) {
							caissonporte2Vcount++;
						}
					}
				}
			}
			//tester l'existence du porte Francaise2H
			int caissonporte2Hcount = 0;
			for (DesignObject3D piece : caisson.getChilds()) {
				if (drcreator.isWithporte()) {
					if (piece instanceof Piece2D) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_BAS)
								|| ((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_HAUT)) {
							caissonporte2Hcount++;
						}
					}
				}
			}

			if (drcreator.isWithporte()) {
				if (drcreator.getPorttype().equals(PortType.FRANCAISE)) {
					assertEquals(1, caissonportecount);
				} else if (drcreator.getPorttype().equals(PortType.FRANCAISE2V)) {
					assertEquals(2, caissonporte2Vcount);
				} else if (drcreator.getPorttype().equals(PortType.FRANCAISE2H)) {
					assertEquals(2, caissonporte2Hcount);
				}

			}
		}

	}

	protected void CheckPositionsPieceCaisson(DressingCreator drcreator) {
		// tester les positions des cote, bas, haut et dos du caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						assertEquals(0, piece.getZpos(), ParametersUtils.epsilon);
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_EXTERIRUR)) {
						assertEquals(-caisson.getBackmaterial().getEpaisseur(), piece.getZpos(),
								ParametersUtils.epsilon);
						assertEquals(0, piece.getYpos(), ParametersUtils.epsilon);
						assertEquals(0, piece.getXpos(), ParametersUtils.epsilon);
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
						assertEquals(ParametersUtils.dosRainurePositionOffset, piece.getZpos(),
								ParametersUtils.epsilon);
						assertEquals(caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
								piece.getYpos(), ParametersUtils.epsilon);
						assertEquals(caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
								piece.getXpos(), ParametersUtils.epsilon);
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.PORTE)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_GAUCHE)
							|| ((Piece2D) piece).getPiecetype().equals(PieceType.PORTE_DROITE)) {
						assertEquals(caisson.getProfondeurext(), piece.getZpos(), ParametersUtils.epsilon);
					}
				}
			}
		}

		// tester les positions des dos dans le separator dans le caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						assertNotNull(((Separator) piece).getChilds());
						for (DesignObject3D space : ((Separator) piece).getChilds()) {
							assertNotNull(space.getChilds());

							for (DesignObject3D piece2d : space.getChilds()) {
								if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
									if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										fail("une dos dans un zone de type ZONE_HAUT dans un separateur de sepaxe egale a Z est non supporter");
									}
								}
								if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
									assertEquals(ParametersUtils.dosRainurePositionOffset, piece2d.getZpos(),
											ParametersUtils.epsilon);
									assertEquals(
											caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
											piece2d.getYpos(), ParametersUtils.epsilon);
									assertEquals(
											caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
											piece2d.getXpos(), ParametersUtils.epsilon);

								}

							}
						}
					}
				}
			}
		}

	}

	protected void CheckCaissonSeparator(DressingCreator drcreator) {
		CheckCaissonSeparatorDimension(drcreator);
		if(drcreator.isWithseprator()&& drcreator.isSepratortransversal() ) {
			CheckCaissonSeparatorTransversantPositions(drcreator);
		}else if(drcreator.isWithseprator()&& !drcreator.isSepratortransversal() ) {
			CheckCaissonSeparatorNormalePositions(drcreator);
		}
		CheckCaissonSeparatorSpacesDimension(drcreator);
		//
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			Boolean septransversalexist = false;
			Boolean spexist=false;
			//
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {

					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						septransversalexist = true;
						spexist = true;
						assertEquals(((Separator) piece).getSepaxe(), drcreator.getSeprationaxe());
						assertEquals(((Piece2D) piece).getMaterial(), drcreator.getBasematerial());
						assertEquals(Zone3DType.ZONEHAUT, ((Separator) piece).getLefttopchild().getZonetype());
						assertEquals(Zone3DType.ZONEBAS, ((Separator) piece).getRightdownchild().getZonetype());

//						// tester le separation position
//						if (drcreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
//							assertEquals(drcreator.getSeparationposition() + drcreator.getBasematerial().getEpaisseur(),
//									((Separator) piece).getXpos(), ParametersUtils.epsilon);
//						} else if (drcreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
//							assertEquals(drcreator.getSeparationposition() + drcreator.getBasematerial().getEpaisseur(),
//									((Separator) piece).getYpos(), ParametersUtils.epsilon);
//						} else if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
//							assertEquals(drcreator.getSeparationposition(), ((Separator) piece).getZpos(),
//									ParametersUtils.epsilon);
//						} else {
//							fail("l'axe de separation donner est non supporter");
//						}
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
						spexist = true;
					}	
				}
			}
			//
			assertEquals(drcreator.isWithseprator(), spexist);
			if(spexist) {
				assertEquals(drcreator.isSepratortransversal(), septransversalexist);
			}
		}
		//

	}
	protected void CheckCaissonSeparatorSpacesDimension(DressingCreator drcreator) {
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			Boolean sepexist = false;
			//
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {

					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						// tester le profondeur des Spaces dans le separateur
						assertEquals(2, ((Separator) piece).getChilds().size());
						assertNotNull(((Separator) piece).getLefttopchild());
						assertNotNull(((Separator) piece).getRightdownchild());
						assertEquals(Space3D.class, ((Separator) piece).getLefttopchild().getClass());
						assertEquals(Space3D.class, ((Separator) piece).getRightdownchild().getClass());
						assertEquals(Zone3DType.ZONEHAUT, ((Separator) piece).getLefttopchild().getZonetype());
						assertEquals(Zone3DType.ZONEBAS, ((Separator) piece).getRightdownchild().getZonetype());
						for (DesignObject3D space : ((Separator) piece).getChilds()) {
							assertEquals(Space3D.class, space.getClass());
							assertNotNull(space);
							//new
							if (drcreator.getPorttype().equals(PortType.COLISSANT)) {
								if (drcreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
									assertEquals(caisson.getProfondeurext() - ParametersUtils.retraitcolissant,space.getProfondeurint(), ParametersUtils.epsilon);
									assertEquals(caisson.getHauteurint(),space.getHauteurint(),ParametersUtils.epsilon);
									if(((Space3D)space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										assertEquals(piece.getXpos()-caisson.getBasematerial().getEpaisseur(),
												space.getLongeurint(), ParametersUtils.epsilon);
									}else {
										assertEquals(caisson.getLongeurint()-((Piece2D)piece).getMaterial().getEpaisseur()-piece.getXpos()+caisson.getBasematerial().getEpaisseur(),space.getLongeurint(), ParametersUtils.epsilon);
									}
								
								} else if (drcreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
									assertEquals(caisson.getProfondeurext() - ParametersUtils.retraitcolissant,space.getProfondeurint(), ParametersUtils.epsilon);
									assertEquals(caisson.getLongeurint(),space.getLongeurint(), ParametersUtils.epsilon);

									if(((Space3D)space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										assertEquals(caisson.getHauteurint()-piece.getYpos()-piece.getBasematerial().getEpaisseur()+caisson.getBasematerial().getEpaisseur(),
												space.getHauteurint(),ParametersUtils.epsilon);
									}else {
										assertEquals(piece.getYpos()-caisson.getBasematerial().getEpaisseur(),space.getHauteurint(),ParametersUtils.epsilon);
									}
								
								} else if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
									assertEquals(caisson.getLongeurint(),space.getLongeurint(), ParametersUtils.epsilon);
									assertEquals(caisson.getHauteurint(),space.getHauteurint(),ParametersUtils.epsilon);
									if(((Space3D)space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										assertEquals(caisson.getProfondeurext() -piece.getZpos()- ((Piece2D)piece).getMaterial().getEpaisseur(),space.getProfondeurext(), ParametersUtils.epsilon);
										assertEquals(caisson.getProfondeurint() -piece.getZpos()- ((Piece2D)piece).getMaterial().getEpaisseur(),space.getProfondeurint(), ParametersUtils.epsilon);
									}else {
										assertEquals(piece.getZpos(),space.getProfondeurext(),ParametersUtils.epsilon);
									}

								}
							} else if (drcreator.getPorttype().equals(PortType.FRANCAISE)
									|| drcreator.getPorttype().equals(PortType.FRANCAISE2V)) {
								if (drcreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
									assertEquals(caisson.getProfondeurext(),space.getProfondeurext(), ParametersUtils.epsilon);
									assertEquals(caisson.getHauteurint(),space.getHauteurint(),ParametersUtils.epsilon);
									if(((Space3D)space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										assertEquals(piece.getXpos()-caisson.getBasematerial().getEpaisseur(),
												space.getLongeurint(), ParametersUtils.epsilon);
									}else {
										assertEquals(caisson.getLongeurint()-((Piece2D)piece).getMaterial().getEpaisseur()-piece.getXpos()+caisson.getBasematerial().getEpaisseur(),space.getLongeurint(), ParametersUtils.epsilon);
									}
								} else if (drcreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
									assertEquals(caisson.getProfondeurext(),space.getProfondeurext(), ParametersUtils.epsilon);
									assertEquals(caisson.getLongeurint(),space.getLongeurint(), ParametersUtils.epsilon);

									if(((Space3D)space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										assertEquals(caisson.getHauteurint()-piece.getYpos()-piece.getBasematerial().getEpaisseur()+caisson.getBasematerial().getEpaisseur(),
												space.getHauteurint(),ParametersUtils.epsilon);
									}else {
										assertEquals(piece.getYpos()-caisson.getBasematerial().getEpaisseur(),space.getHauteurint(),ParametersUtils.epsilon);
									}
								
								} else if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
									assertEquals(caisson.getLongeurint(),space.getLongeurint(), ParametersUtils.epsilon);
									assertEquals(caisson.getHauteurint(),space.getHauteurint(),ParametersUtils.epsilon);
									if(((Space3D)space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										assertEquals(caisson.getProfondeurext() -piece.getZpos()-piece.getBasematerial().getEpaisseur(),space.getProfondeurext(), ParametersUtils.epsilon);
									}else {
										assertEquals(piece.getZpos(),space.getProfondeurext(),ParametersUtils.epsilon);
									}

								}
							}
						}
						//

					}
				}
			}
		}
		//
	}

	protected void CheckCaissonSeparatorDimension(DressingCreator drcreator) {
		// tester les dimension du la separateur
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			//
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {

					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						if (drcreator.getPorttype().equals(PortType.COLISSANT)) {
							if (drcreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {

								assertEquals(caisson.getHauteurext() - 2 * caisson.getBasematerial().getEpaisseur(),
										piece.getHauteurext(), ParametersUtils.epsilon);
								assertEquals(caisson.getProfondeurext() - ParametersUtils.retraitcolissant,
										piece.getProfondeurext(), ParametersUtils.epsilon);
								assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getLongeurext(),
										ParametersUtils.epsilon);
							} else if (drcreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {

								assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getHauteurext(),
										ParametersUtils.epsilon);
								assertEquals(caisson.getProfondeurext() - ParametersUtils.retraitcolissant,
										piece.getProfondeurext(), ParametersUtils.epsilon);
								assertEquals(caisson.getLongeurext() - 2 * caisson.getBasematerial().getEpaisseur(),
										piece.getLongeurext(), ParametersUtils.epsilon);

							} else if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
								assertEquals(caisson.getHauteurext() - 2 * caisson.getBasematerial().getEpaisseur(),
										piece.getHauteurext(), ParametersUtils.epsilon);
								assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getProfondeurext(),
										ParametersUtils.epsilon);
								assertEquals(caisson.getLongeurext() - 2 * caisson.getBasematerial().getEpaisseur(),
										piece.getLongeurext(), ParametersUtils.epsilon);

							}
						} else if (drcreator.getPorttype().equals(PortType.FRANCAISE)
								|| drcreator.getPorttype().equals(PortType.FRANCAISE2V)) {
							if (drcreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {

								assertEquals(caisson.getHauteurext() - 2 * caisson.getBasematerial().getEpaisseur(),
										piece.getHauteurext(), ParametersUtils.epsilon);
								assertEquals(caisson.getProfondeurext(), piece.getProfondeurext(),
										ParametersUtils.epsilon);
								assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getLongeurext(),
										ParametersUtils.epsilon);
							} else if (drcreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {

								assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getHauteurext(),
										ParametersUtils.epsilon);
								assertEquals(caisson.getProfondeurext(), piece.getProfondeurext(),
										ParametersUtils.epsilon);
								assertEquals(caisson.getLongeurext() - 2 * caisson.getBasematerial().getEpaisseur(),
										piece.getLongeurext(), ParametersUtils.epsilon);

							} else if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
								assertEquals(caisson.getHauteurext() - 2 * caisson.getBasematerial().getEpaisseur(),
										piece.getHauteurext(), ParametersUtils.epsilon);
								assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getProfondeurext(),
										ParametersUtils.epsilon);
								assertEquals(caisson.getLongeurext() - 2 * caisson.getBasematerial().getEpaisseur(),
										piece.getLongeurext(), ParametersUtils.epsilon);

							}
						}

					}
				}
			}

		}

	}

	protected void CheckCaissonSeparatorTransversantPositions(DressingCreator drcreator) {
		// tester les positions du separateur dans le caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
						if (drcreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
							assertEquals(0, piece.getZpos(), ParametersUtils.epsilon);
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getYpos(),
									ParametersUtils.epsilon);
							if(drcreator.isSeparatorisometrique()) {
								assertEquals((caisson.getLongeurint() - ((Piece2D)piece).getMaterial().getEpaisseur())/2 +caisson.getBasematerial().getEpaisseur(),
										piece.getXpos(), ParametersUtils.epsilon);
							}else {
								if(drcreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
									assertEquals(caisson.getBasematerial().getEpaisseur() + drcreator.getSeparationposition(),
											piece.getXpos(), ParametersUtils.epsilon);
								}else {
									assertEquals(caisson.getLongeurint() +caisson.getBasematerial().getEpaisseur() - drcreator.getSeparationposition()-((Piece2D)piece).getMaterial().getEpaisseur() ,
											piece.getXpos(), ParametersUtils.epsilon);
								}

							}
					
							if (piece.getZpos() > caisson.getLongeurext()) {
								fail("le position du separateur sur l'axe X doit inferieur a la Longeur du caisson ");
							}
						} else if (drcreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getXpos(),
									ParametersUtils.epsilon);
							
							if(drcreator.isSeparatorisometrique()) {
								assertEquals((caisson.getHauteurint() - ((Piece2D)piece).getMaterial().getEpaisseur())/2 +caisson.getBasematerial().getEpaisseur(),
										piece.getYpos(), ParametersUtils.epsilon);
							}else {
								if(drcreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
									assertEquals(caisson.getBasematerial().getEpaisseur() + drcreator.getSeparationposition(),
											piece.getYpos(), ParametersUtils.epsilon);
								}else {
									assertEquals(caisson.getHauteurint() +caisson.getBasematerial().getEpaisseur() - drcreator.getSeparationposition()-((Piece2D)piece).getMaterial().getEpaisseur() ,
											piece.getYpos(), ParametersUtils.epsilon);
								}

							}
							assertEquals(0, piece.getZpos(), ParametersUtils.epsilon);
							if (piece.getYpos() > caisson.getHauteurext()) {
								fail("le position du separateur sur l'axe Y doit inferieur a la Hauteur du caisson ");
							}
						} else if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getXpos(),
									ParametersUtils.epsilon);
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getYpos(),
									ParametersUtils.epsilon);
							if(drcreator.isSeparatorisometrique()) {
								assertEquals((caisson.getProfondeurint() - ((Piece2D)piece).getMaterial().getEpaisseur())/2 ,
										piece.getZpos(), ParametersUtils.epsilon);
							}else {
								if(drcreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
									assertEquals(drcreator.getSeparationposition(), piece.getZpos(), ParametersUtils.epsilon);

								}else {
									assertEquals(caisson.getProfondeurint() - drcreator.getSeparationposition()-((Piece2D)piece).getMaterial().getEpaisseur() ,
											piece.getZpos(), ParametersUtils.epsilon);
								}

							}
							if (drcreator.getPorttype().equals(PortType.COLISSANT)) {
								if (piece.getZpos() > (caisson.getProfondeurext() - ParametersUtils.retraitcolissant)) {
									fail("le position du separateur sur l'axe z doit inferieur a la Profondeur du caisson avec la soustraction du retrait colissant");
								}
							} else {
								if (piece.getZpos() > caisson.getProfondeurext()) {
									fail("le position du separateur sur l'axe z doit inferieur a la Profondeur du caisson ");
								}
							}
						}

					}
				}
			}
		}
	}
	protected void CheckCaissonSeparatorNormalePositions(DressingCreator drcreator) {
		// tester les positions du separateur dans le caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {

			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
						if (drcreator.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
							assertEquals(ParametersUtils.dosRainurePositionOffset+ParametersUtils.jeurainuredos+
									drcreator.getBackmaterial().getEpaisseur(), piece.getZpos(), ParametersUtils.epsilon);
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getYpos(),
									ParametersUtils.epsilon);
							if(drcreator.isSeparatorisometrique()) {
								assertEquals((caisson.getLongeurint() - ((Piece2D)piece).getMaterial().getEpaisseur())/2 +caisson.getBasematerial().getEpaisseur(),
										piece.getXpos(), ParametersUtils.epsilon);
							}else {
								if(drcreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
									assertEquals(caisson.getBasematerial().getEpaisseur() + drcreator.getSeparationposition(),
											piece.getXpos(), ParametersUtils.epsilon);
								}else {
									assertEquals(caisson.getLongeurint() +caisson.getBasematerial().getEpaisseur() - drcreator.getSeparationposition()-((Piece2D)piece).getMaterial().getEpaisseur() ,
											piece.getXpos(), ParametersUtils.epsilon);
								}

							}
					
							if (piece.getZpos() > caisson.getLongeurext()) {
								fail("le position du separateur sur l'axe X doit inferieur a la Longeur du caisson ");
							}
						} else if (drcreator.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getXpos(),
									ParametersUtils.epsilon);
							assertEquals(ParametersUtils.dosRainurePositionOffset+ParametersUtils.jeurainuredos+
									drcreator.getBackmaterial().getEpaisseur(), piece.getZpos(), ParametersUtils.epsilon);
							if(drcreator.isSeparatorisometrique()) {
								assertEquals((caisson.getHauteurint() - ((Piece2D)piece).getMaterial().getEpaisseur())/2 +caisson.getBasematerial().getEpaisseur(),
										piece.getYpos(), ParametersUtils.epsilon);
							}else {
								if(drcreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
									assertEquals(caisson.getBasematerial().getEpaisseur() + drcreator.getSeparationposition(),
											piece.getYpos(), ParametersUtils.epsilon);
								}else {
									assertEquals(caisson.getHauteurint() +caisson.getBasematerial().getEpaisseur() - drcreator.getSeparationposition()-((Piece2D)piece).getMaterial().getEpaisseur() ,
											piece.getYpos(), ParametersUtils.epsilon);
								}

							}
							
							if (piece.getYpos() > caisson.getHauteurext()) {
								fail("le position du separateur sur l'axe Y doit inferieur a la Hauteur du caisson ");
							}
						} else if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getXpos(),
									ParametersUtils.epsilon);
							assertEquals(caisson.getBasematerial().getEpaisseur(), piece.getYpos(),
									ParametersUtils.epsilon);
							if(drcreator.isSeparatorisometrique()) {
								assertEquals((caisson.getProfondeurint() - ((Piece2D)piece).getMaterial().getEpaisseur())/2 ,
										piece.getZpos(), ParametersUtils.epsilon);
							}else {
								if(drcreator.getSepPosRefType().equals(PositionReferenceType.BAS)) {
									assertEquals(drcreator.getSeparationposition(), piece.getZpos(), ParametersUtils.epsilon);

								}else {
									assertEquals(caisson.getProfondeurint() - drcreator.getSeparationposition()-((Piece2D)piece).getMaterial().getEpaisseur() ,
											piece.getZpos(), ParametersUtils.epsilon);
								}

							}
							if (drcreator.getPorttype().equals(PortType.COLISSANT)) {
								if (piece.getZpos() > (caisson.getProfondeurext() - ParametersUtils.retraitcolissant)) {
									fail("le position du separateur sur l'axe z doit inferieur a la Profondeur du caisson avec la soustraction du retrait colissant");
								}
							} else {
								if (piece.getZpos() > caisson.getProfondeurext()) {
									fail("le position du separateur sur l'axe z doit inferieur a la Profondeur du caisson ");
								}
							}
						}

					}
				}
			}
		}
	}
	protected void CheckSeparatorDos(DressingCreator drcreator) {
		// tester le conflits de l'existence de dos et separateur dans le caisson
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			Boolean dosexist = false;
			boolean septransversalexist=false;
			//
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR))) {
						dosexist = true;
					}
					if ((((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT))) {
						septransversalexist = true;
					}
				}
				//
				if (septransversalexist) {
					if (dosexist) {
						fail("l'existence de dos interieur avec un separateur est non supporter ");
					}
				}
			}
		}
		// ce bloc tester les dimention (longeur,lardeur,profendeur) et les
		// position(x,y,z) des dos dans le separator univers
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			//
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {

						for (DesignObject3D space : ((Separator) piece).getChilds()) {

							for (DesignObject3D piece2d : space.getChilds()) {
								// verifier que l'axe de separation est diffirent de Z et si le cas le zone doit
								// different du zoneHaut
								if (drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
									if (((Space3D) space).getZonetype().equals(Zone3DType.ZONEHAUT)) {
										fail("le dos dans un space3D de type ZONE_HAut dans un sep avec sepaxe Z est non supporter");
									}
								}
								if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
									assertEquals(space.getHauteurint() + (2 * ParametersUtils.dosRainureProf),
											piece2d.getHauteurext(), ParametersUtils.epsilon);
									assertEquals(space.getLongeurint() + (2 * ParametersUtils.dosRainureProf),
											piece2d.getLongeurext(), ParametersUtils.epsilon);
									assertEquals(caisson.getBackmaterial().getEpaisseur(), piece2d.getProfondeurext(),
											ParametersUtils.epsilon);
									assertEquals(ParametersUtils.dosRainurePositionOffset, piece2d.getZpos(),
											ParametersUtils.epsilon);
									assertEquals(
											caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
											piece2d.getXpos(), ParametersUtils.epsilon);
									assertEquals(
											caisson.getBasematerial().getEpaisseur() - ParametersUtils.dosRainureProf,
											piece2d.getYpos(), ParametersUtils.epsilon);
								}
							}

						}
						//

					}
				}
			}
		}

		//
		
	}
	protected void CheckCaissonPieceMaterial(DressingCreator drcreator) {
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			//
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)
							||((Piece2D) piece).getPiecetype().equals(PieceType.DOS_EXTERIRUR)) {
						assertEquals(drcreator.getBackmaterial(),piece.getBackmaterial());
					}
					if (((Piece2D) piece).getPiecetype().equals(PieceType.HAUT_CUISSON)
							||((Piece2D) piece).getPiecetype().equals(PieceType.BAS_CUISSON)
							||((Piece2D) piece).getPiecetype().equals(PieceType.DROITE_CUISSON)
							||((Piece2D) piece).getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
						assertEquals(drcreator.getBasematerial(),piece.getBasematerial());
					}
					
					
					
					if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {

						for (DesignObject3D space : ((Separator) piece).getChilds()) {
							assertEquals(drcreator.getBasematerial(),piece.getBasematerial());
							for (DesignObject3D piece2d : space.getChilds()) {
								
								if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
									assertEquals(drcreator.getBackmaterial(),piece.getBackmaterial());								
								}
							}

						}
						//

					}
				}
			}
		}
	}
	protected void CheckCaissonDosExistence(DressingCreator drcreator) {
		//tester l'existence de dos dans le caisson 
		for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
			//
			Boolean dointexist=false;
			Boolean doextexist=false;
			for (DesignObject3D piece : caisson.getChilds()) {
				if (piece instanceof Piece2D) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
						dointexist=true;
					}
					if(((Piece2D) piece).getPiecetype().equals(PieceType.DOS_EXTERIRUR)) {
						doextexist=true;
					}
				}	
			}
			if(!drcreator.isWithseprator()) {
				if(!doextexist&& !dointexist) {
					fail("il faut ajouter un dos pour le caisson");
				}
			}
		}
		//tester l'existence de de dos dans les espace3D de le Separator
		if(drcreator.getDostype().equals(DosType.DOSINTERIEUR)) {
			for (DesignObject3D caisson : drcreator.getDressingInstance().getChilds()) {
				//
				
				for (DesignObject3D piece : caisson.getChilds()) {
					if (piece instanceof Piece2D) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
							for (DesignObject3D space : ((Separator) piece).getChilds()) {
								int dosintexist=0;
								for (DesignObject3D piece2d : space.getChilds()) {
									if (((Piece2D) piece2d).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
										dosintexist+=1;
									}
								}
								if(!(drcreator.getSeprationaxe().equals(SeprationAxe.ZAXIS)
										&&((Space3D)space).getZonetype().equals(Zone3DType.ZONEHAUT)))
								{
									assertEquals(1, dosintexist);
								}
							}
						}
						
						
					}	
				}
				
			}
		}
		
		
	}
	/**
	 * tester si le parent able to hold the child 
	 * 
	 */
	protected void checkCanHold(DesignObject3D parent) {
		for (DesignObject3D child : parent.getChilds()) {
			assertEquals(true, parent.canHold(child));
			checkCanHold(child);
		}	
	}
}
