package gdxapp.quotation;

import java.util.Comparator;
import java.util.TreeSet;

import org.frs.svg.Line;

import com.badlogic.gdx.math.Vector3;


public class SameDirQuotComparator implements Comparator<Object3DQuotation> {

	private static SameDirQuotComparator instance = new SameDirQuotComparator();
	
	private SameDirQuotComparator() {}
	
	@Override
	public int compare(Object3DQuotation o1, Object3DQuotation o2) {
		Line line = new Line(new Vector3(), o1.getDirection(false));
		Vector3 a = null;
		Vector3 b = null;
		Vector3 o10 = line.prj(o1.getO0());
		Vector3 o11 = line.prj(o1.getO1());
		a = (o10.dst(line.getPoint()) >  o11.dst(line.getPoint()))?o11:o10;
		Vector3 o20 = line.prj(o2.getO0());
		Vector3 o21 = line.prj(o2.getO1());
		b = (o20.dst(line.getPoint()) >  o21.dst(line.getPoint()))?o21:o20;
		return (int) Math.signum(a.dot(line.getDirection()) - b.dot(line.getDirection()));
	}

	public static SameDirQuotComparator getInstance() {
		return instance;
	}

	public static void setInstance(SameDirQuotComparator instance) {
		SameDirQuotComparator.instance = instance;
	}
	
	
	public static void main(String...strings) {
		Object3DQuotation quot0 = new Object3DQuotation(new Vector3(1,2,0), new Vector3(3,2,0), null);
		Object3DQuotation quot1 = new Object3DQuotation(new Vector3(4,0,6), new Vector3(0.5f,0,6), null);
		TreeSet<Object3DQuotation> treeSet = new TreeSet<Object3DQuotation>(SameDirQuotComparator.getInstance());
		treeSet.add(quot0);
		treeSet.add(quot1);
		for(Object3DQuotation quot: treeSet) {
			System.err.println(quot);
		}
		

	}
	

}
