package dressing.handlers.cam;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import dressing.cam.model.Tool;
import dressing.cam.model.MachineCodeHandler;
import dressing.cam.model.Usinage;
import dressing.model.Accessoire;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;

public class GenerateGcode {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	
	@Inject 
	EPartService partService;
	
	@Execute
	public void execute(Shell shell){

		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		if (o instanceof Space3DFree && o!= null) {
			Space3DFree element=(Space3DFree)o;
			try {
//				generate(piece);
				element.refresh();
			} catch (Exception e) {
					Dialog di=new Dialog(shell) {

						@Override
						protected Control getDialogArea() {
							Label label=new Label(shell, SWT.NONE);
							label.setText("un erreur est servenue lors de génération de Gcode"+e.getMessage());
							return label;
						}
						
					};
			}
		}else
			if (o instanceof Kitchen && o!= null) {
			Kitchen kitchen=(Kitchen)o;
//			for(DesignObject3D designObject3D : kitchen.getElements()) {
//				try {
//					generate(designObject3D);
//				} catch (DesignException e) {
//						Dialog di=new Dialog(shell) {
//
//							@Override
//							protected Control getDialogArea() {
//								Label label=new Label(shell, SWT.NONE);
//								label.setText("un erreur est servenue lors de génération de Gcode"+e.getMessage());
//								return label;
//							}
//							
//						};
//				}
//			}
			kitchen.generateElementsUsinage();
			MessageDialog.openInformation(shell, "Succèes", "Cuisine usinage généré avec succèes");

		}else if(o instanceof SuperCadProject && o!=null) {
			SuperCadProject project=(SuperCadProject)o;
			project.generateElementsUsinage();
			MessageDialog.openInformation(shell, "Succèes", "Projet usinage généré avec succèes");
		}
	}
	
	@CanExecute
	public boolean check() {
		Object o = selectionService.getSelection("dressing.part.projectexplorer");
		if (o instanceof Space3DFree || o instanceof Kitchen || o instanceof SuperCadProject) {
			return true;
		}
		
		return false;
	}

}
