package dressing.reporting.data.handle;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import dressing.config.ReportingPreferences;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import org.frs.debitage.engine.core.evalutor.GeometricEngineException;
import dressing.model.stock.ModelAccessoire;
import dressing.ui.util.PriceToTextConverter;
import dressing.ui.util.StaticUiObjects;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject;
import param.MechanicDesign;

public class ProjectCoupe {
	private SuperCadProject project;
	private String userName;
	private String clientName;
	private String date;
	private String dateString;

	private String adresse;
	private String comment;
	private String clientPhonenumbers;
	private String companyMail;
	private String companyWebSite;
	private String companyAdresse = "GP9 ROUTE DE LA MARSA -AIN ZAGHOUAN-2076";
	private String companyName = "CUISINE EN LIGNE";
	private String TechnicienName;
	private String technicienPhoneNumber;
	private String projectPlanNumber;
	private String projectName;
	private List<DesignCoupe> dressings;
	private double totalProjectCost = 0;
	private String sTotalProjectCost;
	private double totaldesignCost = 0;
	private String stotalDesignCost;
	private double totalAccessoiresCost = 0;
	private String stotalAccessoiresCost;
	private double totalQuincailleriesCost = 0;
	private String stotalQuincailleriesCost;

	private AccessoireGroupCoupe accessoires;
	private AccessoireGroupCoupe Quincailleries;

	private String BoxMaterial;
	private String facadeMaterial;
	private String dosMaterial;

	private double brutHT;
	private double totalRemise;
	private double totalTax;
	private double netHT;
	private double timbre = 1;
	private double totalTTC;
	private double netAPayer;

	private List<ArticleReport> articles = new ArrayList<ArticleReport>();
	private List<BaseTaxable> baseTaxables = new ArrayList<BaseTaxable>();
	private List<ReportPage> pages = new ArrayList<ReportPage>();

	private boolean isDevis = false;
	private DocumentValuesGroup totals = new DocumentValuesGroup();

	public SuperCadProject getProject() {
		return project;
	}

	public void setProject(SuperCadProject project) {
		this.project = project;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public ProjectCoupe(boolean isDevis, SuperCadProject project) {
		super();
		this.project = project;
		this.isDevis = isDevis;
		init();
	}

	private void init() {

		// Define a custom formatter for the desired format
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE, 'le' d MMMM yyyy", Locale.FRENCH);

		// Format the LocalDateTime object using the formatter
		String formattedDate = getProject().getCreationDate().format(formatter);
		formattedDate = uppercaseFirstCharacter(formattedDate);

		this.dateString = formattedDate;
		this.date = getProject().getCreationDate().toLocalDate()
				.format(DateTimeFormatter.ofPattern("dd/MM/yyyy", Locale.FRENCH));
		this.userName = this.project.getCommercial();
		this.clientName = this.project.getClient();
		this.clientPhonenumbers = this.project.getClientNumber();
		this.projectName = getProject().getName();

		if (!this.isDevis) {
			this.BoxMaterial = this.project.getCurrentKitchen().getBackMaterial().getName();
			this.facadeMaterial = this.project.getCurrentKitchen().getFaceMaterial().getName();
			this.dosMaterial = this.project.getCurrentKitchen().getBackMaterial().getName();
		}
		dressings = new ArrayList<DesignCoupe>();
		if (!isDevis) {
			int i = 1;
			for (DesignObject3D el : this.project.getCurrentKitchen().getElements()) {
				DesignCoupe dressing = new DesignCoupe(el, el.getName(), String.valueOf(i), el.getLongeurext(),
						el.getHauteurext(), el.getProfondeurext());
				dressings.add(dressing);
			}
			createAccessoireAndQuicaillerieGroup();
		}
		// create list article designs
		int i = 1;
		if (!this.project.getCurrentKitchen().getElements().isEmpty()) {
			List<ModelAccessoire> accesoires = new ArrayList<ModelAccessoire>();
			List<ArticleReport> articlesdesigns = new ArrayList<ArticleReport>();

			createArticlesFromDesign(accesoires, articlesdesigns);
			// compact the list of articles design
			articlesdesigns=ArticleReport.compactArticleReports(articlesdesigns);
			for (ArticleReport art : articlesdesigns) {
				art.setNb(String.valueOf(i++));
			}
			double nbArticle = articlesdesigns.stream().mapToDouble(ArticleReport::getNumber).sum();
			ArticleReport articletile = new ArticleReport("Eléments ( " + ((int) nbArticle) + " )", "", 1, 0, 0, 0,
					null, true);
			articlesdesigns.add(0, articletile);
			this.articles.addAll(articlesdesigns);

			// fomuler les articles des accessoires
			if (!accesoires.isEmpty()) {
				List<ArticleReport> articlesAccessoires = new ArrayList<ArticleReport>();
				for (ModelAccessoire acc : accesoires) {
					ArticleReport articleacc = createArticleReportFromAccessoire(acc);

					articlesAccessoires.add(articleacc);

				}
				// grouper les accessoires et les indexée
				articlesAccessoires = ArticleReport.compactArticleReports(articlesAccessoires);
				for (ArticleReport art : articlesAccessoires) {
					art.setNb(String.valueOf(i++));
				}
				double nbAccessoire = articlesAccessoires.stream().mapToDouble(ArticleReport::getNumber).sum();
				ArticleReport articleAccessoiretile = new ArticleReport("Accessoires( " + ((int) nbAccessoire) + " )",
						"", 1, 0, 0, 0, null, true);

				articlesAccessoires.add(0, articleAccessoiretile);
				this.articles.addAll(articlesAccessoires);
			}
		}

		//
		calculateTotals();
		createTotalsAttributes();
		// this.baseTaxables=createBaseTaxableList(getArticles());
		// create pagination for articles
		this.pages = generateReportPages(this.articles, 25, 25);

	}

	private void calculateTotals() {
		// calculate BRUT H.T
		this.brutHT = this.articles.stream().mapToDouble(ArticleReport::getBrutHT).sum();
		this.totalRemise = this.articles.stream().mapToDouble(ArticleReport::getMontantRemise).sum();
		this.totalTax = this.articles.stream().mapToDouble(ArticleReport::getMontantTva).sum();
		this.netHT = this.articles.stream().mapToDouble(ArticleReport::getTotal_Net_HT).sum();
		this.totalTTC = this.articles.stream().mapToDouble(ArticleReport::getTotalTTC).sum() + timbre;
		this.netAPayer = this.totalTTC;
	}

	private void createArticlesFromDesign(List<ModelAccessoire> accesoires, List<ArticleReport> articlesdesigns) {
		for (WorldObject object : this.project.getCurrentKitchen().getScene().getSceneObjects()) {
			if(object instanceof KitchenElement) {
				KitchenElement element = (KitchenElement) object;
				DesignObject3D el = ((KitchenElement) object).getDesignObject();
				ArticleReport article = createArticleFromDesignObject(el);
//				article.setHandle(element.getDoorHandle());
//				article.setHandlerCount(element.getHandlerCount());
				accesoires.addAll(((Space3DFree) el).getAccessoires().stream()
						.filter(acc -> acc.getAccessoire().isStandAlone()).toList());
				articlesdesigns.add(article);

			}
			
		}
	}

	private ArticleReport createArticleReportFromAccessoire(ModelAccessoire acc) {
		ArticleReport articleacc = new ArticleReport(acc.getName(), acc.getArticle().getCode(), acc.getNumber(),
				acc.getAccessoire().getAccessoire().getPrix(), acc.getAccessoire().getAccessoire().getRemise(),
				acc.getAccessoire().getAccessoire().getTva(), null, false);
		return articleacc;
	}

	private ArticleReport createArticleFromDesignObject(DesignObject3D element) {
		MechanicDesign design = element.getMechanicDesignDefinition();
		double remise = design.getRemise();
		ArticleReport article = new ArticleReport(design.getName(), design.getCode(), 1, design.getPrice(), remise,
				design.getTva(), design, false);
		// generate accessoire and quicaillerie from model
		try {
			MechanicDesignCreator.getInstance().updateAccessoiresAndQuincailleries(element, design, null);

		} catch (DesignException e) {
			e.printStackTrace();
		} catch (GeometricEngineException e) {
			e.printStackTrace();
		}
		List<ModelAccessoire> articlesdesigns = ((Space3DFree) element).getAccessoires().stream()
				.filter(acc -> !acc.getAccessoire().isStandAlone()).toList();
		article.setAccessories(articlesdesigns);
		return article;
	}

	private void createAccessoireAndQuicaillerieGroup() {
		this.totalProjectCost = dressings.stream().mapToDouble(DesignCoupe::getTotaldesignCost).sum();
		sTotalProjectCost = StaticUiObjects.decimalMoneyFormat.format(totalProjectCost);

		this.totaldesignCost = dressings.stream().mapToDouble(DesignCoupe::getDesignCost).sum();
		this.stotalDesignCost = StaticUiObjects.decimalMoneyFormat.format(totaldesignCost);

		this.totalAccessoiresCost = dressings.stream().mapToDouble(DesignCoupe::getTotalAccessoiresCost).sum();
		this.stotalAccessoiresCost = StaticUiObjects.decimalMoneyFormat.format(totalAccessoiresCost);

		this.totalQuincailleriesCost = dressings.stream().mapToDouble(DesignCoupe::getTotalAccessoiresCost).sum();
		this.stotalQuincailleriesCost = StaticUiObjects.decimalMoneyFormat.format(totalQuincailleriesCost);

		accessoires = new AccessoireGroupCoupe(null, true);
		Quincailleries = new AccessoireGroupCoupe(null, false);

		int ordreAcc = 1;
		int ordreQuincaillerie = 1;
		List<ArticleCoupe> articlesAcceessoire = new ArrayList<ArticleCoupe>();
		List<ArticleCoupe> articlesQuincailleries = new ArrayList<ArticleCoupe>();
		Map<param.Article, ArticleCoupe> articlesAccessoiresCoupe = new HashMap<param.Article, ArticleCoupe>();
		Map<param.Article, ArticleCoupe> articlesQuincailleriesCoupe = new HashMap<param.Article, ArticleCoupe>();

		for (DesignCoupe dress : dressings) {

			// grouper Accessoires

			for (ArticleCoupe coupe : dress.getAccessoires().getArticles()) {
				if (!articlesAccessoiresCoupe.containsKey(coupe.getArticle().getArticle())) {
					ArticleCoupe artcoupe = new ArticleCoupe(coupe.getArticle(), ordreAcc++);
					articlesAccessoiresCoupe.put(coupe.getArticle().getArticle(), artcoupe);
					articlesAcceessoire.add(artcoupe);
				} else {
					ArticleCoupe artCoupe = articlesAccessoiresCoupe.get(coupe.getArticle().getArticle());
					artCoupe.setNumber(artCoupe.getNumber() + coupe.getArticle().getNumber());
				}

			}
			// grouper Quincailleries
			for (ArticleCoupe coupe : dress.getQuincailleries().getArticles()) {
				if (!articlesQuincailleriesCoupe.containsKey(coupe.getArticle().getArticle())) {
					ArticleCoupe artcoupe = new ArticleCoupe(coupe.getArticle(), ordreQuincaillerie++);
					articlesQuincailleriesCoupe.put(coupe.getArticle().getArticle(), artcoupe);
					articlesQuincailleries.add(artcoupe);
				} else {
					ArticleCoupe artCoupe = articlesQuincailleriesCoupe.get(coupe.getArticle().getArticle());
					artCoupe.setNumber(artCoupe.getNumber() + coupe.getArticle().getNumber());
				}

			}

		}
		// create accessoire groupe
		accessoires.calculate(articlesAcceessoire);
		Quincailleries.calculate(articlesQuincailleries);
	}

	public static List<BaseTaxable> createBaseTaxableList(List<ArticleReport> articleReports) {
		Map<Double, BaseTaxable> tvaBaseTaxableMap = new HashMap<>();

		for (ArticleReport report : articleReports) {
			double tva = report.getTva();
			double totalHT = report.getTotal_Net_HT();
			double totalTva = report.getMontantTva();

			BaseTaxable baseTaxable = tvaBaseTaxableMap.get(tva);

			if (baseTaxable == null) {
				baseTaxable = new BaseTaxable();
				baseTaxable.setName(formatTvaToString(tva));
				baseTaxable.setTva(tva);
				baseTaxable.setTotalHT(totalHT);
				baseTaxable.setTotalTva(totalTva);
				tvaBaseTaxableMap.put(tva, baseTaxable);
			} else {
				double updatedTotalHT = baseTaxable.getTotalHT() + totalHT;
				double updatedTotalTva = baseTaxable.getTotalTva() + totalTva;
				baseTaxable.setTotalHT(updatedTotalHT);
				baseTaxable.setTotalTva(updatedTotalTva);
			}
		}

		return new ArrayList<>(tvaBaseTaxableMap.values());
	}

	public DocumentValuesGroup getTotals() {
		return totals;
	}

	public DocumentValuesGroup createTotalsAttributes() {
		totals = new DocumentValuesGroup();
		totals.put("BRUT_HT", getMoneyTotalFormat(this.brutHT)).setLabel("BRUT HT :");
		;
		totals.put("TOTAL_REMISE", getMoneyTotalFormat(this.totalRemise)).setLabel("Total Remise HT :");
		totals.put("NET_HT", getMoneyTotalFormat(this.netHT)).setLabel("Total Net HT :");
		totals.put("TOTAL_TVA", getMoneyTotalFormat(this.totalTax)).setLabel("Total TVA :");
		totals.put("TIMBRE", getMoneyTotalFormat(this.timbre)).setLabel("Droit de Timbre :");

		totals.put("TOTAL_TTC", getMoneyTotalFormat(this.totalTTC)).setLabel("TOTAL TTC :");
		Attribute netAPayer = totals.put("NET_A_PAYER", getMoneyTotalFormat(this.netAPayer));
		netAPayer.setLabel("Net à payer :");
		netAPayer.setStyle("font-weight: bold;");
		return totals;
	}

	private static String uppercaseFirstCharacter(String str) {
		if (str == null || str.isEmpty()) {
			return str;
		}
		return Character.toUpperCase(str.charAt(0)) + str.substring(1);
	}

	private static String formatTvaToString(double tva) {
		return String.valueOf((int) tva) + " %";
	}

	public static List<ReportPage> generateReportPages(List<ArticleReport> articleReports, int FIRST_PAGE_ROWS,
			int ROWS_PER_PAGE) {
		List<ReportPage> reportPages = new ArrayList<>();

		int totalReports = articleReports.size();
		int totalPages = (int) Math.ceil((double) totalReports / ROWS_PER_PAGE);

		int startIndex = 0;
		int endIndex = Math.min(FIRST_PAGE_ROWS, totalReports);
		reportPages.add(new ReportPage(articleReports.subList(startIndex, endIndex), 1));

		startIndex = endIndex;
		for (int page = 2; page <= totalPages; page++) {
			endIndex = Math.min(startIndex + ROWS_PER_PAGE, totalReports);
			List<ArticleReport> pageArticles = articleReports.subList(startIndex, endIndex);
			reportPages.add(new ReportPage(pageArticles, page));
			startIndex = endIndex;
		}

		return reportPages;
	}
	
	public void addArticle(ArticleReport article) {
		this.articles.add(article);
		calculateTotals();
		createTotalsAttributes();
	}

	public String getClientName() {
		return clientName == null || clientName.isBlank() ? "" : clientName;
	}

	public void setClientName(String clientName) {
		this.clientName = clientName;
	}

	public List<DesignCoupe> getDressings() {
		return dressings;
	}

	public void setDressings(List<DesignCoupe> dressings) {
		this.dressings = dressings;
	}

	public String getDateString() {
		return dateString;
	}

	public String getDate() {
		return this.date;
	}

	public void setDate(String date) {
		this.date = date;
	}

	public String getAdresse() {
		return adresse == null || adresse.isBlank() ? "" : adresse;
	}

	public void setAdresse(String adresse) {
		this.adresse = adresse;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getBoxMaterial() {
		return BoxMaterial;
	}

	public String getFacadeMaterial() {
		return facadeMaterial;
	}

	public String getDosMaterial() {
		return dosMaterial;
	}

	public String getClientPhonenumbers() {
		return clientPhonenumbers == null || clientPhonenumbers.isBlank() ? "" : clientPhonenumbers;
	}

	public void setClientPhonenumbers(String clientPhonenumbers) {
		this.clientPhonenumbers = clientPhonenumbers;
	}

	public String getCompanyMail() {
		return companyMail;
	}

	public void setCompanyMail(String companyMail) {
		this.companyMail = companyMail;
	}

	public String getCompanyWebSite() {
		return companyWebSite;
	}

	public void setCompanyWebSite(String companyWebSite) {
		this.companyWebSite = companyWebSite;
	}

	public String getTechnicienName() {
		return TechnicienName;
	}

	public void setTechnicienName(String technicienName) {
		TechnicienName = technicienName;
	}

	public String getTechnicienPhoneNumber() {
		return technicienPhoneNumber;
	}

	public void setTechnicienPhoneNumber(String technicienPhoneNumber) {
		this.technicienPhoneNumber = technicienPhoneNumber;
	}

	public String getProjectPlanNumber() {
		return projectPlanNumber;
	}

	public void setProjectPlanNumber(String projectPlanNumber) {
		this.projectPlanNumber = projectPlanNumber;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public double getTotalProjectCost() {
		return totalProjectCost;
	}

	public String getsTotalProjectCost() {
		return sTotalProjectCost;
	}

	public AccessoireGroupCoupe getAccessoires() {
		return accessoires;
	}

	public AccessoireGroupCoupe getQuincailleries() {
		return Quincailleries;
	}

	public boolean isshowAccessoire() {
		boolean isShowAccessoire = ReportingPreferences.getInstance().getProperty("report.accessoire", true);
		return isShowAccessoire && accessoires.getTotalNumber() > 0;

	}

	public boolean isShowQuicaillerie() {
		boolean isShowQuicaillerie = ReportingPreferences.getInstance().getProperty("report.quicaillerie", true);
		return isShowQuicaillerie && Quincailleries.getTotalNumber() > 0;

	}

	public boolean isshowAccessoireAndQuicaillerie() {
		return isshowAccessoire() || isShowQuicaillerie();
	}

	public double getTotaldesignCost() {
		return totaldesignCost;
	}

	public String getStotalDesignCost() {
		return stotalDesignCost;
	}

	public double getTotalAccessoiresCost() {
		return totalAccessoiresCost;
	}

	public String getStotalAccessoiresCost() {
		return stotalAccessoiresCost;
	}

	public double getTotalQuincailleriesCost() {
		return totalQuincailleriesCost;
	}

	public String getStotalQuincailleriesCost() {
		return stotalQuincailleriesCost;
	}

	public List<ArticleReport> getArticles() {
		return articles;
	}

	public List<ReportPage> getPages() {
		return pages;
	}

	public String getMoneyFormat(double val) {
		return StaticUiObjects.decimalMoneyFormat.format(val);
	}

	public String getMoneyTotalFormat(double val) {
		return StaticUiObjects.decimalMoneyTotalFormat.format(val);
	}

	public String getPourcentFormat(double val) {
		return StaticUiObjects.decimalPOURCENTFormat.format(val);
	}

	public double getBrutHT() {
		return brutHT;
	}

	public double getTotalRemise() {
		return totalRemise;
	}

	public double getTotalTax() {
		return totalTax;
	}

	public double getNetHT() {
		return netHT;
	}

	public double getTimbre() {
		return timbre;
	}

	public double getTotalTTC() {
		return totalTTC;
	}

	public List<BaseTaxable> getBaseTaxables() {
		return baseTaxables;
	}

	public double getNetAPayer() {
		return netAPayer;
	}

	public String getMontantEnLettre() {
		return PriceToTextConverter.convertPriceToText(getNetAPayer(), true);
	}

	public String getCompanyAdresse() {
		return companyAdresse;
	}

	public String getCompanyName() {
		return companyName;
	}

}