package dressing.model.debitage;

import java.util.ArrayList;

import dressing.model.Bande;
import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.SupportMeubleBas;
import dressing.model.SupportMeubleHaut;
import dressing.model.evalutor.Equation;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.PieceType;
import dressing.model.types.SupportMeubleBasType;
import dressing.model.types.SupportMeubleHautType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.usinage.Rainure;
/**
 * ce class represente le coeur de calcul pour les piece de type Bande ,
 * pour simplifier le code de calcul des composant 3D en créer un class 
 * pour les piece ou les composant compliquées dans son calcul pour rendre le code readable et maintainable 
 * @author Imed
 *
 */
public class RainureDebitageFormulas extends DebitageFormulas {

	@Override
	public void FILL_DEBITAGE_FORMULAS(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException {
		if(parent==null || child==null)
			throw new DesignException("Formule de debitage : Parent ou child null");
		this.parent = parent;
		this.child = child;
		FILL_USINAGE(parent,child,equations); //les parametres d usine doivent être les premier
		if(parent instanceof Piece2D && child instanceof Rainure)
		{
			Piece2D piece=(Piece2D)parent;
			PieceType pieceType = piece.getPiecetype();
			Rainure rainure=(Rainure) child;
			DesignObject3D parent1=piece.getParentdesign();
			FILL_RAINURE_FROM_PARENT(rainure, equations);
		
		switch (pieceType) {
		case BAS_CUISSON:

			ADDOrUpdateEquation("@this.h@", "@usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.p@", "@Parent.epaisseursecondaire@ + @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
		
			ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ - @usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ ", Equation.CALCULATION_AUTO,equations) ;
			//Imed bug 0001710 correction calcul de debitage de rainure
			ADDOrUpdateEquation("@this.l@", "@Parent.l@ ", Equation.CALCULATION_AUTO,equations) ;//				
			ADDOrUpdateEquation("@this.posx@", " 0", Equation.CALCULATION_AUTO,equations) ;//									
		
			break;
		case DROITE_CUISSON:
			ADDOrUpdateEquation("@this.l@", "@usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.p@", "@Parent.epaisseursecondaire@ + @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
		
			ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
			if(parent1 instanceof CaissonCuisine) {
				CaissonCuisine caisson=(CaissonCuisine) parent1;
				CuisineCaissonType type=caisson.getCaissoncuisineType();
				if(type.equals(CuisineCaissonType.Bas)) {
					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ +@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
				}else if(type.equals(CuisineCaissonType.Bas_sousevier)) {
					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ +@retrait.sousevier@", Equation.CALCULATION_AUTO,equations) ;
				}else {
					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
				}
			}else {
				ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
			}
			ADDOrUpdateEquation("@this.h@", "@Parent.h@ ", Equation.CALCULATION_AUTO,equations) ;//				
			ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_AUTO,equations) ;//
		
			break;
		case GAUCHE_CUISSON:
			ADDOrUpdateEquation("@this.l@", "@usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.p@", "@Parent.epaisseursecondaire@ + @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
		
			ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@ - @usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;

			if(parent1 instanceof CaissonCuisine) {
				CaissonCuisine caisson=(CaissonCuisine) parent1;
				CuisineCaissonType type=caisson.getCaissoncuisineType();
				if(type.equals(CuisineCaissonType.Bas)) {
					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ +@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
				}else if(type.equals(CuisineCaissonType.Bas_sousevier)) {
					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ +@retrait.sousevier@", Equation.CALCULATION_AUTO,equations) ;
				}else {
					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
				}
			}else {
				ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
			}
			ADDOrUpdateEquation("@this.h@", "@Parent.h@ ", Equation.CALCULATION_AUTO,equations) ;//				
			ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_AUTO,equations) ;//
				
			break;
		case HAUT_CUISSON:

			ADDOrUpdateEquation("@this.h@", "@usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.p@", "@Parent.epaisseursecondaire@ + @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
		
			ADDOrUpdateEquation("@this.posy@", " 0", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ ", Equation.CALCULATION_AUTO,equations) ;
			//Imed bug 0001710 correction calcul de debitage de rainure
			ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;//				
			ADDOrUpdateEquation("@this.posx@", " 0", Equation.CALCULATION_AUTO,equations) ;//

			break;
		case SEPRATEUR_TRANSVERSANT:
			break;
			//Imed bug 0001710 correction calcul de debitage de rainure
		case BAS_CUISSON_SOUSEVIER:
			ADDOrUpdateEquation("@this.h@", "@usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.p@", "@Parent.epaisseursecondaire@ + @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
		
			ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ - @usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ ", Equation.CALCULATION_AUTO,equations) ;
			
			ADDOrUpdateEquation("@this.l@", "@Parent.l@ ", Equation.CALCULATION_AUTO,equations) ;//				
			ADDOrUpdateEquation("@this.posx@", " 0", Equation.CALCULATION_AUTO,equations) ;//
			break;
			
		case BANDE_ARRIERE:
			ADDOrUpdateEquation("@this.h@", "@usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.p@", "@Parent.epaisseursecondaire@ + @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
		
			ADDOrUpdateEquation("@this.posy@", " 0", Equation.CALCULATION_AUTO,equations) ;
//			if(parent1 instanceof CaissonCuisine) {
//				CaissonCuisine caisson=(CaissonCuisine) parent1;
//				CuisineCaissonType type=caisson.getCaissoncuisineType();
//				if(type.equals(CuisineCaissonType.Bas)) {
//					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ +@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
//				}else if(type.equals(CuisineCaissonType.Bas_sousevier)) {
//					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ +@retrait.sousevier@", Equation.CALCULATION_AUTO,equations) ;
//				}else {
//					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
//				}
//			}else {
				ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
//			}
			//Imed bug 0001710 correction calcul de debitage de rainure
			ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;//				
			ADDOrUpdateEquation("@this.posx@", " 0", Equation.CALCULATION_AUTO,equations) ;//

			break;
			//Imed bug 1710 end;
			default:
				throw new DesignException(" interdie d'inclue un rainue dans cette piece");
			}
		
			ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
			FILL_RAINURE(rainure, equations);
		}else
		{
			throw new DesignException("Unkown Debitage Formula");
		}
	}
	
	
	protected  void FILL_RAINURE_FROM_PARENT(Rainure rainure,ArrayList<Equation> equations)
	{
		Piece2D father=(Piece2D) rainure.getParentdesign();
		Piece2D mother=(Piece2D) rainure.getMother();
		ADDOrUpdateEquation("@Parent.l@", ""+father.getLongeurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.h@", ""+father.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.p@", ""+father.getProfondeurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.li@", ""+father.getLongeurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.hi@", ""+father.getHauteurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.pi@", ""+father.getProfondeurint(), Equation.CALCULATION_MANUAL,equations);				
		ADDOrUpdateEquation("@Parent.posx@", ""+father.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+father.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+father.getZpos(), Equation.CALCULATION_MANUAL,equations) ;			
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+father.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+father.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;	
		
	}
	private void FILL_RAINURE(Rainure rainure, ArrayList<Equation> equations) {
		ADDOrUpdateEquation("@this.hi@", "@this.h@", Equation.CALCULATION_AUTO,equations) ;
		ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;
		ADDOrUpdateEquation("@this.li@", "@this.l@", Equation.CALCULATION_AUTO,equations) ;
		
	}
}
