package dressing.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;
import java.util.stream.Collectors;

import org.eclipse.emf.common.util.EList;

import dressing.cam.model.Tool;
import dressing.model.types.EtagereReferenceType;
import dressing.model.types.PortType;
import dressing.model.types.TiroireFacadeType;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import gdxapp.object3d.DoorHandle;
import gdxapp.object3d.ObjectModel;
import gdxapp.object3d.WorldObject;
import gdxapp.shaders.PbrMaterial;
import param.DesignClasse;
import param.Material;
import param.MaterialType;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.ModelRoot;
import param.TypeDef;

public class ModelProvider {
	
	public ModelProvider() {}
	
	private static ModelRoot modelroot;
	private static List<Materiaux >materiallist = new ArrayList<Materiaux>();
	private static ProjectParent pparent = new ProjectParent();	
	List<EtagereReferenceType> getTypeReferencelist=new ArrayList<EtagereReferenceType>();
	List<EtagereDistances> listDistance = new ArrayList<EtagereDistances>();
	List<TiroireFacadeType> listFacadeType=new ArrayList<TiroireFacadeType>();
	private static ArrayList<dressing.model.Parameters> listParam=new ArrayList<dressing.model.Parameters>();
	private static ArrayList<Chant> listChant=new ArrayList<Chant>();
	private static ArrayList<Tool> tools=new ArrayList<Tool>();
	private static List<WorldObject> designObjects = new ArrayList<WorldObject>();
	private static Map<Material,Materiaux >defintionmaterialMap = new HashMap<Material,Materiaux>();
	private static Map<Materiaux,Material >cadMaterialMap = new HashMap<Materiaux,Material>();
	public static final HashMap<CATEGORY, List<PbrMaterial>> materials = new HashMap<CATEGORY, List<PbrMaterial>>(); 
	public static final ArrayList<ObjectModel> objectModels = new ArrayList<ObjectModel>();
	
	public static ArrayList<SceneTexture> textures = new ArrayList<SceneTexture>();
	public static ArrayList<DoorHandle> handlers = new ArrayList<DoorHandle>();
	public final static ArrayList<PbrMaterial> tiles = new ArrayList<PbrMaterial>();
	
	private final static HashMap<String,BufferedImage> bufferedImagesHashMap = new HashMap<String, BufferedImage>();
	public static HashMap<UUID, DesignObject3D> libraryArticles = new HashMap<UUID, DesignObject3D>();
	
	public static ProjectParent RootInstance()
	{
		if(pparent!=null)
			return pparent;
		else
		{
			 pparent = new ProjectParent();		
				return pparent;
		}
		
	}
	public static List<Materiaux> getMateriallist() {
		return materiallist;
	}
	public void setMateriallist(List<Materiaux> materiallist) {
		ModelProvider.materiallist = materiallist;
	}

	public static Map<Material, Materiaux> getDefintionmaterialMap() {
		return defintionmaterialMap;
	}
	public static void setDefintionmaterialMap(Map<Material, Materiaux> defintionmaterialMap) {
		ModelProvider.defintionmaterialMap = defintionmaterialMap;
	}
	public static Map<Materiaux, Material> getCadMaterialMap() {
		return cadMaterialMap;
	}
	public static void setCadMaterialMap(Map<Materiaux, Material> cadMaterialMap) {
		ModelProvider.cadMaterialMap = cadMaterialMap;
	}
	public List getTypePortelist() {
		ArrayList l = new ArrayList<>();
		for (PortType val : PortType.values()) {
			l.add(val);
		}
		return l;
	}
	public List getTypeEtagereReferencelist() {
		ArrayList l = new ArrayList<>();
		for (EtagereReferenceType val : EtagereReferenceType.values()) {
			l.add(val);
		}
		return l;
	}
	public List getlistFacadeType() {
		ArrayList l = new ArrayList<>();
		for (TiroireFacadeType val : TiroireFacadeType.values()) {
			l.add(val);
		}
		return l;
	}
	public List<EtagereDistances> getListDistance() {
		return listDistance;
	}
	public void setListDistance(List<EtagereDistances> listDistance) {

		this.listDistance = listDistance;
	
	}
	public  static ArrayList<dressing.model.Parameters> getListParam() {
		return listParam;
	}
	public void setListParam(ArrayList<dressing.model.Parameters> listParam) {
		this.listParam = listParam;
	}
	public static ArrayList<Chant> getListChant() {
		return listChant;
	}
	public static void setListChant(ArrayList<Chant> listChant) {
		ModelProvider.listChant = listChant;
	}
	public static ModelRoot getModelroot() {
		return modelroot;
	}
	public static void setModelroot(ModelRoot modelroot) {
		ModelProvider.modelroot = modelroot;
	}
	public static ArrayList<Tool> getTools() {
		return tools;
	}
	public static void setTools(ArrayList<Tool> tools) {
		ModelProvider.tools = tools;
	}
	public static List<WorldObject> getDesignObjects() {
		return designObjects;
	}
	public static void setDesignObjects(List<WorldObject> designObjects) {
		ModelProvider.designObjects = designObjects;
	}
	public static List<WorldObject> getDesignObjects(String categorie,String classe) {
		List<WorldObject> designs=new ArrayList<WorldObject>();
		if(designObjects !=null && !designObjects.isEmpty()) {
			for(WorldObject object:designObjects) {
				String cat=object.getProperties().getProperty("category");
				String clss=object.getProperties().getProperty("class");
				if( (cat!=null && cat.contentEquals(categorie) ) && (clss!=null && clss.contentEquals(classe) ) ) {
					designs.add(object);
				}
			}
			return designs;
		}
		return designObjects;
	}
	public static List<WorldObject> getDesignObjects(String classe) {
		List<WorldObject> designs=new ArrayList<WorldObject>();
		if(designObjects !=null && !designObjects.isEmpty()) {
			for(WorldObject object:designObjects) {
				String clss=object.getProperties().getProperty("class");
				if(clss!=null && clss.contentEquals(classe)  ) {
					designs.add(object);
				}
			}
			return designs;
		}
		return designObjects;
	}
	public static List<WorldObject> getDesignObjectsByCategory(String category) {
		List<WorldObject> designs=new ArrayList<WorldObject>();
		if(designObjects !=null && !designObjects.isEmpty()) {
			for(WorldObject object:designObjects) {
				String clss=object.getProperties().getProperty("category");
				if(clss!=null && clss.contentEquals(category)  ) {
					designs.add(object);
				}
			}
			return designs;
		}
		return designObjects;
	}
	
	
	public static WorldObject getWorldObjectById(UUID uuid) {
		for(WorldObject object:designObjects) {
			if(object.getUuid() != null && object.getUuid().equals(uuid))
				return object.clone();
		}
		return null;
	}
	
	public static BufferedImage getBufferedImage(String name) {
		BufferedImage bufferedImage = getBufferedImagesHashMap().get(name);
		return bufferedImage;
	}
	
	
	public static synchronized ArrayList<SceneTexture> getTextures() {
		return textures;
	}
	public static synchronized ArrayList<SceneTexture> getTextures(CATEGORY category) {
		return (ArrayList<SceneTexture>) textures.stream().filter(s->s.getCategory()==category).collect(Collectors.toList());
	}
	
	//return the texture either by name or path
	public static SceneTexture getTexture(String path) {
		SceneTexture result = null;
		if(textures != null) {
			for(SceneTexture sceneTexture: textures) {
				try {
					if(sceneTexture.getPath().equals(path)){
						result = sceneTexture;
						break;
					}
				}catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return result;
	}
	
	public static HashMap<String,BufferedImage> getBufferedImagesHashMap() {
		return bufferedImagesHashMap;
	}
	
	public static List<MechanicDesign> getMechanicDesigns(){
		List<MechanicDesign> designs = new ArrayList<MechanicDesign>();
		for(DesignClasse designClass : modelroot.getClasses().getDesignClasse()) {
			for(MechanicDesignGroup mdGroup: designClass.getCategorie()) {
				for(MechanicDesign mechanicDesignX: mdGroup.getMechanicdesign()) {
					designs.add(mechanicDesignX);
				}
				
			}
		}
		return designs;
	}
	
	public static MechanicDesign getMechanicDesignById(UUID uuid) {
		MechanicDesign mechanicDesign = null;
		for(DesignClasse designClass : modelroot.getClasses().getDesignClasse()) {
			for(MechanicDesignGroup mdGroup: designClass.getCategorie()) {
				if(mechanicDesign != null)
					break;
				for(MechanicDesign mechanicDesignX: mdGroup.getMechanicdesign()) {
					if(mechanicDesign != null)
						break;
					if(mechanicDesignX.getModelId().equals(uuid)) {
						mechanicDesign = mechanicDesignX;
						break;
					}
				}
				
			}
		}
		return mechanicDesign;
	}
	
	public static List<PbrMaterial> getMaterialsByCategory(CATEGORY category) {
		List<PbrMaterial> result = materials.get(category);
		if(result == null)
			result = new ArrayList<PbrMaterial>();
		return result;
	}
	
	public static MechanicDesign getMechanicDesignByName(String name) {
		MechanicDesign mechanicDesign = null;
		for(DesignClasse designClass : modelroot.getClasses().getDesignClasse()) {
			for(MechanicDesignGroup mdGroup: designClass.getCategorie()) {
				for(MechanicDesign mechanicDesignX: mdGroup.getMechanicdesign()) {
					if(mechanicDesignX.getName().equals(name)) {
						mechanicDesign = mechanicDesignX;
						break;
					}
				}
			}
		}
		return mechanicDesign;
	}

	public static MaterialType getMaterialTypeByName(String name) {
		MaterialType mtl = null;
		for(MaterialType material: ModelProvider.getModelroot().getMaterialType().getMaterialTypes()) {
			if(material.getName().contentEquals(name)) {
				mtl = material;
				break;
			}
		}
		return mtl;
	}
	
	
	public PbrMaterial getTile(String name) {
		PbrMaterial tile = null;
		for(PbrMaterial mtl: tiles) {
			if(mtl.getName().contentEquals(name)) {
				tile = mtl;
				break;
			}
		}
		return tile;
	}
	public static ArrayList<PbrMaterial> getTiles() {
		return tiles;
	}
	
	
	public static void addPbrMaterial(PbrMaterial mtl, CATEGORY category) {
		List<PbrMaterial> collection = materials.get(category); 
		if(collection == null) {
			collection = new ArrayList<PbrMaterial>();
			materials.put(category, collection);
		}
		collection.add(mtl);
	}
	public static ObjectModel get3DObjectModel(UUID uuid) {
		ObjectModel model = null;
		for(ObjectModel modelX: objectModels) {
			if(modelX.getInfo().getUuid().equals(uuid)) {
				model = modelX;
				break;
			}
		}
		return model;
	}
	public static void addModelObject(ObjectModel model) {
		objectModels.add(model);
	}
	
	public static TypeDef getTypeDef(String key) {
		EList<TypeDef> types = modelroot.getCategorie().getTypedef();
		for (TypeDef type : types) {
			if (type.getKey().contentEquals(key)) {
				return type;
			}
		}
		return null;
	}
	
	public static List<PbrMaterial> getMaterials(){
		ArrayList<PbrMaterial> mtls = new ArrayList<PbrMaterial>();
		for(List<PbrMaterial> list: materials.values())
			mtls.addAll(list);
		return mtls;
	}
	
	// look for a material with a given name, if a category is not supplied we search the entire map
	public static PbrMaterial findMaterial(CATEGORY category, String name) {
		if(category == null) {
			for(Entry<CATEGORY, List<PbrMaterial>> entry: materials.entrySet()) {
				for(PbrMaterial mtl: entry.getValue()) {
					if(mtl.getName() != null && mtl.getName().equals(name))
						return mtl;
				}
			}
		}else {
			List<PbrMaterial> collection = materials.get(category);
			if(collection != null) {
				for(PbrMaterial mtl: collection) {
					if(mtl.getName() != null && mtl.getName().equals(name))
						return mtl;
				}
			}
		}
		return null;
	}

}
