package dressing.handlers;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Caisson;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Etagere;
import dressing.model.Kitchen;
import dressing.model.ModelProvider;
import dressing.model.Project3D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.Tirroir;
import dressing.ui.dressing.DressingWizard;
import param.Material;
import param.impl.MaterialImpl;
import param.impl.ParamFactoryImpl;
import dressing.model.Piece2D;
import dressing.model.Piece2DCoupe;
import dressing.model.Project3D;

public class importMaterialFromExcellHandler {

	@Inject ESelectionService selectionService;
	private static final String LINE_BREAK = "\n";
	private static final String CELL_BREAK = "\t";
	private static final int NAME=0;
	private static final int EPAISSEUR=1;
	private static final int COULOUR=2;
	@Inject
	IEclipseContext  eclipsecontext;
	
	@Execute
	public void execute(Shell shell,ParameterizedCommand cmd ){		

				//Le string builder est termioner on cree le data transfer								
				Clipboard clipboard = new Clipboard(Display.getCurrent());
	    	    TextTransfer textTransfer = TextTransfer.getInstance();
	    	    Transfer[] transfers = new Transfer[]{textTransfer};
	    	    String result=   (String) clipboard.getContents( textTransfer);
	            String[] lines = result.split(LINE_BREAK);
	            for (int i = 0; i < lines.length; i++) { //Scho 946
	                lines[i] = lines[i].replaceAll("\t\t", "\t \t");
	                lines[i] = lines[i].replaceAll("\t\n", "\t   \n");
	                String[] cells = lines[i].split(CELL_BREAK);
	                if(cells.length>=3) {
	                	Material mat= ParamFactoryImpl.eINSTANCE.createMaterial();
	   	                mat.setName(cells[NAME]);
	   	                mat.setEpaisseur(Double.valueOf(cells[EPAISSEUR]));
	   	                mat.setImage(cells[COULOUR]);
	   	                ModelProvider.getModelroot().getMaterialgroup().getMaterial().add(mat);
	                }
	             
	            }  
	    	    System.err.println(result);
	    	    clipboard.dispose();
	}

	@CanExecute
	public boolean check()
	{
		return true;
	}
	

}
