package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.ui.library.ExportModelWizard;

/**
 * @Bug 0001846 
 * exporter un caisson vers la bibliothèque
 * @author Imed
 *
 */
public class exportModelHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){
		Object selection = selectionService.getSelection("dressing.part.tree");
		CaissonCuisine caisson=(CaissonCuisine) selection;
		ExportModelWizard exportModelWizard = ContextInjectionFactory.make(ExportModelWizard.class,eclipsecontext);
		exportModelWizard.setCaisson((CaissonCuisine) caisson.clone());
		WizardDialog dialog = new WizardDialog(shell, exportModelWizard);
		dialog.open();
		
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.tree");
		if(o!=null && o instanceof CaissonCuisine )
		{
			return true;
		}	
		return false;
	}

}
