package reporting;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;

public class ReportWindow {

	protected Shell shlRapportProjet;
	public Browser browser;
	String url="https://www.google.fr/";
	/**
	 * Launch the application.
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			ReportWindow window = new ReportWindow();
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Open the window.
	 */
	public void open() {
		Display display = Display.getDefault();
		createContents();
		shlRapportProjet.open();
		shlRapportProjet.layout();
		while (!shlRapportProjet.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	/**  
	 * Create contents of the window.
	 */
	protected void createContents() {
		shlRapportProjet = new Shell();
		shlRapportProjet.setMinimumSize(new Point(1320, 720));
		shlRapportProjet.setSize(450, 300);
		shlRapportProjet.setText("Rapport Projet");
		shlRapportProjet.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Composite composite = new Composite(shlRapportProjet, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		composite_1.setLayout(new FillLayout(SWT.HORIZONTAL));
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_composite_1.widthHint = 230;
		composite_1.setLayoutData(gd_composite_1);
		
		 browser = new Browser(composite_1, SWT.NONE);
		new Label(composite, SWT.NONE);
		
		Composite composite_2 = new Composite(composite, SWT.NONE);
		GridData gd_composite_2 = new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1);
		gd_composite_2.widthHint = 129;
		gd_composite_2.heightHint = 31;
		composite_2.setLayoutData(gd_composite_2);
		composite_2.setLayout(new GridLayout(2, false));
		
		Button btnImprimer = new Button(composite_2, SWT.NONE);
		btnImprimer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnImprimer.setText("Imprimer");
		
		Button btnFermer = new Button(composite_2, SWT.NONE);
		btnFermer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnFermer.setText("Fermer");
		createReportController();
		shlRapportProjet.setBounds(0, 0, 1366, 720);

		btnFermer.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				ReportWindow.this.shlRapportProjet.close();
			}
			
		});
		btnImprimer.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				ReportWindow.this.browser.execute("javascript:window.print();");
			}
			
		});

	}
	public void createReportController() {
		browser.setText("Génération de rapport en cours");
		System.err.println(browser.getBrowserType());
		this.browser.setUrl(url);
	}
	
	public void setBrowserUrl(String url) {
		this.url=url;
		if(browser!=null) {
			this.browser.setUrl(url);
			
		}
	}
	public void setBrowserText(String text) {
		 browser.setText(text);
	}
	
}
