package dressing.ui.util;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class StringViewerComparator extends ViewerComparator {
	private ILabelProvider labelProvider;
	public StringViewerComparator(ILabelProvider labelProvider) {
		super();
		this.labelProvider=labelProvider;
		
	}
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		String s1=labelProvider.getText(e1);
		String s2=labelProvider.getText(e2);
		Control c=viewer.getControl();
		Table table= (Table) c;
		if(s1!=null && s2!=null) {
			if(table.getSortDirection()==SWT.DOWN)
			{
				return s1.compareTo(s2);
			}else {
				return s2.compareTo(s1);
			}
					
		}
		return super.compare(viewer, e1, e2);
	}
}
