package supercad.graphics;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import com.badlogic.gdx.math.Vector3;

import gdxapp.shaders.PbrMaterial;

public class MtlParser {
	private String content;
	public static MtlParser Mtlparserinstance;

	public static MtlParser getMtlparserinstance() {
		return Mtlparserinstance;
	}

	public ArrayList<PbrMaterial> parse(String content) {
		String separator = "newmtl";
		// loadContent(path);
		ArrayList<PbrMaterial> materials = new ArrayList<PbrMaterial>();
		String[] blocs = content.split(separator);
		for (String bloc : blocs) {
			if (removeBlanks(bloc) == "")
				continue;
			bloc = separator + bloc;
			PbrMaterial mtl = parseMaterialBlock(bloc);
			if (mtl != null) {
				materials.add(mtl);
			}
		}
		return materials;
	}

	private PbrMaterial parseMaterialBlock(String bloc) {
		PbrMaterial material = new PbrMaterial();
		String[] lines = bloc.split("\\n");
		for (String line : lines) {
			try {
				parseAttribute(line, material);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		return material;
	}

	private void parseAttribute(String line, PbrMaterial material) {
		if (line.startsWith("newmtl")) {
			parseMaterialName(line, material);
		} else if (line.contains("map_")) {
			parseTextureAttributePath(line, material);
		} else {
			parseNumericalAttr(removeBlanks(line), material);
		}
	}

	private void parseNumericalAttr(String remplirLine, PbrMaterial material) {
		String[] blocs = remplirLine.split("%");
		if (blocs[1].contains("d") && !blocs[1].contains("K")) {
			String prefix = "d";
			material.setOpacity(extractfloat(remplirLine, prefix));
		} else if (blocs[1].contains("ao")) {
			String prefix = "ao";
			material.setAmbiantOcclusion(extractfloat(remplirLine, prefix));
		} else if (blocs[1].contains("Pm")) {
			String prefix = "Pm";
			material.setMetalness(extractfloat(remplirLine, prefix));
		} else if (blocs[1].contains("Pr")) {
			String prefix = "Pr";
			material.setRoughness(extractfloat(remplirLine, prefix));
		} else if (blocs[1].contains("Kd")) {
			String prefix = "Kd";
			material.setAlbedo(extractVector3(remplirLine, prefix));
		}
	}

	private Vector3 extractVector3(String line, String prefix) {
		Vector3 albedo = new Vector3();
		line = line.replaceFirst(prefix, "");
		line = removeBlanks(line);
		String[] blocs = line.split("%");
		float x = Float.parseFloat(blocs[1]);
		float y = Float.parseFloat(blocs[2]);
		float z = Float.parseFloat(blocs[3]);
		albedo.set(x, y, z);
		return albedo;
	}

	private static Float extractfloat(String line, String prefix) {
		float floatValue = 0;
		line = line.replaceFirst(prefix, "");
		line = removeBlanks(line);
		String[] blocs = line.split("%");
		floatValue = Float.parseFloat(blocs[1]);
		return floatValue;

	}

	public static String removeBlanks(String line) {
		char fillValue = '%';
		char[] linechararray = line.toCharArray();
		String output = "";
		int j = linechararray.length;
		for (char caractere : linechararray) {
			if (Character.isWhitespace(caractere)) {
				output += fillValue;
			} else {
				output += caractere;

			}
		}
		output = output.replaceAll("%+", "%");
		return output;
	}

	private void parseTextureAttributePath(String line, PbrMaterial material) {
		if (line.contains("map_Kd")) {
			material.setAlbedoMapPath(line.replaceAll("map_Kd", "").trim());
		} else if (line.contains("map_Kn")) {
			material.setNormalMapPath(line.replaceAll("map_Kn", "").trim());
		} else if (line.contains("map_Pm ")) {
			material.setMetalnessMapPath(line.replaceAll("map_Pm", "").trim());
		} else if (line.contains("map_Pr")) {
			material.setRoughnessMapPath(line.replaceAll("map_Pr", "").trim());
		}

	}

	private void parseMaterialName(String line, PbrMaterial material) {
		line = line.replaceAll("newmtl", "").replaceAll(" ", "_");
		material.setName(line);
	}

	public void loadContent(String path) {
		try {
			File file = new File(path);
			FileInputStream fileStream = new FileInputStream(file);
			byte[] buffer = new byte[(int) file.length()];
			fileStream.read(buffer);
			this.content = new String(buffer);
		} catch (IOException e) {
			e.printStackTrace();
			System.err.println("error reading file ");
		}

	}
}