package dressing.ui.util;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;

import param.MechanicDesign;
import param.MechanicPublicParam;
import param.TypeDefElement;

public class DesignControlCreationHelper {
	
	
	
	public static void createControlForIntegerParams(MechanicDesign design, String param, Spinner control) {
		boolean valid = false;
		try {
			MechanicPublicParam parametre = design.getPublicParam(param);

			if (parametre != null) {
				String sValue = parametre.getDefaultvalue();
				int value = Integer.valueOf(sValue);
				control.setSelection(value);
				valid = parametre.isChangeable();
			} else {
				valid = false;
			}
		} catch (Exception e) {
			valid = false;
		}
		control.setEnabled(valid);
	}
	
	public static void createControlForBooleanParams(MechanicDesign design, String param, Button control) {
		boolean valid = false;
		try {
			MechanicPublicParam parametre = design.getPublicParam(param);
			if (parametre != null) {
				TypeDefElement elment = parametre.getTypedefelement();
				boolean value = Boolean.valueOf(elment.getKey());
				control.setSelection(value);
				valid = parametre.isChangeable();
			} else {
				valid = false;
			}
		} catch (Exception e) {
			valid = false;
		}
		control.setEnabled(valid);
	}
	
	public static boolean createControlForTypeParams(MechanicDesign design, String param, ComboViewer control) {
		boolean valid = false;
		try {
			MechanicPublicParam parametre = design.getPublicParam(param);
			if (parametre != null) {
				TypeDefElement element = parametre.getTypedefelement();
				control.setSelection(new StructuredSelection(element), true);
				valid = parametre.isChangeable();

			} else {
				valid = false;
			}
		} catch (Exception e) {
			valid = false;
		}

		control.getControl().setEnabled(valid);
		return valid;
	}

}
