/*
 * Decompiled with CFR 0.152.
 */
package api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class RessourceLoader {
    private static final String ressourceFolder = "src" + File.separator + "ressources";

    public String loadResource(String path) {
        try {
            if (path.contains(":")) {
                return this.loadDiskResource(path);
            }
            return this.loadBundleResource("com.sandmonkey.ttf_renderer", path);
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to load resource from " + path);
        }
    }

    private String loadDiskResource(String path) {
        String content = "";
        File file = new File(path);
        try {
            FileInputStream stream = new FileInputStream(file);
            content = new String(((InputStream)stream).readAllBytes());
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public String loadBundleResource(String bundleName, String path) throws URISyntaxException, IOException {
        Bundle bundle = null;
        try {
            bundle = Platform.getBundle((String)bundleName);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("failed to get bundle!");
        }
        String source = null;
        InputStream stream = null;
        if (bundle != null) {
            URL url = bundle.getResource(ressourceFolder + File.separator + path);
            stream = url.openStream();
        } else {
            File file = new File(ressourceFolder + File.separator + path);
            stream = new FileInputStream(file);
        }
        byte[] buffer = stream.readAllBytes();
        stream.close();
        source = new String(buffer);
        return source;
    }

    public String loadBundleResource(String path) throws URISyntaxException, IOException {
        Bundle bundle = null;
        try {
            bundle = FrameworkUtil.getBundle(this.getClass());
        }
        catch (RuntimeException runtimeException) {
            System.err.println("failed to get bundle!");
        }
        String source = null;
        InputStream stream = null;
        if (bundle != null) {
            URL url = bundle.getResource(ressourceFolder + File.separator + path);
            stream = url.openStream();
        } else {
            File file = new File(ressourceFolder + File.separator + path);
            stream = new FileInputStream(file);
        }
        byte[] buffer = stream.readAllBytes();
        stream.close();
        source = new String(buffer);
        return source;
    }

    public static URL getRessourceURL(Bundle bundle, String relativePath) {
        URL url = null;
        if (bundle != null) {
            url = bundle.getResource(ressourceFolder + File.separator + relativePath);
        }
        return url;
    }

    public static String getFilePath(String relativePath) {
        URL url;
        Bundle bundle = null;
        try {
            bundle = FrameworkUtil.getBundle(RessourceLoader.class);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("failed to get bundle!");
        }
        if (bundle != null && (url = RessourceLoader.getRessourceURL(bundle, relativePath)) != null) {
            try {
                String path = Paths.get(url.toURI()).toFile().getAbsolutePath();
                return path;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getFilePath(String bundleName, String relativePath) {
        URL url;
        Bundle bundle = null;
        try {
            bundle = Platform.getBundle((String)bundleName);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("failed to get bundle!");
        }
        if (bundle != null && (url = RessourceLoader.getRessourceURL(bundle, relativePath)) != null) {
            String path = null;
            try {
                path = FileLocator.toFileURL((URL)url).getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return path;
        }
        return null;
    }
}

