/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EngineStrategy implements Enumerator
{
    DELETE(1, "DELETE", "Supprimer"),
    SPLIT(2, "SPLIT", "Deviser"),
    NONE(3, "NONE", "Aucun");

    public static final int DELETE_VALUE = 1;
    public static final int SPLIT_VALUE = 2;
    public static final int NONE_VALUE = 3;
    private static final EngineStrategy[] VALUES_ARRAY;
    public static final List<EngineStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EngineStrategy[]{DELETE, SPLIT, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EngineStrategy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EngineStrategy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EngineStrategy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EngineStrategy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EngineStrategy get(int value) {
        switch (value) {
            case 1: {
                return DELETE;
            }
            case 2: {
                return SPLIT;
            }
            case 3: {
                return NONE;
            }
        }
        return null;
    }

    private EngineStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

