/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.provisional.equinox.p2.jarprocessor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.equinox.internal.p2.jarprocessor.SignCommandStep;
import org.eclipse.equinox.internal.p2.jarprocessor.Utils;
import org.eclipse.equinox.internal.p2.jarprocessor.ZipProcessor;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessor;

public class JarProcessorExecutor {
    protected Options options = null;
    private Set<String> signExclusions = null;

    public void runJarProcessor(Options processOptions) {
        block7: {
            this.options = processOptions;
            if (this.options.input.isFile() && this.options.input.getName().endsWith(".zip")) {
                ZipProcessor processor = new ZipProcessor();
                processor.setWorkingDirectory(this.options.outputDir);
                processor.setOptions(this.options);
                processor.setExecutor(this);
                try {
                    processor.processZip(this.options.input);
                }
                catch (IOException e) {
                    if (this.options.verbose) {
                        e.printStackTrace();
                    }
                    break block7;
                }
            }
            JarProcessor processor = new JarProcessor();
            processor.setWorkingDirectory(this.options.outputDir);
            processor.setProcessAll(this.options.processAll);
            processor.setVerbose(this.options.verbose);
            Properties properties = new Properties();
            if (this.options.input.isDirectory()) {
                this.signExclusions = Utils.getSignExclusions(properties);
            }
            try {
                FileFilter filter = this.createFileFilter(this.options);
                this.process(this.options.input, filter, this.options.verbose, processor, properties);
            }
            catch (FileNotFoundException e) {
                if (!this.options.verbose) break block7;
                e.printStackTrace();
            }
        }
    }

    protected FileFilter createFileFilter(Options processOptions) {
        return Utils.JAR_FILTER;
    }

    protected String getRelativeName(File file) {
        if (this.options.input == null) {
            return file.toString();
        }
        try {
            File input = this.options.input.getCanonicalFile();
            File subFile = file.getCanonicalFile();
            if (input.isFile()) {
                return subFile.getName();
            }
            if (!subFile.toString().startsWith(input.toString())) {
                return file.toString();
            }
            File parent = subFile.getParentFile();
            Object result = subFile.getName();
            while (!parent.equals(input)) {
                result = parent.getName() + "/" + (String)result;
                parent = parent.getParentFile();
            }
            return result;
        }
        catch (IOException iOException) {
            return file.getName();
        }
    }

    private boolean shouldSign(String name) {
        if (this.options.signCommand == null) {
            return false;
        }
        return this.signExclusions == null ? true : !this.signExclusions.contains(name);
    }

    protected void process(File input, FileFilter filter, boolean verbose, JarProcessor processor, Properties packProperties) throws FileNotFoundException {
        if (!input.exists()) {
            throw new FileNotFoundException();
        }
        File[] files = null;
        if (input.isDirectory()) {
            files = input.listFiles();
        } else if (filter.accept(input)) {
            files = new File[]{input};
        } else {
            return;
        }
        int i = 0;
        while (i < files.length) {
            block13: {
                if (files[i].isDirectory()) {
                    this.processDirectory(files[i], filter, verbose, processor, packProperties);
                } else if (filter.accept(files[i])) {
                    try {
                        processor.clearProcessSteps();
                        String name = this.getRelativeName(files[i]);
                        boolean sign = this.shouldSign(name);
                        if (sign) {
                            processor.clearProcessSteps();
                            if (sign) {
                                this.addSignStep(processor, packProperties, this.options);
                            }
                            files[i] = processor.processJar(files[i]);
                        }
                    }
                    catch (IOException e) {
                        if (!verbose) break block13;
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
    }

    protected void processDirectory(File input, FileFilter filter, boolean verbose, JarProcessor processor, Properties packProperties) throws FileNotFoundException {
        if (!input.isDirectory()) {
            return;
        }
        String dir = processor.getWorkingDirectory();
        processor.setWorkingDirectory(dir + "/" + input.getName());
        this.process(input, filter, verbose, processor, packProperties);
        processor.setWorkingDirectory(dir);
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    public void addPackUnpackStep(JarProcessor processor, Properties properties, Options processOptions) {
    }

    public void addSignStep(JarProcessor processor, Properties properties, Options processOptions) {
        processor.addProcessStep(new SignCommandStep(properties, processOptions.signCommand, processOptions.verbose));
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    public void addPackStep(JarProcessor processor, Properties properties, Options processOptions) {
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    public void addUnpackStep(JarProcessor processor, Properties properties, Options processOptions) {
    }

    public static class Options {
        public String outputDir = ".";
        public String signCommand = null;
        @Deprecated(forRemoval=true, since="1.2.0")
        public boolean pack = false;
        @Deprecated(forRemoval=true, since="1.2.0")
        public boolean repack = false;
        @Deprecated(forRemoval=true, since="1.2.0")
        public boolean unpack = false;
        public boolean verbose = false;
        public boolean processAll = false;
        public File input = null;
    }
}

