package supercad.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class XmlTag {

	enum TAG_TYPE{
		OPENING, CLOSING,SELF_CLOSING
	}
	private String value;
	private String tagName;
	
	public XmlTag() {}
	
	public XmlTag(String from) {
		this.value = from;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getTagName() {
		int s;
		if(isOpeningTag()) {
			s = value.indexOf('<');	
		}else {
			s = value.indexOf('/');
		}
		String inter = value.replace("<","").replace(">", "").replace("/", "");
		String[] parts = inter.split("[\s\t]");
		for(String str: parts) {
			if(str.length()> 0)
				return str;
		}
		return tagName;
	}
	
	public HashMap<String, String> getAttrs(){
		String raw  = value.replace("<", "").replace(">", "").replace("/", "").trim();
		raw = raw.substring(getTagName().length()).trim();
		HashMap<String, String> attributes = new HashMap<String, String>();
		if(raw.length() > 0) {
			int index = 0;
			int a = 2;
			ArrayList<String> parts = new ArrayList<String>();
			do {
				char current = raw.charAt(index++);
				if(current == '\"')
					a--;
				if(a == 0) {
					parts.add(raw.substring(0, index));
					raw = raw.substring(index);
					index = 0;
					a = 2;
				}		
			}while(raw.length() > 0);
			
			for(String part: parts) {
				String[] attrRaw = part.split("=");
				attributes.put(attrRaw[0].trim(), attrRaw[1].trim().replace("\"", ""));
			}
		}
		
		
		return attributes;
	}

	public TAG_TYPE getType() {
		String trimmed = value.trim();
		if(trimmed.endsWith("/>")) {
			return TAG_TYPE.SELF_CLOSING;
		}else if(trimmed.startsWith("</")) {
			return TAG_TYPE.CLOSING;
		}else {
			return TAG_TYPE.OPENING;
			
		}
	}

	public boolean isOpeningTag() {
		return !(value.contains("</") || value.contains("/>"));
	}

	public static void main(String...strings) {
		String raw = "</  nig ger is dead>";
		XmlTag tag = new XmlTag(raw);
		System.err.println(tag.getTagName());
	}
	
	
}
