 
package dressing.handlers.gdx;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.utils.Array;

import dressing.model.ProjectManager;
import dressing.ui.Control.MultiObjectActionWidow;
import gdxapp.Commun.GroupSelection;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;

import java.util.ArrayList;

import org.eclipse.e4.core.di.annotations.CanExecute;

public class UpdateAllObject {
	@Execute
	public void execute() {
		MultiObjectActionWidow window = new MultiObjectActionWidow(Display.getDefault().getActiveShell());
		ArrayList<WorldObject> selection=ProjectManager.getManager().getCurrentScene().getSceneObjects();
		if(selection!=null && selection.size()>0) {
			ArrayList<KitchenElement> targets=new ArrayList<KitchenElement>();
			for(int i=0;i<selection.size();i++) {
				WorldObject object=selection.get(i);
				if(object!=null && object instanceof KitchenElement)
				{
					targets.add((KitchenElement) object);
				}
			}
			window.create();
			window.setAllObjects(true);
			window.setTargets(targets);
			window.open();
		}
		
		
	}
	
	
	@CanExecute
	public boolean canExecute() {
		
		return true;
	}
		
}