package dressing.cam.model;

import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Intervale;
import dressing.model.Plan3D;
import dressing.model.debitage.DebitageFormulas;
import dressing.model.types.DesignType;

public class Rainure extends Usinage {

	boolean exist=true;
	
	@Override
	public void updateproperties() throws GeometricEngineException {
		if(getDesignType() !=null && getDesignType().equals(DesignType.GENERIC)) {
			super.updateproperties();
			return;
		}
		DesignObject3D parent=getParentdesign();
		if(parent==null ) {
			throw new GeometricEngineException("le Piece parent de cette rainure "+getName()+" est inexistent il faut l'insérer");
		}
		
		if(getMother()==null) {
			throw new GeometricEngineException("le dos de cette rainure "+getName()+" est inexistent il faut l'insérer");
		}
		double xpos=getXpos();
		double ypos=getYpos();
		double zpos=getZpos();
		
		double longeur=getLongeurext();
		double hauteur=getHauteurext();
		double profondeur=getProfondeurext();
		Plan3D inter = parent.getIntersect(getMother());
		
		Intervale xinter=inter.getXinter();
		Intervale yinter=inter.getYinter();
		Intervale zinter=inter.getZinter();
		
		if(xinter==null||yinter==null||zinter==null) {
			this.exist=false;
		}else {
			this.exist=true;
			try {
				xpos=xinter.getMininter();
				ypos=yinter.getMininter();
				zpos=zinter.getMininter();
				
				longeur=xinter.getlong();
				hauteur=yinter.getlong();
				profondeur=zinter.getlong();

			} catch (NullPointerException e) {
				e.printStackTrace();
			}
			setXpos(xpos-parent.getXPosABS());
			setYpos(ypos-parent.getYPosABS());
			setZpos(zpos-parent.getZPosABS());
			
			setLongeurext(longeur);
			setLongeurint(longeur);
			
			setHauteurext(hauteur);
			setHauteurint(hauteur);

			setProfondeurext(profondeur);
			setProfondeurint(profondeur);
		}

		

	}

	public double getRainureLength() {
		return Math.max(Math.max(getLongeurext(), getHauteurext()), getProfondeurext());
	}
	
	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public DesignObject3D clone() {
		Rainure space=new Rainure();
		try {
			space=(Rainure) this.copy(space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Rainure rainure=(Rainure) object;
		rainure=(Rainure) super.copy(rainure);
		return rainure;
	}
	
	@Override
	public DebitageFormulas getDebitageFormulas() {
		if(formulas==null|| !(formulas instanceof DebitageFormulas)) {
			formulas = new DebitageFormulas();
		}
		return formulas; 
	}
	public static boolean epsilonEquals(float f1, float f2, float epsilon) {
        return (f1 + epsilon >= f2 && f1 - epsilon <= f2);
    }
	
}
