package supercad.httpconnector;

import static org.hamcrest.Matchers.nullValue;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;
import java.net.http.HttpResponse.BodySubscriber;
import java.net.http.HttpResponse.ResponseInfo;
import java.time.LocalDate;

import org.json.simple.JSONObject;

import supercad.api.http.MultiPartBodyBuilder;

public class ConnectorTest {

	public static void main(String...strings) {
		try {
		JSONObject json = new JSONObject();
		json.put("creationDate", LocalDate.now().toString());
		File file = new File("C:\\Users\\nadhe\\OneDrive\\Bureau\\licence.txt");
		MultiPartBodyBuilder bodyBuilder = new MultiPartBodyBuilder();
		bodyBuilder.file(file).metaData(json).build();
		
		HttpClient http = HttpClient.newHttpClient();
		URI uri;
		uri = new URI("http://localhost:8080/file/uploads");
		System.out.println(bodyBuilder.getBody());
		HttpRequest request = HttpRequest.newBuilder()
				.uri(uri)
				.header("Content-Type", "multipart/form-data; boundary=" + bodyBuilder.getBoundary())
				.POST(BodyPublishers.ofString(bodyBuilder.getBody()))
				.build();
		HttpResponse response =  http.send(request, BodyHandlers.ofString());
		System.out.println(response.statusCode() + ":" + response.body());
		} catch (IOException | URISyntaxException | InterruptedException e) {
			System.exit(1);
		}
	}
}
