package dressing.ui;

import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.DoubleViewerComparator;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ListEditorWindow;
import dressing.ui.util.StringViewerComparator;
import param.Chant;
import param.Country;
import param.ParamFactory;

public class CountryListWindow extends ListEditorWindow {

	public CountryListWindow(Shell parentShell, IEventBroker eventBroker) {
		super(parentShell);
	}

	@Override
	protected Composite createClientArea(Composite parent,int style) {
		Composite clientArea = super.createClientArea(parent, style|SWT.MULTI);
		getShell().setText("Liste des pays");
		return clientArea;
	}
	
	public void createColums(TableViewer tableViewer) {
		ColumnLabelProvider nameLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Country ) {
					return ((Country)element).getName()!=null?((Country)element).getName():"";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Nom", true, null, SWT.LEFT, nameLabelProvider, new StringViewerComparator(nameLabelProvider));
		//
		ColumnLabelProvider codePostalLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Country ) {
					return ((Country)element).getCodePostal()!=null?((Country)element).getCodePostal():"";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Code", true, null, SWT.LEFT, codePostalLabelProvider, new StringViewerComparator(codePostalLabelProvider));
		//
		ColumnLabelProvider CodeTelColumnLabelProvider=new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Country ) {
					return String.valueOf(((Country)element).getCodeTel())!=null?String.valueOf(((Country)element).getCodeTel()):"";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Code Internet", true, null, SWT.LEFT, CodeTelColumnLabelProvider, new StringViewerComparator(CodeTelColumnLabelProvider));
		
		//
		ColumnLabelProvider codeNetLabelProvider = new ColumnLabelProvider() {
			public String getText(Object element) {
				if(element !=null && element instanceof Country ) {
					return ((Country)element).getCodeNet()!=null?((Country)element).getCodeNet():"";
				}
				return "";
			}
		};
		createColumn(tableViewer, "Code Téléphone", true, null, SWT.LEFT, codeNetLabelProvider, new StringViewerComparator(codeNetLabelProvider));
		
	}
	@Override
	protected void Add() {
		Country coutry=ParamFactory.eINSTANCE.createCountry();
		coutry.setName("");
		CountryEditorWindow coutryEditorWindow = new CountryEditorWindow(shell,coutry,EditorWindow.create);
		coutryEditorWindow.create();
		int ret=coutryEditorWindow.open();
		if(ret==Window.OK) {
			tableViewer.refresh();
		}
	}

	@Override
	protected void Modify() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Country) {
			CountryEditorWindow coutryEditorWindow = new CountryEditorWindow(shell,(Country) selection.getFirstElement(),EditorWindow.update);
			coutryEditorWindow.create();
			int ret=coutryEditorWindow.open();
			if(ret==Window.OK) {
				tableViewer.refresh();
			}
		}
	}

	@Override
	protected void delete() {
		boolean ret = MessageDialog.openConfirm(shell, "Confirmation de supression","Voulez vous supprimer les composant sélectionner" );
		if(ret) {
			IStructuredSelection selection=tableViewer.getStructuredSelection();
			if(selection!=null&& !selection.isEmpty()) {
				List selections=selection.toList();
				for(Object obj:selections) {
					if(obj!=null && obj instanceof Country) {
						ResourceManagers.getIntance().getChants().getChant().remove(obj);
						ResourceManagers.getIntance().saveChants();
					}
				}
				tableViewer.refresh();
			}
		}
		

	}

	@Override
	protected void view() {
		IStructuredSelection selection=tableViewer.getStructuredSelection();
		if(selection!=null  && selection.getFirstElement()!=null && selection.getFirstElement() instanceof Country) {
			CountryEditorWindow coutryEditorWindow = new CountryEditorWindow(shell,(Country) selection.getFirstElement(),EditorWindow.View);
			coutryEditorWindow.create();
			coutryEditorWindow.open();
			
		}

	}

	@Override
	public List<?> getInput() {
		return ResourceManagers.getIntance().getGestion().getCountries();
	}

	@Override
	protected ViewerFilter createListFilter() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected Composite createSearchArea(Composite parent, int style) {
		// TODO Auto-generated method stub
		return null;
	}

}
