package dressing.mathutils.simulatedannealing;

import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import com.badlogic.gdx.math.Vector3;

public class Solution {
	
	private ArrayList<Vector3> tour;
	private Problem problem;
	
	public Solution(Problem problem){
		this.problem = problem;
	};
	
	//return a neghboring solution
	public Solution(Solution solution) {
	    // Get random positions in the tour
		this.problem = solution.problem;
		Random rnd = new Random();
		int pos1 = rnd.nextInt(problem.points.size());
		int pos2;
		do {
			pos2 = rnd.nextInt(problem.points.size());
		}
		while(pos1 == pos2);
		
		Vector3  swap1 = solution.tour.get(pos1);
		Vector3 swap2 = solution.tour.get(pos2);
		this.tour = new ArrayList<Vector3>();
		for(Vector3 point: solution.tour) {
			if(point == swap1) 
			{
				this.tour.add(swap2);
			}else if(point == swap2) {
				this.tour.add(swap1);
			}else {
				this.tour.add(point);
			}
		}
	}



	void generateSolution(){
		Vector3[] pointsArray = new Vector3[problem.points.size()];
		problem.points.toArray(pointsArray);
		Random rnd = new Random();
		for(int i = 0 ; i < rnd.nextInt(10); i++  ) {
			int first = rnd.nextInt(pointsArray.length);
			int second = rnd.nextInt(pointsArray.length);
			Vector3 bucket = pointsArray[first];
			pointsArray[first] = pointsArray[second];
			pointsArray[second] = bucket;
		}
		this.tour = new ArrayList<Vector3>();
		for(int i = 0; i < pointsArray.length; i++){
			tour.add(pointsArray[i]);
		}
	}
	
	
	float calculateFitness(){
		float distance = 0;
		Vector3[] tourAsArray = new Vector3[tour.size()];
		tour.toArray(tourAsArray);
		for(int i = 0; i < tourAsArray.length - 1; i++) {
			Vector3 vector = tourAsArray[i].cpy();
			distance += vector.add(tourAsArray[i+1].cpy().scl(-1)).len();
		}
		
		return distance;
	}

	public ArrayList<Vector3> getTour() {
		return tour;
	}

	public void setTour(ArrayList<Vector3> tour) {
		this.tour = tour;
	}

	public Problem getProblem() {
		return problem;
	}

	public void setProblem(Problem problem) {
		this.problem = problem;
	}

}
