package reporting.htmlReporting;

import java.util.ArrayList;
import java.util.HashMap;
import org.frs.svg.ProjectionCamera;
import org.frs.svg.DressingDrawingConfig;
import org.frs.svg.SVGRenderingTask;
import org.frs.svg.SvgDrawer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import dressing.model.Piece2D;
import param.MechanicDesign;
import tech.frsdev.solids.Solide3D;

public class DesignObjectSvgDrawer {
	
	private ProjectionCamera camera;
	private SvgDrawer svgDrawer;
	
	private Solide3D design;
	private DressingDrawingConfig config;
	private ArrayList<Piece2D> drawablePieces = new ArrayList<Piece2D>();
	private HashMap<String, Piece2D> shelfs = new HashMap<String, Piece2D>();
	private HashMap<String, Piece2D> seperators = new HashMap<String, Piece2D>();
	private HashMap<String, Piece2D> facades = new HashMap<String, Piece2D>();
	private HashMap<String, Vector2> ids = new HashMap<String, Vector2>();
	
	public String draw(Solide3D design, DressingDrawingConfig config) {
		clear();
		this.design = design;
		this.config = config;
		prepareCamera();
		scanForPieces();
		//render the dressing
		SVGRenderingTask drawPieces = createEenderingPiecesTask(); 
		svgDrawer = new SvgDrawer();
		svgDrawer.setStrokeColor(config.getStrokeColor());
		svgDrawer.begin(camera);
		svgDrawer.addRenderable(drawPieces);
		svgDrawer.render(camera);
		return svgDrawer.end();
	}

	private void clear() {
		drawablePieces.clear();
		shelfs.clear();
		seperators.clear();
		ids.clear();
	}





	//store the pieces that might generate cots
	private void scanForPieces() {
		ArrayList<Piece2D> pieces = new ArrayList<Piece2D>();
		design.getChildrenByType(Piece2D.class, pieces);
		ArrayList<Piece2D> facadesAndBacks = new ArrayList<Piece2D>();
		for(Piece2D piece: pieces) {
			drawablePieces.add(piece);	
		}
		pieces.removeAll(facadesAndBacks);
	}
	
	public boolean isPrintable(Piece2D piece) throws Exception {
		Vector3 size = piece.getSize();
		MechanicDesign md = piece.getMechanicDesignDefinition();
		boolean parentIsTiroire;
		try{
			parentIsTiroire = md.getPublicParam("SPACE_TYPE").getTypedefelement().getKey().contentEquals("TIROIR");
		}catch (Exception e) {
			parentIsTiroire = false;
		}
		//only production materials should be printed
		if(!piece.getMaterialType().getMaterial().isProduction())
			return false;
		//facades of tiroirs should be printed anyway
		if(parentIsTiroire) {
			return piece.getPiecetype().isFacade();
		}
		
		//either a back or a facade
		if(size.z <= Math.min(size.x, size.y) + 0.00001f) {
			if(!config.isPrintFacades()) {
				return false;
			}else {
				return piece.getPiecetype().isFacade();
			}
			
		}
		return true;

	}

	private void prepareCamera() {
		Vector3 dressingSize = design.getSize();
		float hfov = (float) Math.toDegrees(2 * Math.atan( dressingSize.x * 0.66f)); 
		float aspectRatio = dressingSize.y/dressingSize.x;
		if(config.getHeight() > 0)
			config.setWidth(Math.round(config.getHeight()/aspectRatio));
		camera = new ProjectionCamera(1.0f, hfov, dressingSize.y/dressingSize.x, config.getWidth());
		camera.setPosition(dressingSize.cpy().scl(0.5f).add(0,0,5));
		camera.lookAt(dressingSize.cpy().scl(0.5f));
	}

	private SVGRenderingTask createEenderingPiecesTask() {
		SVGRenderingTask task = new SVGRenderingTask(config.getMode());
		for(Piece2D piece: drawablePieces) {
			task.addRenderable(piece.toSVGBox());
		}
		return task;
	}
	
}
