 
package dressing.handlers;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;

public class SaveSuperCadProjectAs {
	@Execute
	public void execute(Shell shell) {
		FileDialog dialog = new FileDialog(shell,SWT.SAVE);
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperCadProject");
		String defaultpath=projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryWrite", defaultpath);
		dialog.setFilterPath(dirpath);
		SuperCadProject project=ProjectManager.getManager().getCurrentProject();
		String originName=project.getName();
		dialog.setFileName(project.getName());
		String filePath = dialog.open();
		if(filePath!=null && !filePath.isEmpty())
		{
			String tmpfolder=WorkspaceConfiguration.getProjectsPath() +File.separator+"tmp" ;
			File fTmpFolder=new File(tmpfolder);
			if (!fTmpFolder.exists()) {
				fTmpFolder.mkdirs();
				 System.err.println(fTmpFolder.setExecutable(true));	
			        System.err.println(fTmpFolder.setReadable(true));
			        System.err.println(fTmpFolder.setWritable(true,false));
			} 
			 File f = new File(filePath);
			 project.setName(f.getName());
			 String path=tmpfolder+File.separator+ project.getName();	
			 File f1=new File(path);
			
			ProjectManager.getManager().saveProject(project,path,false,false);
			 project.setName(originName);

			 
			 if(f.getParent()!=null)
			 {	
				 try {
			       FileOutputStream fos = new FileOutputStream(filePath+".cad");
				
			        ZipOutputStream zipOut = new ZipOutputStream(fos);
			        File fileToZip = f1;
			 
			        IOUtilities.zipFile(fileToZip, fileToZip.getName(), zipOut);
			        zipOut.close();
			        fos.close();
			        System.err.println(f1.setWritable(true)+" "+f1.setExecutable(true)+"  "+f1.setReadable(true));
			    	IOUtilities.deleteFolder(f1);
			 	} catch (FileNotFoundException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				 dirpath = f.getParent();
				 projectpref.put("directoryWrite", dirpath);
				 try {
					projectpref.flush();
				} catch (BackingStoreException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			 }
		}
	}
	
	
	@CanExecute
	public boolean canExecute() {
		return   ProjectManager.getManager().getCurrentProject()!=null;
//		return true;
	}

}