package org.frs.html;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;

import org.frs.utilities.StringUtilities;

public class HtmlPreprocessor {

	public final String OPENING_DELIMETER = "{{";
	public final String CLOSING_DELIMETER = "}}";
	public final static String FOR_EACH_TAG = "foreach";
	public final static String COLLECTION_ATTR_NAME = "collection";
	public final static String CONDITIONED_TAG = "if";
	public final static String CONDITION_ATTR_NAME = "condition";
	
	

	private final HashMap<String, Object> binding = new HashMap<String, Object>();
	private CrudeHtmlElement doc;
	private int collectionTracker = -1;
	public HtmlPreprocessor() {

	}

	private ArrayList<String> getTags(String crude) {
		Stack<Character> stack = new Stack<Character>();
		stack.push('>');
		stack.push('<');
		String tmpTag = "";
		ArrayList<String> tags = new ArrayList<String>();
		boolean read = false;
		for (int i = 0; i < crude.length(); i++) {
			if (read)
				tmpTag += crude.charAt(i);
			if (crude.charAt(i) == stack.lastElement()) {
				stack.pop();
				if (!stack.isEmpty()) {
					read = true;
					tmpTag += crude.charAt(i);
				} else {
					tags.add(new String(tmpTag));
					tmpTag = "";
					read = false;
					stack.push('>');
					stack.push('<');
				}
			}
		}
		return tags;
	}

	public void preprocess(CrudeHtmlElement doc, HashMap<String, Object> binding) {
		this.binding.clear();
		this.binding.putAll(binding);
		this.doc = doc;
		CrudeHtmlElement extendedElement;
		while (!doc.getChildrenByType(FOR_EACH_TAG).isEmpty()) {
			extendedElement = doc.getChildrenByType(FOR_EACH_TAG).get(0);
			preprocessFroEachBlock(extendedElement);
		}

		while (!doc.getChildrenByType(CONDITIONED_TAG).isEmpty()) {
			extendedElement = doc.getChildrenByType(CONDITIONED_TAG).get(0);
			preprocessConditionedBlock(extendedElement);
		}

	}

	public static String findNextRef(String text) {
		int start = text.indexOf("{{");
		if (start >= 0) {
			int end = text.indexOf("}}");
			if (end > start) {
				return text.substring(start, end + 2);
			}
		}
		return null;
	}

	private void preprocessConditionedBlock(CrudeHtmlElement element) {
		String conditionAttr = element.getAttr(CONDITION_ATTR_NAME);
		boolean condition = (Boolean)JavaCodeEvaluator.getInstance().evaluate(conditionAttr, binding, false);
		CrudeHtmlElement parent = element.getParent();
		if(condition){
			int index = parent.getChildren().indexOf(element);
			parent.getChildren().addAll(index, element.getChildren());
		}
		parent.removeChild(element);

	}

	private void preprocessFroEachBlock(CrudeHtmlElement element) {
		String attr = StringUtilities.removeUnprintableChars(element.getAttr(COLLECTION_ATTR_NAME));
		String iterableRef = attr.substring(0, attr.indexOf(":"));
		String collectionRef = attr.substring(attr.indexOf(":") + 1, attr.length());

		Object iterable = JavaCodeEvaluator.getInstance().evaluate(collectionRef, this.binding, false);
		if (iterable != null) {
			int length = 0;
			CrudeHtmlElement[] elements;
			if (iterable.getClass().isArray()) {
				length = Array.getLength(iterable);
			} else if (iterable instanceof List) {
				List list = (List) iterable;
				length = list.size();
			} else if (iterable instanceof Set) {
				Set set = (Set) iterable;
				length = set.size();
			}

			elements = new CrudeHtmlElement[length];
			for (int i = 0; i < length; i++) {
				elements[i] = element.copy();
				String ref = collectionRef;
				if (iterable.getClass().isArray()) {
					ref += "[" + i + "]";
				} else {
					ref += ".get(" + i + ")";
				}
				for (CrudeHtmlElement child : elements[i]) {
					child.setContent(child.getContent().replace(iterableRef, ref).replace("$index$", i+""));
					for (HtmlElementAttribute attrX : child.getAttributes()) {
						attrX.setValue(attrX.getValue().replace(iterableRef, ref).replace("$index$", i+""));
					}
				}
			}
			element.getChildren().clear();
			for (CrudeHtmlElement elementX : elements) {
				for (CrudeHtmlElement child : elementX.getChildren()) {
					element.addChild(child);
				}
			}
			CrudeHtmlElement[] elementArray = new CrudeHtmlElement[0];
			element.getParent().replaceChild(element, element.getChildren().toArray(elementArray));
		}

	}
}