package supercad.persistence.databinding;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import supercad.runtime.ReflectionUtils;
import supercad.xml.XmlNode;

public class TypeRegister {
	
	private static HashMap<String, Class> typeAlias = new HashMap<String, Class>();	

	
	public static Class getType(String name) {
		return typeAlias.get(name);
	}
	
	public static Class getType(XmlNode node)  {
		Class clazz = null;
		String type = node.getAttr("type");
		if(type != null) {
			try {
				clazz = Class.forName(type);
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			}
		}else {
			clazz = typeAlias.get(node.getName());
			if(clazz == null) {
				try {
					clazz = Class.forName(node.getName());
				} catch (ClassNotFoundException e) {
					e.printStackTrace();
				}
			}
		}
		return clazz;
	}
	
	
	public static Field getField(String name, Class clazz) {
		return null;
	}

	public static Field getField(Class clazz, String name) {
		ArrayList<Field> fields = new ArrayList<Field>();
		ReflectionUtils.getFields(clazz, fields);
		for(Field fieldX: fields) {
			if(fieldX.getName().equals(name))
				return fieldX;
		}
		return null;
	}

}
