package dressing.ui;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import param.MDFThickness;
import dressing.ui.util.DoubleToStringConvertor;
import dressing.ui.util.NumericConvertor;

public class EppaisseurEditorWindow extends EditorWindow {
	private MDFThickness eppaisseur;
	private MDFThickness eppaisseurOrigin;
	Composite parentComposite;
	private Composite clientArea;
	private Text txtName;
	private Text txteppaisseur;

	public EppaisseurEditorWindow(Shell parentShell,MDFThickness frs,int update) {
		super(parentShell,update);	
		this.eppaisseur=frs;
		this.eppaisseurOrigin=EcoreUtil.copy(frs);
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEp = new Label(clientArea, SWT.NONE);
		lblEp.setText("Eppaisseur");
		
		txteppaisseur =DoubleTextFieldFactory.createDoubleTextField(clientArea,SWT.BORDER);
		txteppaisseur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		this.shell.setText("Editeur Éppaisseur du Panneaux");
		parent.requestLayout();
		if(eppaisseur!=null) {
			initDataBindings();
		}
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		String originName =txtName.getText().trim();
//		double originEp = Double.valueOf(txtEp.getText().trim());

		this.eppaisseur.setName(originName);
//		this.frs.setEpaisseur(originEp);
		if(getUpdateMode()==EditorWindow.create) {
			ResourceManagers.getIntance().getGestion().getMdfThicknesses().add(eppaisseur);
		}
		ResourceManagers.getIntance().saveGestion();
		finish();
		return true;
	}
	
	@Override
	protected void cancel() {
		this.eppaisseur.setName(this.eppaisseurOrigin.getName());

	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		return !errorExist;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameChantObserveValue = PojoProperties.value("name").observe(eppaisseur);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameChantObserveValue, null, null);
		//
		IObservableValue observeTextTxteppaisseurObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txteppaisseur);
		IObservableValue thicknessEppaisseurObserveValue = PojoProperties.value("thickness").observe(eppaisseur);
		UpdateValueStrategy strategy = new UpdateValueStrategy();
		strategy.setConverter(new DoubleToStringConvertor());
		UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
		strategy_1.setConverter(new NumericConvertor());
		bindingContext.bindValue(observeTextTxteppaisseurObserveWidget, thicknessEppaisseurObserveValue, strategy, strategy_1);
		//
		return bindingContext;
	}
}
