package dressing.ui;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleTextFieldFactory {

    public static Text createDoubleTextField(Composite parent,int style ) {
        final Text textField = new Text(parent, SWT.NONE|style);

        // Set layout data to fill available horizontal space
//        textField.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        // Add VerifyListener to restrict input to double values
        textField.addVerifyListener(new VerifyListener() {
            @Override
            public void verifyText(VerifyEvent e) {
                // Allow empty or null input
//                if (e.text.isEmpty()) {
//                    e.doit = true;
//                   
//                    return;
//                }
               
                // Regular expression to match double values
                // Allows: positive/negative numbers with or without decimal points
                // Example valid inputs: "123.45", "-45.67", "0.123", ".45", "-.67"
                if(e.text.contentEquals(",")) {
                	e.text=".";
                }
                String regex = "(-)?(\\d+)?(\\.\\d*)?";
                String currentText = textField.getText();
                String proposedText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
                if(proposedText.isEmpty())
                {
                	e.text="0.0";
                }
                e.doit = proposedText.matches(regex);
            }
        });

        return textField;
    }
}