package dressing.reporting.data.handle;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class ReportConfigDialog extends Dialog {
	private DocumentValuesGroup documentValuesGroup;
	/**
	 * Create the dialog.
	 * @param parentShell
	 * @param documentValuesGroup 
	 */
	public ReportConfigDialog(Shell parentShell, DocumentValuesGroup documentValuesGroup ) {
		super(parentShell);
		this.documentValuesGroup=documentValuesGroup;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(new GridLayout(2, true));
		Label lbl=new Label(container, SWT.NONE);
		lbl.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1));
		lbl.setText("Les totaux à afficher");		
		createAttributesUI(container);
		getShell().setText("Configuation Rapport Du Devis");
		return container;
	}

	private void createAttributesUI(Composite container) {
		for(Attribute att:documentValuesGroup.list()) {
			Button btn = new Button(container, SWT.CHECK);
			btn.setText(att.getLabel());
			btn.setSelection(att.isVisible());
			SelectionListener buttonListener=new SelectionListener() {
				
				@Override
				public void widgetSelected(SelectionEvent e) {
					att.setVisible(btn.getSelection());
				}
				
				@Override
				public void widgetDefaultSelected(SelectionEvent e) {
					// TODO Auto-generated method stub
					
				}
			};
			btn.addSelectionListener(buttonListener);

		}
		
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
//		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return super.getInitialSize();
	}
	@Override
	protected void okPressed() {
		documentValuesGroup.removeInvisible();
		super.okPressed();
	}
}
