package dressing.handlers;

import java.util.List;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;

import com.badlogic.gdx.math.Vector3;
import Guillotine.OperationCoin;
import Guillotine.OperationRainure;
import Guillotine.OperationTree;
import Guillotine.OperationTrou;
import dressing.cam.model.*;
import dressing.model.Cavity;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import modeljtree.ArticleTree;
import modeljtree.ModelTree;
import modeljtree.PieceTree;
import param.Chant;
import dressing.cam.model.Cercle2D;
import dressing.cam.model.Cuboid;

import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Util;
import dressing.config.ReportingPreferences;

public class TransformCadToCoup {
	public static ModelTree transformcuisineToModelTree(Kitchen kitchen) {
		ModelTree model=new ModelTree(-1);
		model.setId(-1);
		model.setRef(kitchen.getProject().getName());
		model.setClient(kitchen.getProject().getClient());
		model.setProject(kitchen.getProject().getName());
		for(DesignObject3D elt:kitchen.getElements()) {
			model.getV_art().add(transformElementToArticleTree((Space3D) elt));
		}
		return model;
	}
	public static ArticleTree transformElementToArticleTree(Space3D elt) {
		ArticleTree art=new ArticleTree();
		art.setDES_ART(elt.getName()+"_"+ ((int)elt.getLongeurext()));
		art.setREF_ART(elt.getName()+"_"+ ((int)elt.getLongeurext()));
		art.setQT_ART(1);
		for(Piece2D piece:elt.getListPieces()) {
			if(piece.getMaterialType()!=null && piece.getMaterialType().getMaterial()!=null && piece.getMaterialType().getMaterial().isProduction())
			{
				art.getV_piece().add(transformPiece2DToPieceTree(piece));
			}
		}
		return art;
	}
	public static PieceTree transformPiece2DToPieceTree(Piece2D piece) {
		PieceTree tree = new PieceTree();
		tree.setName(getPieceName(piece, tree));
		tree.setQuantite(1);
		tree.setMateriauname(piece.getMaterial().getName().trim());
		tree.setArticle_name(piece.getRoot().getName().trim());
		;
		PlanUsinage plan1 = piece.getPrimaryPrespective();
		PlanUsinage plan2 = piece.getSecondaryPrespective();

		List<Cuboid> cuboidsPlan1 = Util.getcuboidsforPlan(plan1, piece);
		List<Cercle2D> cereclesPlan1 = Util.gettrousforPlan(plan1, piece);
		List<Cuboid> cuboidsPlan2 = Util.getcuboidsforPlan(plan2, piece);
		List<Cercle2D> cereclesPlan2 = Util.gettrousforPlan(plan2, piece);
		PlanUsinage plan = plan1;
		List<Cuboid> cuboids;
		List<Cercle2D> cercles;
		int nb1 = 0;
		if (cuboidsPlan1 != null) {
			nb1 += cuboidsPlan1.size();
		}
		if (cereclesPlan1 != null) {
			nb1 += cereclesPlan1.size();
		}
		int nb2 = 0;
		if (cuboidsPlan2 != null) {
			nb2 += cuboidsPlan2.size();
		}
		if (cereclesPlan2 != null) {
			nb2 += cereclesPlan2.size();
		}
		if (nb1 > nb2) {
			plan = plan1;
			cuboids = cuboidsPlan1;
			cercles = cereclesPlan1;

		} else {
			plan = plan2;
			cuboids = cuboidsPlan2;
			cercles = cereclesPlan2;
		}
		float h = (float) Util.getPieceH(piece, plan);
		float l = (float) Util.getPieceL(piece, plan);
		tree.setHauteur(String.valueOf(h));
		tree.setLargeur(String.valueOf(l));

		boolean isSenseFil = ReportingPreferences.getInstance().getProperty("superoupe.SenseFil", true);
		boolean ispredebitchant = ReportingPreferences.getInstance().getProperty("superoupe.predebitchant", true);
		boolean isSenseFilInverse = ReportingPreferences.getInstance().getProperty("superoupe.SenseFilInverse", false);

		Vector3 dim = Util.getMaterialDependentDimention(piece, isSenseFil, ispredebitchant,isSenseFilInverse);
		tree.setHauteur(String.valueOf(dim.y));
		tree.setLargeur(String.valueOf(dim.x));

		Vector3 dimwithoutany = Util.getMaterialDependentDimention(piece, isSenseFil, false,isSenseFilInverse);
		BigDecimal widthorigin = new BigDecimal(dimwithoutany.x,Util.context).movePointRight(3);
		BigDecimal hightorigin = new BigDecimal(dimwithoutany.y,Util.context).movePointRight(3);
		BigDecimal dimx = new BigDecimal(dim.x,Util.context).movePointRight(3);
		BigDecimal dimy = new BigDecimal(dim.y,Util.context).movePointRight(3);
		BigDecimal lbigdeicimal=new BigDecimal(l,Util.context).movePointRight(3);
		// remplir les chants
		Map<PlanUsinage, BigDecimal> chantsMap = fixChant(piece, tree,lbigdeicimal.compareTo(widthorigin) !=0);

		for (Cuboid cub : cuboids) {
			BigDecimal x = new BigDecimal(cub.getxPos(),Util.context).movePointRight(3);
			BigDecimal y = new BigDecimal(cub.getyPos(),Util.context).movePointRight(3);
			BigDecimal cubl = new BigDecimal(cub.getLongeur(),Util.context).movePointRight(3);
			BigDecimal cubH = new BigDecimal(cub.getHauteur(),Util.context).movePointRight(3);
			if (lbigdeicimal.compareTo(widthorigin) !=0) {
				x = y;
				y = hightorigin.subtract(new BigDecimal(cub.getxPos(),Util.context).movePointRight(3)).subtract(cubl);
				cubl = cubH;
				cubH = new BigDecimal(cub.getLongeur(),Util.context).movePointRight(3);
			}
			if (ispredebitchant) {
				x = x.subtract(chantsMap.get(PlanUsinage.LEFT));
				y = y.subtract(chantsMap.get(PlanUsinage.DOWN));
				if (x.compareTo(BigDecimal.ZERO.setScale(x.scale())) == -1) {
					cubl = cubl.subtract(x.abs());
					x = BigDecimal.ZERO;
				}
				if (y.compareTo(BigDecimal.ZERO.setScale(x.scale())) == -1) {
					cubH = cubH.subtract(y.abs());
					y = BigDecimal.ZERO;
				}
				if (x.add(cubl).compareTo(dimx) == 1) {
					BigDecimal xmax = x.add(cubl);
					cubl = cubl.subtract(xmax.subtract(dimx).abs());
				}

				if (y.add(cubH).compareTo(dimy) == 1) {
					cubH = dimy.subtract(y.add(cubH));
				}
			}
			cub.setxPos(x.movePointLeft(3).doubleValue());
			cub.setyPos(y.movePointLeft(3).doubleValue());
			cub.setLongeur(cubl.movePointLeft(3).doubleValue());
			cub.setHauteur(cubH.movePointLeft(3).doubleValue());
			tree.getOperationslist().add(transformUsinageToOperationTree(cub, l, h));
		}
		for (Cercle2D cercle : cercles) {
			BigDecimal xpos = new BigDecimal(cercle.getxPos(),Util.context).movePointRight(3);
			BigDecimal ypos = new BigDecimal(cercle.getyPos(),Util.context).movePointRight(3);

			if (lbigdeicimal.compareTo(widthorigin) !=0) {
				xpos = ypos;
				ypos = hightorigin.subtract(new BigDecimal(cercle.getxPos(),Util.context).movePointRight(3));
			}
			if (ispredebitchant) {
				xpos = xpos.subtract(chantsMap.get(PlanUsinage.LEFT));
				ypos = ypos.subtract(chantsMap.get(PlanUsinage.DOWN));
			}
			cercle.setxPos(xpos.movePointLeft(3).doubleValue());
			cercle.setyPos(ypos.movePointLeft(3).doubleValue());
			tree.getOperationslist().add(transformUsinageToOperationTree(cercle, l, h));
		}
		return tree;
	}
	/**
	 * @param piece
	 * @param pieceCoupe
	 * @return 
	 */
	private static String getPieceName(Piece2D piece, PieceTree pieceCoupe) {
		boolean isAppartementName = ReportingPreferences.getInstance().getProperty("superoupe.addappartmentNameToPieceName", true);
		boolean isAddArticleName = ReportingPreferences.getInstance().getProperty("superoupe.addelementNameToPieceName", true);
		boolean isAddCaissonName = ReportingPreferences.getInstance().getProperty("superoupe.addCaissonNameToPieceName", true);
		boolean isAddModName = ReportingPreferences.getInstance().getProperty("superoupe.addModuleNameToPieceName", true);
		boolean isABVName = ReportingPreferences.getInstance().getProperty("superoupe.isABVName", true);
		boolean isABVcaissonName = ReportingPreferences.getInstance().getProperty("superoupe.isABVCaissonName", true);
		String caissonNameReplacers = ReportingPreferences.getInstance().getProperty("superoupe.caissonNameReplacers", "");
		
		String name =piece.getName();
		pieceCoupe.setMontage(name);
		if(isABVName) {
			name =piece.getNameABV(1);
		}
//		String appartement="";
		DesignObject3D root = piece.getRoot();
		//check  
		String caissonName=root.getName();
		if(caissonNameReplacers!=null && !caissonNameReplacers.isEmpty()) {
			String[] replacers=caissonNameReplacers.split(",");
			if(replacers.length>0) {
				for(int i=0;i<replacers.length;i++) {
					String[] dual=replacers[i].split(":");
					if(caissonName.contains(dual[0])) {
						caissonName=caissonName.replaceAll(dual[0], dual[1]);
					}
				}
			}
		}
		//dressing
		if (isAddArticleName || isAddCaissonName) {
			if(isABVcaissonName) {
				name=getNameABV( 1,root.getName()).trim()+"_"+ ((int)root.getLongeurext()/10)+ "_" +name.trim();
			}else {
				name=caissonName.trim()+"_"+ ((int)root.getLongeurext()/10)+ "_" +name.trim();
			}
		}
		
		return name;
	}
	public static String getNameABV(int number,String name) {
		String[] string =name.replaceAll("\\s+", " ").split(" ");
		String abv="";
		int i=0;
		System.err.println(name);
		for( String s:string) {
			abv+=s.length()>number?s.substring(0, number):s.substring(0, 1);
			if(string.length-1> i)
				abv=abv.concat(".");
			i++;	
		}
		return abv;
	}
	
	public static Map<PlanUsinage,BigDecimal> fixChant(Piece2D piece,PieceTree tree,boolean isSenseReversed){
		//initialisation
		BigDecimal leftchantEP = BigDecimal.ZERO;
		BigDecimal rightChantEP = BigDecimal.ZERO;
		BigDecimal topChantEP = BigDecimal.ZERO;
		BigDecimal bottomChantEP = BigDecimal.ZERO;
		//calcul des chant
		Map<PlanUsinage,Chant> chants=Util.getChants(piece, isSenseReversed);
		Chant leftchant = chants.get(PlanUsinage.LEFT);
		Chant rightChant = chants.get(PlanUsinage.RIGHT);
		Chant topChant =chants.get(PlanUsinage.TOP);
		Chant bottomChant = chants.get(PlanUsinage.DOWN);
		Map<PlanUsinage ,BigDecimal> chantsMap=new HashMap<PlanUsinage, BigDecimal>();		
		//chack chants and assign them to the piecetree in the correct order
		if (leftchant != null) {
			tree.setChaunt_gauche(Util.formatChantForSuperCoupe(leftchant));
			leftchantEP = new BigDecimal(leftchant.getEpaisseur(), Util.context).movePointRight(3);
			tree.setId_chaunt_gauche(0);
		} else {
			tree.setId_chaunt_gauche(-2);
		}

		if (rightChant!=null) {
			tree.setChaunt_droit(Util.formatChantForSuperCoupe(rightChant));
			rightChantEP = new BigDecimal(rightChant.getEpaisseur(), Util.context).movePointRight(3);
			tree.setId_chaunt_droit(0);
		} else {
			tree.setId_chaunt_droit(-2);
		}

		if (topChant!=null) {
			tree.setChaunt_haut(Util.formatChantForSuperCoupe(topChant));
			topChantEP = new BigDecimal(topChant.getEpaisseur(), Util.context).movePointRight(3);
			tree.setId_chaunt_haut(0);
		} else {
			tree.setId_chaunt_haut(-2);
		}

		if (bottomChant!=null) {
			tree.setChaunt_bas(Util.formatChantForSuperCoupe(bottomChant));
			bottomChantEP = new BigDecimal(bottomChant.getEpaisseur(), Util.context).movePointRight(3);
			tree.setId_chaunt_bas(0);
		} else {
			tree.setId_chaunt_bas(-2);
		}

		chantsMap.put(PlanUsinage.LEFT,leftchantEP);
		chantsMap.put(PlanUsinage.RIGHT,rightChantEP);
		chantsMap.put(PlanUsinage.TOP,topChantEP);
		chantsMap.put(PlanUsinage.DOWN,bottomChantEP);
		return chantsMap;
	}
	
	public static OperationTree transformUsinageToOperationTree(Cuboid usin, double l, double h) {
		OperationTree tree;
		boolean iscoins=false;
		int coin=0;
		if(usin.getUsin() instanceof Cavity) {
			if(usin.getxPos()==0&& usin.getyPos()==0) {
				iscoins=true;
				coin=1;
			}
			if(usin.getxPos()+usin.getLongeur()==l && usin.getyPos()==0) {
				iscoins=true;
				coin=2;
			}
			if(usin.getxPos()+usin.getLongeur()==l && usin.getyPos()+usin.getHauteur()==h) {
				iscoins=true;
				coin=3;
			}
			if(usin.getxPos()==0 && usin.getyPos()+usin.getHauteur()==h) {
				iscoins=true;
				coin=4;
			}
			
			
		}
		if(iscoins) {
			tree=new OperationCoin();
			((OperationCoin) tree).setCoin(coin);
			((OperationCoin) tree).setXdim(usin.getLongeur());
			((OperationCoin) tree).setYdim(usin.getHauteur());
		
		}
		else {
			tree=new OperationRainure();
			double ep = usin.getLongeur();
			double longeur = usin.getHauteur();
			double x= usin.getxPos();
			double y=usin.getyPos();
			boolean rainureLine = ReportingPreferences.getInstance().getProperty("superoupe.VueRainureLine", false);
			double rainureDepassement = ReportingPreferences.getInstance().getProperty("superoupe.rainureDepassement", 0.0);

			
			if(usin.getUsin() instanceof Rainure) {
				//rendre rainure un ligne
				if(rainureLine) {
					if(ep<longeur) {
						x+=(ep/2);
						ep=0;
					}else {
						y+=(longeur/2);
						longeur=0;
					}
				}
				if(ep<longeur) {
					y-=rainureDepassement;
					longeur+=rainureDepassement*2;
				}else {
					x-=rainureDepassement;
					ep+=rainureDepassement*2;
				}
			}
			((OperationRainure) tree).setEpaisseur(ep);
			((OperationRainure) tree).setLongeur(longeur);
			((OperationRainure) tree).setProfondeur(usin.getDepth());
			((OperationRainure) tree).setXpos(x);
			((OperationRainure) tree).setYpos(y);
			
		}
		
		return tree;
	}
	public static OperationTree transformUsinageToOperationTree(Cercle2D usin, double l, double h) {
		OperationTree tree;
		
		
			tree=new OperationTrou(usin.getDiameter(), usin.getxPos(), usin.getyPos());
			((OperationTrou) tree).setDepth(usin.getDepth());
		
		return tree;
	}
}
