package com.frs.supercad.parametric_model.model;

import java.util.EventObject;

public class ValueChangedEvent extends EventObject{

	private static final long serialVersionUID = 5319035450641692301L;
	
	private Object value;
	private String reference;
	
	private ValueChangedEvent(Object source) {
		super(source);
	}
	
	

	public ValueChangedEvent(Object source, Object value) {
		super(source);
		this.value = value;
	}
	
	public ValueChangedEvent(Object source, Object value, String reference) {
		super(source);
		this.value = value;
		this.reference = reference;
	}



	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}
	



	public String getReference() {
		return reference;
	}



	public void setReference(String reference) {
		this.reference = reference;
	}



	@Override
	public String toString() {
		return "ValueChangedEvent [value=" + value + ", source=" + source + "reference=" + reference +"]";
	}
	
}
