package dressing.ui.stock;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.ResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.ui.editorWindows.ArticleEditorWindow;
import dressing.ui.util.ImageLoaderCache;
import param.Accessoire;
import param.Article;
import param.ArticleFamily;
import param.ArticleFamilyGroup;
import param.BaseObject;
import param.ParamFactory;
import param.Quincaillerie;

import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import dressing.ui.editorWindows.*;
public class StockListWidow extends org.eclipse.jface.window.Window {
	

	ArticleFamilyGroup familiesGroup;
	String filterText="";
	String filterAticleText="";

	public StockListWidow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM | SWT.APPLICATION_MODAL|SWT.FILL_WINDING);
		setBlockOnOpen(true);
	}

	public Shell shell;

	private static StockListWidow instance;
	private Table tableAccessoires;
	private TreeViewer treeViewer;
	private TableViewer tableViewerAccessoires;
	private Text txtSearch;
	private Text searchArticle;
	private Tree tree;
	private Composite buttonBarQuincaillerie;
	private Button btnAddQuincaillerie;
	private SashForm sashForm;
	private TableColumn tblclmnAFamille;
	private TableViewerColumn tableViewerClmnAFamille;
	private TableColumn tblclmnAPrix;
	private TableViewerColumn tableViewerColumnAPrice;
	private TableColumn tblclmnACode;
	private TableViewerColumn tableViewerColumnACode;
	private TableColumn tblclmnANom;
	private TableViewerColumn tableVwrClmnAName;
	private ScrolledComposite scrolledComposite;
	private Composite holderComposite;
	private Composite clientAreaComposite;
	private Composite tableHolderAccessoires;
	private Composite rightShoulder;
	private TabFolder tabFolder;
	private TabItem tbtmAccessoires;
	private TabItem tbtmQuincaillerie;
	private Table tableQuicaillerie;
	private TableViewer tableViewerQuicaillerie;
	private TableColumn tblclmnQName;
	private TableViewerColumn tblVColumnQName;
	private TableColumn tblColumnQCode;
	private TableViewerColumn tblVColumnQCode;
	private TableColumn tblColumnQPrice;
	private TableViewerColumn tblvColumnQPrice;
	private TableColumn tblColumnQFamily;
	private TableViewerColumn tblVColumnQFamily;
	private Composite tableQuincaillerieHolder;
	private Composite buttonBarAccessoires;
	private Button btnAddAccessoires;
	private Button btnModifyAccessoire;
	private Button btnDeleteAccessoire;
	private Button btnViewAccessoire;
	private Button btnViewQuincaillerie;
	private Button btnModifyQuincaillerie;
	private Button btnDeleteQuincaillerie;
	public static StockListWidow getInstance(Shell shell2) {
		synchronized (StockListWidow.class) {
			if (instance == null) {
				instance = new StockListWidow(shell2);
				instance.create();
				instance.constrainShellSize();
				instance.setBlockOnOpen(true);
				instance.getShell().setMaximized(true);

			}
			return instance;
		}
	}
	@Override
	public void create() {
		super.create();
		getShell().setImage(ResourceManager.getPluginImage("Dressing", "icons/supercadICon32.jpg"));
	}
	/**
	 * Launch the application.
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			Shell shell = new Shell();

			StockListWidow window = new StockListWidow(shell);
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}

	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}

	public ArticleFamilyGroup getFamiliesGroup() {
		if(familiesGroup==null) {
			familiesGroup=ResourceManagers.getIntance().getApplication().getArticleFamilies();
		}
		return familiesGroup;
	}

	public void setFamiliesGroup(ArticleFamilyGroup familiesGroup) {
		this.familiesGroup = familiesGroup;
		treeViewer.setInput(ResourceManagers.getIntance().getApplication().getArticleFamilies());
		treeViewer.refresh();

	}

	public TreeViewer getTreeViewer() {
		return treeViewer;
	}

	public void setTreeViewer(TreeViewer treeViewer) {
		this.treeViewer = treeViewer;
	}

	/**
	 * Create contents of the window.
	 * 
	 * @return
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell = parent.getShell();
		parent.getShell().setText("Articles");
		shell.addShellListener(getShellListener());
		holderComposite = new Composite(parent, SWT.FILL);
		holderComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		holderComposite.setTouchEnabled(true);
		holderComposite.setLayout(new FillLayout(SWT.HORIZONTAL));

		clientAreaComposite = new Composite(holderComposite, SWT.FILL);
		clientAreaComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		clientAreaComposite.setLayout(new FillLayout(SWT.HORIZONTAL));

		sashForm = new SashForm(clientAreaComposite, SWT.NONE);
		sashForm.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));

		scrolledComposite = new ScrolledComposite(sashForm, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);

		Composite composite_3 = new Composite(scrolledComposite, SWT.NONE);
		composite_3.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridLayout gl_composite_3 = new GridLayout(1,true);
		gl_composite_3.marginWidth = 0;
		gl_composite_3.marginHeight = 0;
		composite_3.setLayout(gl_composite_3);

		txtSearch = new Text(composite_3, SWT.BORDER);
		txtSearch.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		txtSearch.setMessage("Rechercher");
		Composite composite_4 = new Composite(composite_3, SWT.BORDER);
		composite_4.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		composite_4.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_4.setLayout(new TreeColumnLayout());
		treeViewer = new TreeViewer(composite_4, SWT.NONE);
		tree = treeViewer.getTree();
		composite_3.setTabList(new Control[]{txtSearch, composite_4});
		treeViewer.setLabelProvider(new ArticleFamilleLAbelProvider());
		treeViewer.setContentProvider(new ArticleFamilleTreeContentProvider());
		scrolledComposite.setContent(composite_3);
		scrolledComposite.setMinSize(composite_3.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		rightShoulder = new Composite(sashForm, SWT.NONE);

		rightShoulder.setLayout(new GridLayout(2, false));
		Label cherchLbl=new Label(rightShoulder, SWT.NONE);
		cherchLbl.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		cherchLbl.setText("Rechercher");
		searchArticle = new Text(rightShoulder, SWT.BORDER);
		searchArticle.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		searchArticle.setMessage("Rechercher");
		searchArticle.pack();
		
		tabFolder = new TabFolder(rightShoulder, SWT.NONE);
		GridData gd_tabFolder = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_tabFolder.heightHint = 250;
		gd_tabFolder.widthHint = 406;
		tabFolder.setLayoutData(gd_tabFolder);
		
		tbtmAccessoires = new TabItem(tabFolder, SWT.NONE);
		tbtmAccessoires.setText("Accessoires");
		tableHolderAccessoires = new Composite(tabFolder, SWT.NONE);
		tbtmAccessoires.setControl(tableHolderAccessoires);
		tableHolderAccessoires.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		tableHolderAccessoires.setLayout(new GridLayout(1, false));
		
		
		tableViewerAccessoires = new TableViewer(tableHolderAccessoires, SWT.BORDER | SWT.FULL_SELECTION);
		tableAccessoires = tableViewerAccessoires.getTable();
		tableAccessoires.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tableAccessoires.setHeaderBackground(SWTResourceManager.getColor(SWT.COLOR_CYAN));
		tableAccessoires.setLinesVisible(true);
		tableAccessoires.setHeaderVisible(true);
		tabFolder.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
 				if(e.item==tbtmAccessoires) {
 	 				tableViewerAccessoires.refresh();
 				}else {
 	 				tableViewerQuicaillerie.refresh();
 				}
 				System.err.println("selected");

			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		tableVwrClmnAName = new TableViewerColumn(tableViewerAccessoires, SWT.NONE);
		tableVwrClmnAName.setLabelProvider(new StockNameColumnLabelProvider());
		tblclmnANom = tableVwrClmnAName.getColumn();
		tblclmnANom.setWidth(100);
		tblclmnANom.setText("Nom");
		
		tableViewerColumnACode = new TableViewerColumn(tableViewerAccessoires, SWT.NONE);
		tableViewerColumnACode.setLabelProvider(new StockCodeLabelProvider());
		tblclmnACode = tableViewerColumnACode.getColumn();
		tblclmnACode.setWidth(103);
		tblclmnACode.setText("Code");
		
		tableViewerColumnAPrice = new TableViewerColumn(tableViewerAccessoires, SWT.NONE);
		tableViewerColumnAPrice.setLabelProvider(new StockPriceLabelProvider());
		tblclmnAPrix = tableViewerColumnAPrice.getColumn();
		tblclmnAPrix.setMoveable(true);
		tblclmnAPrix.setWidth(88);
		tblclmnAPrix.setText("Prix");
		
		tableViewerClmnAFamille = new TableViewerColumn(tableViewerAccessoires, SWT.NONE);
		tableViewerClmnAFamille.setLabelProvider(new StockArticleFamilyLabelProvider());
		tblclmnAFamille = tableViewerClmnAFamille.getColumn();
		tblclmnAFamille.setWidth(108);
		tblclmnAFamille.setText("Famille");
		
	
		
		buttonBarAccessoires = new Composite(tableHolderAccessoires, SWT.NONE);
		buttonBarAccessoires.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1));
		GridLayout gl_buttonBarAccessoires = new GridLayout(4, true);
		gl_buttonBarAccessoires.marginHeight = 0;
		gl_buttonBarAccessoires.horizontalSpacing = 0;
		buttonBarAccessoires.setLayout(gl_buttonBarAccessoires);
		
		btnViewAccessoire = new Button(buttonBarAccessoires, SWT.NONE);
		btnViewAccessoire.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnViewAccessoire.setText("Voir");
		btnViewAccessoire.setGrayed(true);
		btnViewAccessoire.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		btnAddAccessoires = new Button(buttonBarAccessoires, SWT.NONE);
		btnAddAccessoires.setGrayed(true);
		GridData gd_btnAddAccessoires = new GridData(SWT.FILL, SWT.FILL, false, true, 1, 1);
		gd_btnAddAccessoires.heightHint = 30;
		btnAddAccessoires.setLayoutData(gd_btnAddAccessoires);

		btnAddAccessoires.setText("Ajouter");
		btnAddAccessoires.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		
		btnModifyAccessoire = new Button(buttonBarAccessoires, SWT.NONE);
		GridData gd_btnModifyAccessoire = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_btnModifyAccessoire.heightHint = 30;
		btnModifyAccessoire.setLayoutData(gd_btnModifyAccessoire);
		btnModifyAccessoire.setText("Modifier");
		btnModifyAccessoire.setGrayed(true);
		btnModifyAccessoire.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		
		btnDeleteAccessoire = new Button(buttonBarAccessoires, SWT.NONE);
		btnDeleteAccessoire.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnDeleteAccessoire.setText("Supprimer");
		btnDeleteAccessoire.setGrayed(true);
		btnDeleteAccessoire.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		tableHolderAccessoires.setTabList(new Control[]{tableAccessoires, buttonBarAccessoires});
		tableViewerAccessoires.setContentProvider(new ListAccessoireContentProvider());
		tableViewerAccessoires.setInput(getFamiliesGroup());
		
		tbtmQuincaillerie = new TabItem(tabFolder, SWT.NONE);
		tbtmQuincaillerie.setText("Quincaillerie");
		
		tableQuincaillerieHolder = new Composite(tabFolder, SWT.NONE);
		tbtmQuincaillerie.setControl(tableQuincaillerieHolder);
		tableQuincaillerieHolder.setLayout(new GridLayout(1, false));
		
		tableViewerQuicaillerie = new TableViewer(tableQuincaillerieHolder, SWT.BORDER | SWT.FULL_SELECTION);
		tableQuicaillerie = tableViewerQuicaillerie.getTable();
		tableQuicaillerie.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tableQuicaillerie.setLinesVisible(true);
		tableQuicaillerie.setHeaderVisible(true);
		tableQuicaillerie.setHeaderBackground(SWTResourceManager.getColor(SWT.COLOR_CYAN));
		
		tblVColumnQName = new TableViewerColumn(tableViewerQuicaillerie, SWT.NONE);
		tblVColumnQName.setLabelProvider(new StockNameColumnLabelProvider());
		tblclmnQName = tblVColumnQName.getColumn();
		tblclmnQName.setWidth(100);
		tblclmnQName.setText("Nom");
		
		tblVColumnQCode = new TableViewerColumn(tableViewerQuicaillerie, SWT.NONE);
		tblVColumnQCode.setLabelProvider(new StockCodeLabelProvider());
		tblColumnQCode = tblVColumnQCode.getColumn();
		tblColumnQCode.setWidth(100);
		tblColumnQCode.setText("Code");
		
		tblvColumnQPrice = new TableViewerColumn(tableViewerQuicaillerie, SWT.NONE);
		tblvColumnQPrice.setLabelProvider(new StockPriceLabelProvider());
		tblColumnQPrice = tblvColumnQPrice.getColumn();
		tblColumnQPrice.setWidth(88);
		tblColumnQPrice.setText("Prix");
		tblColumnQPrice.setMoveable(true);
		
		tblVColumnQFamily = new TableViewerColumn(tableViewerQuicaillerie, SWT.NONE);
		tblVColumnQFamily.setLabelProvider(new StockArticleFamilyLabelProvider());
		tblColumnQFamily = tblVColumnQFamily.getColumn();
		tblColumnQFamily.setWidth(108);
		tblColumnQFamily.setText("Famille");
		tableViewerQuicaillerie.setContentProvider(new ListQuicaillerieContentProvider());
		tableViewerQuicaillerie.setInput(getFamiliesGroup());

		buttonBarQuincaillerie = new Composite(tableQuincaillerieHolder, SWT.NONE);
		buttonBarQuincaillerie.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, true, false, 1, 1));
		GridLayout gl_buttonBarQuincaillerie = new GridLayout(4, true);
		gl_buttonBarQuincaillerie.marginHeight = 0;
		gl_buttonBarQuincaillerie.horizontalSpacing = 0;
		buttonBarQuincaillerie.setLayout(gl_buttonBarQuincaillerie);
		
		btnViewQuincaillerie = new Button(buttonBarQuincaillerie, SWT.NONE);
		btnViewQuincaillerie.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnViewQuincaillerie.setGrayed(true);
		btnViewQuincaillerie.setText("Voir");
		btnViewQuincaillerie.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));

		btnAddQuincaillerie = new Button(buttonBarQuincaillerie, SWT.NONE);
		btnAddQuincaillerie.setGrayed(true);
		GridData gd_btnAddQuincaillerie = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_btnAddQuincaillerie.heightHint = 30;
		btnAddQuincaillerie.setLayoutData(gd_btnAddQuincaillerie);
		btnAddQuincaillerie.setText("Ajouter");
		btnAddQuincaillerie.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_LIST_SELECTION));
		
		btnModifyQuincaillerie = new Button(buttonBarQuincaillerie, SWT.NONE);
		btnModifyQuincaillerie.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnModifyQuincaillerie.setText("Modifier");
		btnModifyQuincaillerie.setGrayed(true);
		btnModifyQuincaillerie.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		
		btnDeleteQuincaillerie = new Button(buttonBarQuincaillerie, SWT.NONE);
		btnDeleteQuincaillerie.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnDeleteQuincaillerie.setText("Supprimer");
		btnDeleteQuincaillerie.setGrayed(true);
		btnDeleteQuincaillerie.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		tableQuincaillerieHolder.setTabList(new Control[] { tableQuicaillerie, buttonBarQuincaillerie });
		rightShoulder.setTabList(new Control[] { searchArticle, tabFolder });
		sashForm.setWeights(new int[] { 130, 497 });
		clientAreaComposite.setTabList(new Control[]{sashForm});
		holderComposite.setTabList(new Control[]{clientAreaComposite});
	
		treeViewer.setInput(getFamiliesGroup().getFamilles());
		addControl();
		return holderComposite;

	}

	public void addControl() {
		searchArticle.addKeyListener(new KeyListener() {

			@Override
			public void keyReleased(KeyEvent e) {
				filterAticleText = searchArticle.getText();
				tableViewerAccessoires.refresh();
				tableViewerQuicaillerie.refresh();

			}

			@Override
			public void keyPressed(KeyEvent e) {
				// TODO Auto-generated method stub

			}
		});
		
		btnAddQuincaillerie.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Quincaillerie quincaillerie = ParamFactory.eINSTANCE.createQuincaillerie();
				ArticleEditorWindow window = new ArticleEditorWindow(getShell(), EditorWindow.create,
						quincaillerie);
				int returnCode = window.open();
				if (returnCode == Window.OK) {
					tableViewerQuicaillerie.refresh();
				}
			}
		});
		
		btnAddAccessoires.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Accessoire accessoire = ParamFactory.eINSTANCE.createAccessoire();
				ArticleEditorWindow window = new ArticleEditorWindow(getShell(), EditorWindow.create,
						accessoire);
				int returnCode = window.open();
				if (returnCode == Window.OK) {
					tableViewerAccessoires.refresh();
				}
			}
		});
		btnModifyAccessoire.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				Accessoire accessoire = (Accessoire) tableViewerAccessoires.getStructuredSelection().getFirstElement();
				if(accessoire!=null) {
					ArticleEditorWindow window = new ArticleEditorWindow(getShell(), EditorWindow.update,
							accessoire);
					int returnCode = window.open();
					if (returnCode == Window.OK) {
						tableViewerAccessoires.refresh();
					}
				}
				
			}
		});
		btnModifyQuincaillerie.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				Quincaillerie quincaillerie = (Quincaillerie) tableViewerQuicaillerie.getStructuredSelection().getFirstElement();
				if(quincaillerie!=null) {
					ArticleEditorWindow window = new ArticleEditorWindow(getShell(), EditorWindow.update,
							quincaillerie);
					int returnCode = window.open();
					if (returnCode == Window.OK) {
						tableViewerQuicaillerie.refresh();
					}
				}
				
			}
		});
		btnViewAccessoire.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				Accessoire accessoire = (Accessoire) tableViewerAccessoires.getStructuredSelection().getFirstElement();
				if(accessoire!=null) {
					ArticleEditorWindow window = new ArticleEditorWindow(getShell(), EditorWindow.View,
							accessoire);
					window.open();
				}
				
			}
		});
		btnViewQuincaillerie.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				Quincaillerie quincaillerie = (Quincaillerie) tableViewerQuicaillerie.getStructuredSelection().getFirstElement();
				if(quincaillerie!=null) {
					ArticleEditorWindow window = new ArticleEditorWindow(getShell(), EditorWindow.View,
							quincaillerie);
					window.open();
				}
				
			}
		});
		btnDeleteAccessoire.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				Accessoire accessoire = (Accessoire) tableViewerAccessoires.getStructuredSelection().getFirstElement();
				if(accessoire!=null) {
					boolean confirm=MessageDialog.openConfirm(getShell(), "Supprimer Accessoire", "voulez vous suupprimer l'accessoire "+accessoire.getName()+":"+accessoire.getCode());
					if (confirm) {
						if(accessoire.getParentFamily()!=null)
						{
							accessoire.getParentFamily().getAccessoires().remove(accessoire);
							ResourceManagers.getIntance().saveLibraryResource();
						}
						tableViewerAccessoires.refresh();
					}

				}
				
			}
		});
		btnDeleteQuincaillerie.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				Quincaillerie quincaillerie = (Quincaillerie) tableViewerQuicaillerie.getStructuredSelection().getFirstElement();
				if(quincaillerie!=null) {
					boolean confirm=MessageDialog.openConfirm(getShell(), "Supprimer Quincaillerie", "voulez vous suupprimer l'accessoire "+quincaillerie.getName()+":"+quincaillerie.getCode());
					if (confirm) {
						if(quincaillerie.getParentFamily()!=null)
						{
							quincaillerie.getParentFamily().getQuincailleries().remove(quincaillerie);
							ResourceManagers.getIntance().saveLibraryResource();
						}
						tableViewerQuicaillerie.refresh();
					}

				}
				
			}
		});
	treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection= event.getStructuredSelection();
				if(selection!=null && !selection.isEmpty()) {
					Object selectionobj = selection.size() == 1 ? selection.getFirstElement() : selection.getFirstElement();
					if(selectionobj instanceof ArticleFamily || selectionobj instanceof ArticleFamilyGroup) {
						tableViewerAccessoires.setInput(selectionobj);
						tableViewerAccessoires.refresh();
						tableViewerQuicaillerie.setInput(selectionobj);
						tableViewerQuicaillerie.refresh();

					}
				}
			}
		});
		treeViewer.addDoubleClickListener(new IDoubleClickListener() {
			@Override
			public void doubleClick(DoubleClickEvent event) {
				TreeViewer viewer = (TreeViewer) event.getViewer();
				IStructuredSelection thisSelection = (IStructuredSelection) event.getSelection();
				Object selectedNode = thisSelection.getFirstElement();
				viewer.setExpandedState(selectedNode, !viewer.getExpandedState(selectedNode));
			}
		});
		treeViewer.addFilter(new ViewerFilter() {
			
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				if(element!=null && element instanceof ArticleFamily){
					return isfamilyValid((ArticleFamily) element);
				}
				return false;
			}
			public boolean isfamilyValid(ArticleFamily family ) {
				if(family!=null ){
					String name = family.getName();
					String code =family.getCode();
				
					boolean iscontainTxtFilter = filterText.equals("")
							||(name!=null&& name.toUpperCase().contains(filterText.toUpperCase()))
							||(code!=null&& code.toUpperCase().contains(filterText.toUpperCase()));
					for(ArticleFamily fam:family.getFamilies()) {
						iscontainTxtFilter=iscontainTxtFilter||isfamilyValid(fam);
					}
					return iscontainTxtFilter;
					
				}
				
				
				return false;
			}
		});
		ViewerFilter filter=new ViewerFilter() {
			
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				if(element!=null)
				{
					String name;
					String code; 
					boolean iscontainTxtFilter=false;
					if(element!=null&& element instanceof Accessoire ){
						 name = ((Accessoire) element).getName();
						 code =((Accessoire) element).getCode();
					
						
					}else if(element!=null&& element instanceof Quincaillerie ) {
						name = ((Quincaillerie) element).getName();
						 code =((Quincaillerie) element).getCode();
					}else {
						return false;
					}
	
					iscontainTxtFilter = filterAticleText.equals("")
							||(name!=null&& name.toUpperCase().contains(filterAticleText.toUpperCase()))
							||(code!=null&& code.toUpperCase().contains(filterAticleText.toUpperCase()));
				
					return iscontainTxtFilter;
				}
				return false;
			}
			
		};
	tableViewerAccessoires.addFilter(filter);
	tableViewerQuicaillerie.addFilter(filter);

		// In order to let a column fit to it’s contents width you can invoke the
		// columns pack method like that.
		Listener listener = new Listener() {

			@Override
			public void handleEvent(Event event) {
				TreeItem treeItem = (TreeItem) event.item;
				final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
				Display.getCurrent().asyncExec(new Runnable() {

					@Override
					public void run() {
						for (TreeColumn treeColumn : treeColumns)
							treeColumn.pack();
					}
				});
			}
		};
		txtSearch.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent e) {
				filterText=txtSearch.getText();
				treeViewer.refresh();
			}
			
			@Override
			public void keyPressed(KeyEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		tree.addListener(SWT.Expand, listener);
	
		ControlAdapter adaptor2=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				Rectangle area2 = StockListWidow.this.getShell().getClientArea();
				holderComposite.setBounds(area2);
				int tableHeight=tableHolderAccessoires.getSize().y-buttonBarAccessoires.getSize().y;
				int width =tableHolderAccessoires.getSize().x-tableHolderAccessoires.getBorderWidth()*2;
				int tablewidth=width;
				if(tableHolderAccessoires.getVerticalBar()!=null) {
					tablewidth-=tableHolderAccessoires.getVerticalBar().getSize().x;
				}
				width =width -tableAccessoires.getVerticalBar().getSize().x- tableAccessoires.getBorderWidth()*2;;
				Point oldSize = tableAccessoires.getSize();
				if (oldSize.x > tablewidth) {
					// table is getting smaller so make the columns
					// smaller first and then resize the table to
					// match the client area width
					int columnWidth = (width) / 4;
					for(TableColumn column:tableAccessoires.getColumns()) {
						column.setWidth(columnWidth);
					}
					for(TableColumn column:tableQuicaillerie.getColumns()) {
						column.setWidth(columnWidth);
					}

					tableAccessoires.setSize(tablewidth, tableHeight-tableAccessoires.getHorizontalBar().getSize().y);
					tableQuicaillerie.setSize(tablewidth, tableHeight-tableQuicaillerie.getHorizontalBar().getSize().y);

				} else {
					// table is getting bigger so make the table
					// bigger first and then make the columns wider
					// to match the client area width
					int columnWidth = (width) / 4;
					tableAccessoires.setSize(tablewidth, tableHeight-tableAccessoires.getHorizontalBar().getSize().y);
					tableQuicaillerie.setSize(tablewidth, tableHeight-tableQuicaillerie.getHorizontalBar().getSize().y);
					for(TableColumn column:tableAccessoires.getColumns()) {
						column.setWidth(columnWidth);
					}
					for(TableColumn column:tableQuicaillerie.getColumns()) {
						column.setWidth(columnWidth);
					}

				}
			}
			
		};
		holderComposite.addControlListener(adaptor2);
		
		getShell().addControlListener(adaptor2);
		
	}
	public synchronized void show() {
		if (!shell.isDisposed()) {
			treeViewer.setInput(getFamiliesGroup().getFamilles());
			treeViewer.refresh();
			tableViewerAccessoires.refresh();
			tableViewerQuicaillerie.refresh();
			StockListWidow.this.shell.setVisible(true);
			StockListWidow.this.shell.setActive();
		}

	}

	public synchronized void hide() {
		if (!shell.isDisposed()) {

			StockListWidow.this.shell.setVisible(false);
		}

	}

	public void createController() {

	}


class ArticleFamilleTreeContentProvider implements ITreeContentProvider {
	@Override
	public boolean hasChildren(Object element) {
		if (element != null && element instanceof ArticleFamilyGroup) {
			return ((ArticleFamilyGroup) element).getFamilles() != null
					&& ((ArticleFamilyGroup) element).getFamilles().size() > 0;
		} else if (element != null && element instanceof ArticleFamily) {
			return ((ArticleFamily) element).getFamilies() != null
					&& ((ArticleFamily) element).getFamilies().size() > 0;
		}
		return false;
	}

	@Override
	public Object getParent(Object element) {
		if (element != null && element instanceof ArticleFamily) {
			return ((ArticleFamily) element).getParentFamily();
		}
		return null;
	}

	@Override
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof ArticleFamily) {
			EList<ArticleFamily> o = ((ArticleFamily) inputElement).getFamilies();
			return o.toArray();
		}
		if (inputElement instanceof ArticleFamilyGroup) {
			EList<ArticleFamily> o = ((ArticleFamilyGroup) inputElement).getFamilles();
			return o.toArray();
		}
		if (inputElement instanceof EList) {
			EList<ArticleFamily> o = ((EList<ArticleFamily>) inputElement);
			return o.toArray();
		}
		Object[] o = new Object[] {};
		return o;
	}

	@Override
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof ArticleFamily) {
			EList<ArticleFamily> o = ((ArticleFamily) parentElement).getFamilies();
			return o.toArray();
		}
		if (parentElement instanceof ArticleFamilyGroup) {
			EList<ArticleFamily> o = ((ArticleFamilyGroup) parentElement).getFamilles();
			return o.toArray();
		}
		return null;
	}
}

class ArticleFamilleLAbelProvider extends LabelProvider {

	@Override
	public String getText(Object element) {
		if (element instanceof ArticleFamily) {
			return ((ArticleFamily) element).getName();
		}
		return "";
	}

	@Override
	public Image getImage(Object element) {

		return super.getImage(element);
	}

}
class ListAccessoireContentProvider implements IStructuredContentProvider{

	@Override
	public Object[] getElements(Object inputElement) {
		ArrayList<BaseObject> articles=new ArrayList<BaseObject>();
		if(inputElement instanceof ArticleFamily) {
			getArticles((ArticleFamily)inputElement, articles);
		}
		if(inputElement instanceof ArticleFamilyGroup) {
			if(((ArticleFamilyGroup)inputElement).getFamilles()!=null && ((ArticleFamilyGroup)inputElement).getFamilles().size()>0) {
				for(ArticleFamily sub_family:((ArticleFamilyGroup)inputElement).getFamilles()) {
					getArticles(sub_family, articles);
				}
			}
		}
		return articles.toArray();
	}
	public void getArticles(ArticleFamily family,ArrayList<BaseObject> articles) {
		if(family !=null && articles!=null) {
			if(family.getAccessoires()!=null && family.getAccessoires().size()>0) {
				articles.addAll(family.getAccessoires());
			}
			if(family.getFamilies()!=null && family.getFamilies().size()>0) {
				for(ArticleFamily sub_family:family.getFamilies()) {
					getArticles(sub_family, articles);
				}
			}
		}
	}
}
class ListQuicaillerieContentProvider implements IStructuredContentProvider{

	@Override
	public Object[] getElements(Object inputElement) {
		ArrayList<BaseObject> articles=new ArrayList<BaseObject>();
		if(inputElement instanceof ArticleFamily) {
			getArticles((ArticleFamily)inputElement, articles);
		}
		if(inputElement instanceof ArticleFamilyGroup) {
			if(((ArticleFamilyGroup)inputElement).getFamilles()!=null && ((ArticleFamilyGroup)inputElement).getFamilles().size()>0) {
				for(ArticleFamily sub_family:((ArticleFamilyGroup)inputElement).getFamilles()) {
					getArticles(sub_family, articles);
				}
			}
		}
		return articles.toArray();
	}
	public void getArticles(ArticleFamily family,ArrayList<BaseObject> articles) {
		if(family !=null && articles!=null) {
			
			if(family.getQuincailleries()!=null && family.getQuincailleries().size()>0) {
				articles.addAll(family.getQuincailleries());
			}
			if(family.getFamilies()!=null && family.getFamilies().size()>0) {
				for(ArticleFamily sub_family:family.getFamilies()) {
					getArticles(sub_family, articles);
				}
			}
		}
	}
}
class StockNameColumnLabelProvider extends ColumnLabelProvider {
	public Image getImage(Object element) {
		Article art=(Article) element;
		if(art.getImage()!=null && art.getImage().getPath()!=null && !art.getImage().getPath().isEmpty() ) {
			return	ImageLoaderCache.getInstance().loadImage(art.getImage().getPath(), 100, 100);
		}else {
			 // Create a new Image with the desired dimensions
	        Image image = new Image( Display.getCurrent(), 100, 100);

	        // Create a GC (Graphics Context) to draw on the image
	        GC gc = new GC(image);

	        // Set the background color of the image
	        Color backgroundColor =  Display.getCurrent().getSystemColor(SWT.COLOR_TRANSPARENT);
	        gc.setBackground(backgroundColor);

	        // Fill the entire image with the background color
	        gc.fillRectangle(0, 0, 100, 100);
	        gc.dispose();

//			 Color color = Display.getCurrent().getSystemColor(SWT.COLOR_RED);
//		        Image coloredImage = new Image(Display.getCurrent(), 100, 100);
//		        coloredImage.setBackground(color);
		        return image;
		}
	}
	public String getText(Object element) {
		if(element instanceof Accessoire) {
			return ((Accessoire)element).getName();
		}
		if(element instanceof Quincaillerie) {
			return ((Quincaillerie)element).getName();
		}
		return element == null ? "" : element.toString();
	}
	@Override
	public Color getBackground(Object element) {
		if(element instanceof Accessoire) {
			return JFaceResources.getResources().createColor(new RGB(250, 100, 150));
		}
		if(element instanceof Quincaillerie) {
			return JFaceResources.getResources().createColor(new RGB(150, 250, 100));
		}
		return super.getBackground(element);
	}
	
}

class StockCodeLabelProvider extends ColumnLabelProvider {
	public Image getImage(Object element) {
		// TODO Auto-generated method stub
		return null;
	}
	public String getText(Object element) {
		if(element instanceof Accessoire) {
			return ((Accessoire)element).getCode();
		}
		if(element instanceof Quincaillerie) {
			return ((Quincaillerie)element).getCode();
		}
		return element == null ? "" : element.toString();
	}
	@Override
	public Color getBackground(Object element) {
		if(element instanceof Accessoire) {
			return JFaceResources.getResources().createColor(new RGB(250, 100, 150));
		}
		if(element instanceof Quincaillerie) {
			return JFaceResources.getResources().createColor(new RGB(150, 250, 100));
		}
		return super.getBackground(element);
	}
}
class StockPriceLabelProvider extends ColumnLabelProvider {
	public Image getImage(Object element) {
		// TODO Auto-generated method stub
		return null;
	}
	public String getText(Object element) {
		if(element instanceof Accessoire) {
			return ((Accessoire)element).getPrix()+"";
		}
		if(element instanceof Quincaillerie) {
			return ((Quincaillerie)element).getPrix()+"";
		}
		return element == null ? "" : element.toString();
	}
	@Override
	public Color getBackground(Object element) {
		if(element instanceof Accessoire) {
			return JFaceResources.getResources().createColor(new RGB(250, 100, 150));
		}
		if(element instanceof Quincaillerie) {
			return JFaceResources.getResources().createColor(new RGB(150, 250, 100));
		}
		return super.getBackground(element);
	}
}
class StockArticleFamilyLabelProvider extends ColumnLabelProvider {
	public Image getImage(Object element) {
		// TODO Auto-generated method stub
		return null;
	}
	public String getText(Object element) {
		if(element instanceof Accessoire) {
			if(((Accessoire)element).getParentFamily()!=null) {
				return ((Accessoire)element).getParentFamily().getName();

			}else {
				return "";
			}
		}
		if(element instanceof Quincaillerie) {
			if(((Quincaillerie)element).getParentFamily()!=null) {
				return ((Quincaillerie)element).getParentFamily().getName();
			}
			else {
				return "";
			}
		}
		return element == null ? "" : element.toString();
	}
	@Override
	public Color getBackground(Object element) {
		if(element instanceof Accessoire) {
			return JFaceResources.getResources().createColor(new RGB(250, 100, 150));
		}
		if(element instanceof Quincaillerie) {
			return JFaceResources.getResources().createColor(new RGB(150, 250, 100));
		}
		return super.getBackground(element);
	}
}
}