/*
 * Decompiled with CFR 0.152.
 */
package api.graphics.geometry;

import api.graphics.Material;
import api.graphics.Mesh;
import api.graphics.PbrMaterial;
import api.graphics.Texture;
import api.graphics.Vertex;
import api.graphics.VertexAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MeshBuilder {
    public static Mesh createArrow(Material material, Matrix4f transform) {
        Vertex v0 = new Vertex(0.0f, 1.0f, 0.0f);
        Vertex v1 = new Vertex(-0.5f, 0.0f, -0.5f);
        Vertex v2 = new Vertex(0.5f, 0.0f, -0.5f);
        Vertex v3 = new Vertex(0.5f, 0.0f, 0.5f);
        Vertex v4 = new Vertex(-0.5f, 0.0f, 0.5f);
        Vertex[] vertices = new Vertex[]{v0, v1, v2, v3, v4};
        int[] nArray = new int[12];
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[4] = 3;
        nArray[5] = 2;
        nArray[7] = 4;
        nArray[8] = 3;
        nArray[10] = 1;
        nArray[11] = 4;
        int[] indices = nArray;
        int attr = VertexAttributes.POSITION;
        Matrix4f mat = new Matrix4f().translate(0.0f, 0.9f, 0.0f).scale(0.1f, 0.2f, 0.1f);
        Mesh headPart = new Mesh(vertices, indices, 4, attr, material, mat);
        Vertex l0 = new Vertex(0.0f, 0.0f, 0.0f);
        Vertex l1 = new Vertex(0.0f, 1.0f, 0.0f);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        int[] indicesL = nArray2;
        Mesh linePart = new Mesh(new Vertex[]{l0, l1}, indicesL, 1, attr, material, new Matrix4f());
        Mesh mesh = new Mesh(headPart, linePart);
        mesh.setMtl(material);
        mesh.setLocalTransform(transform);
        return mesh;
    }

    public static Mesh createBox(int attrs, Material mtl, Matrix4f transform) {
        Vector3f pointer = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector3f v000 = new Vector3f((Vector3fc)pointer).mul(-1.0f, -1.0f, -1.0f);
        Vector3f v001 = new Vector3f((Vector3fc)pointer).mul(-1.0f, -1.0f, 1.0f);
        Vector3f v010 = new Vector3f((Vector3fc)pointer).mul(-1.0f, 1.0f, -1.0f);
        Vector3f v011 = new Vector3f((Vector3fc)pointer).mul(-1.0f, 1.0f, 1.0f);
        Vector3f v100 = new Vector3f((Vector3fc)pointer).mul(1.0f, -1.0f, -1.0f);
        Vector3f v101 = new Vector3f((Vector3fc)pointer).mul(1.0f, -1.0f, 1.0f);
        Vector3f v110 = new Vector3f((Vector3fc)pointer).mul(1.0f, 1.0f, -1.0f);
        Vector3f v111 = new Vector3f((Vector3fc)pointer);
        Vector3f[] frontVertices = new Vector3f[]{v011, v001, v101, v111};
        Vector3f[] backVertices = new Vector3f[]{v010, v110, v100, v000};
        Vector3f[] leftVertices = new Vector3f[]{v010, v000, v001, v011};
        Vector3f[] rightVertices = new Vector3f[]{v110, v111, v101, v100};
        Vector3f[] topVertices = new Vector3f[]{v010, v011, v111, v110};
        Vector3f[] bottomVertices = new Vector3f[]{v000, v100, v101, v001};
        Mesh q0 = MeshBuilder.createQuad(frontVertices, attrs, mtl, new Matrix4f());
        Mesh q1 = MeshBuilder.createQuad(backVertices, attrs, mtl, new Matrix4f());
        Mesh q2 = MeshBuilder.createQuad(leftVertices, attrs, mtl, new Matrix4f());
        Mesh q3 = MeshBuilder.createQuad(rightVertices, attrs, mtl, new Matrix4f());
        Mesh q4 = MeshBuilder.createQuad(topVertices, attrs, mtl, new Matrix4f());
        Mesh q5 = MeshBuilder.createQuad(bottomVertices, attrs, mtl, new Matrix4f());
        Mesh box = new Mesh(q0, q1, q2, q3, q4, q5);
        return box;
    }

    public static Mesh createCircle(int segments, Material mtl, Matrix4f transform) {
        Vector3f pointer = new Vector3f(1.0f, 0.0f, 0.0f);
        float angularStep = (float)(Math.PI * 2 / (double)segments);
        Vertex[] vertices = new Vertex[segments];
        int[] indices = new int[segments];
        int i = 0;
        while (i < segments) {
            Vector3f position = new Vector3f((Vector3fc)pointer).rotateAxis((float)i * angularStep, 0.0f, 1.0f, 0.0f);
            vertices[i] = new Vertex(position.x, position.y, position.z);
            indices[i] = i;
            ++i;
        }
        return new Mesh(vertices, indices, 2, VertexAttributes.POSITION, mtl, transform);
    }

    public static Mesh createQuad(Vector3f[] corners, int attrs, Material mtl, Matrix4f transform) {
        Vertex[] verticesData = new Vertex[4];
        int i = 0;
        while (i < 4) {
            verticesData[i] = new Vertex();
            verticesData[i].setPosition(corners[i]);
            ++i;
        }
        if ((attrs & (VertexAttributes.NORMAL | VertexAttributes.NORMAL)) > 0) {
            Vector3f T = new Vector3f().set((Vector3fc)corners[1]).sub((Vector3fc)corners[0]).normalize();
            Vector3f B = new Vector3f().set((Vector3fc)corners[2]).sub((Vector3fc)corners[0]).normalize();
            Vector3f N = new Vector3f();
            T.cross((Vector3fc)B, N);
            N.normalize();
            if ((attrs & VertexAttributes.NORMAL) > 0) {
                int i2 = 0;
                while (i2 < 4) {
                    verticesData[i2].setNormal(N);
                    ++i2;
                }
            }
            if ((attrs & VertexAttributes.TEXCOORDS) > 0) {
                N.cross((Vector3fc)T, B);
                Vector3f center = new Vector3f((Vector3fc)corners[0]).add((Vector3fc)corners[1]).add((Vector3fc)corners[2]).add((Vector3fc)corners[3]).div(4.0f);
                Matrix3f TBN = new Matrix3f((Vector3fc)T, (Vector3fc)B, (Vector3fc)N);
                int i3 = 0;
                while (i3 < 4) {
                    Vector3f uvw = new Vector3f((Vector3fc)corners[i3]).sub((Vector3fc)center).mul((Matrix3fc)TBN);
                    verticesData[i3].setTextCoords(new Vector2f(uvw.x, uvw.y).add(0.5f, 0.5f));
                    ++i3;
                }
            }
        }
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        int[] indices = nArray;
        return new Mesh(verticesData, indices, 4, attrs, mtl, transform);
    }

    public static Mesh createRectangle(int attrs, Material mtl, Matrix4f transform) {
        Vector3f[] positions = new Vector3f[]{new Vector3f(-0.5f, 0.5f, 0.0f), new Vector3f(-0.5f, -0.5f, 0.0f), new Vector3f(0.5f, -0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f)};
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector2f[] uvs = new Vector2f[]{new Vector2f(0.0f, 1.0f), new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f)};
        Vertex[] verticesData = new Vertex[4];
        int i = 0;
        while (i < 4) {
            verticesData[i] = new Vertex();
            verticesData[i].setPosition(positions[i]);
            verticesData[i].setNormal(normal);
            verticesData[i].setTextCoords(uvs[i]);
            ++i;
        }
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        int[] indices = nArray;
        return new Mesh(verticesData, indices, 4, attrs, mtl, transform);
    }

    public static Mesh createRing(float thickness, float radius, int circleSegms, int ringSeg, Material mtl, Matrix4f transform) {
        Vector3f xzPointer = new Vector3f(radius, 0.0f, 0.0f);
        Vector3f xyPointer = new Vector3f(thickness / 2.0f, 0.0f, 0.0f);
        Vector3f[][] vertices = new Vector3f[circleSegms][ringSeg];
        float circleStep = (float)(Math.PI * 2 / (double)circleSegms);
        float ringStep = circleStep * (float)circleSegms / (float)ringSeg;
        Vertex[] verticesData = new Vertex[circleSegms * ringSeg];
        int c = 0;
        ArrayList<Integer> indicesList = new ArrayList<Integer>();
        int verticesCount = circleSegms * ringSeg;
        int i = 0;
        while (i < circleSegms) {
            int j = 0;
            while (j < ringSeg) {
                Vector3f position;
                vertices[i][j] = position = new Vector3f((Vector3fc)xzPointer).add((Vector3fc)new Vector3f((Vector3fc)xyPointer).rotateZ((float)j * ringStep)).rotateY(circleStep * (float)i);
                Integer i0 = c % verticesCount;
                Integer i1 = (c + 1) % verticesCount;
                Integer i2 = (c + 1 + ringSeg) % verticesCount;
                Integer i3 = (c + ringSeg) % verticesCount;
                Integer[] quadIndices = new Integer[]{i0, i1, i2, i0, i2, i3};
                indicesList.addAll(Arrays.asList(quadIndices));
                verticesData[c++] = new Vertex(position.x, position.y, position.z);
                ++j;
            }
            ++i;
        }
        int[] indices = new int[indicesList.size()];
        int i2 = 0;
        while (i2 < indices.length) {
            indices[i2] = (Integer)indicesList.get(i2);
            ++i2;
        }
        Mesh mesh = new Mesh(verticesData, indices, 4, VertexAttributes.POSITION, mtl, transform);
        return mesh;
    }

    public static Mesh createCameraBox() {
        int attrs = VertexAttributes.POSITION | VertexAttributes.NORMAL | VertexAttributes.TEXCOORDS;
        Texture topText = new Texture("C:\\ProgramData\\supercad\\ressources\\icons\\camerabox\\top.png");
        Texture bottomText = new Texture("C:\\ProgramData\\supercad\\ressources\\icons\\camerabox\\bottom.png");
        Texture leftText = new Texture("C:\\ProgramData\\supercad\\ressources\\icons\\camerabox\\left.png");
        Texture rightText = new Texture("C:\\ProgramData\\supercad\\ressources\\icons\\camerabox\\right.png");
        Texture frontText = new Texture("C:\\ProgramData\\supercad\\ressources\\icons\\camerabox\\front.png");
        Texture backText = new Texture("C:\\ProgramData\\supercad\\ressources\\icons\\camerabox\\back.png");
        try {
            topText.load();
            bottomText.load();
            leftText.load();
            rightText.load();
            frontText.load();
            backText.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PbrMaterial topMtl = new PbrMaterial("top", new Vector3f(0.2f), topText, null, 0.04f, 0.8f, null, null);
        PbrMaterial bottomMtl = new PbrMaterial("bottom", new Vector3f(0.2f), bottomText, null, 0.04f, 0.8f, null, null);
        PbrMaterial leftMtl = new PbrMaterial("left", new Vector3f(0.2f), leftText, null, 0.04f, 0.8f, null, null);
        PbrMaterial rightMtl = new PbrMaterial("right", new Vector3f(0.2f), rightText, null, 0.04f, 0.8f, null, null);
        PbrMaterial frontMtl = new PbrMaterial("front", new Vector3f(0.2f), frontText, null, 0.04f, 0.8f, null, null);
        PbrMaterial backMtl = new PbrMaterial("back", new Vector3f(0.2f), backText, null, 0.04f, 0.8f, null, null);
        float PI = (float)Math.toRadians(180.0);
        Mesh q0 = MeshBuilder.createRectangle(attrs, frontMtl, new Matrix4f().setTranslation(0.0f, 0.0f, 0.5f));
        Mesh q1 = MeshBuilder.createRectangle(attrs, backMtl, new Matrix4f().translate(0.0f, 0.0f, -0.5f).rotate(PI, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
        Mesh q2 = MeshBuilder.createRectangle(attrs, leftMtl, new Matrix4f().translate(-0.5f, 0.0f, 0.0f).rotate(-PI / 2.0f, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
        Mesh q3 = MeshBuilder.createRectangle(attrs, rightMtl, new Matrix4f().translate(0.5f, 0.0f, 0.0f).rotate(PI / 2.0f, (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
        Mesh q4 = MeshBuilder.createRectangle(attrs, topMtl, new Matrix4f().translate(0.0f, 0.5f, 0.0f).rotate(-PI / 2.0f, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
        Mesh q5 = MeshBuilder.createRectangle(attrs, bottomMtl, new Matrix4f().translate(0.0f, -0.5f, 0.0f).rotate(PI / 2.0f, (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)));
        Mesh box = new Mesh(q0, q1, q2, q3, q4, q5);
        return box;
    }
}

