package dressing.ui.emf.MechanicdesignLibrary;

import org.eclipse.jface.viewers.LabelProvider;

import gdxapp.object3d.WorldObject;
import param.AccessoiresPieces;
import param.DesignClasse;
import param.Equation;
import param.Material;
import param.MaterialType;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicDesignGroup;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.Option;
import param.OptionGroup;
import param.QuicailleriePieces;
import param.TypeDef;
import param.TypeDefElement;

public class ModelEMFLabelProvider extends LabelProvider {
	private static ModelEMFLabelProvider instance ;
	public static ModelEMFLabelProvider getInstance() {
		synchronized(ModelEMFLabelProvider.class) {
			if (instance == null) {
				instance = new ModelEMFLabelProvider();
			}
			return instance;
		}
	}
	@Override
  	public String getText(Object element) {
		
		if( element instanceof Option) {
//  			String designName = ((Option) element).getDesign().getName();
//  			String optionName =  ((Option) element).getName()==null?"":((Option) element).getName();
  			String label=((Option) element).getLabel()==null?"":((Option) element).getLabel()+" | "+((Option) element).getCode();
  			return label;
  		}
		
  		if(element instanceof MechanicDesign) {
  			return ((MechanicDesign)element).getName();
  		}
  		if(element instanceof MechanicDesignElment) {
  			return (((MechanicDesignElment)element).getName())+" "+(((MechanicDesignElment)element).getTypedefelement()!=null?((MechanicDesignElment)element).getTypedefelement().getName():"");
  		}
  		if(element instanceof DesignClasse) {
  			return ((DesignClasse)element).getName();
  		}
  		
  		if(element instanceof MechanicDesignGroup) {
  			return ((MechanicDesignGroup)element).getName();
  		}
  		if(element instanceof MechanicPrivateParam) {
  			return ((MechanicPrivateParam)element).getName();
  		}
  		
  		if(element instanceof MechanicPublicParam) {
  			return ((MechanicPublicParam)element).getName();
  		}
  		if(element instanceof TypeDef) {
  			return ((TypeDef)element).getName();
  		}
  		
  		if(element instanceof TypeDefElement) {
  			return ((TypeDefElement)element).getName();
  		}
  		if(element instanceof String) {
  			return (String) element;
  		}
  		if(element instanceof WorldObject) {
  			return ((WorldObject) element).getName();
  		}else if(element instanceof MaterialType) {
			MaterialType item = (MaterialType) element;
			return item.getName();
		}
  		if(element instanceof Material) {
  			return ((Material) element).getName();
  		}
  		if(element instanceof Equation) {
  			return ((Equation)element).getKey();
  		}
  		if(element instanceof AccessoiresPieces ) {
			if( ((AccessoiresPieces) element).getAccessoires()!=null)
			{
				return ((AccessoiresPieces) element).getAccessoires().getName();
			}else {
				return ((AccessoiresPieces) element).getName();
			}
		}
  		if(element instanceof QuicailleriePieces ) {
			if( ((QuicailleriePieces) element).getQuincailleries()!=null)
			{
				return ((QuicailleriePieces) element).getQuincailleries().getName();
			}else {
				return ((QuicailleriePieces) element).getName();
			}
		}
		if( element instanceof OptionGroup) {
//			String designName = ((Option) element).getDesign().getName();
//			String optionName =  ((Option) element).getName()==null?"":((Option) element).getName();
			String label=((OptionGroup) element).getName()==null?"":((OptionGroup) element).getName();
			return label;
		}
  		return element.toString();
  	}
  	
}
