package dressing.ui.emf.MechanicdesignLibrary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

import javax.inject.Inject;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.event.EventHandler;

import com.badlogic.gdx.math.Vector3;
import com.frs.supercad.dressing.provider.PreviewModelProvider;
import dressing.events.EventDriver;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.DnDHelper;
import dressing.ui.util.TypeDefElementLabelProvider;
import gdxapp.object3d.ModelInfo;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.SceneEvent;
import param.DesignClassGroup;
import param.DesignClasse;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.MechanicPublicParam;
import param.ModelRoot;
import param.Option;
import param.TypeDef;
import param.TypeDefElement;
import param.impl.ModelRootImpl;
import param.impl.OptionImpl;

public class EmfLibraryComposite extends Composite implements dressing.events.EventHandler{
	public static boolean SANS_POIGNEE = false;
	public static boolean AVEC_POIGNEE = false;
	public static boolean ALL = true;
	private String poigneeSearch = "ALL";
	private DataBindingContext m_bindingContext;
	private Spinner spnlongeur;
	private Spinner spnhauteur;
	private Spinner spnpronfondeur;
	ModelRoot root;
	DesignClassGroup classgroup;
	DesignClasse classe;
	Object designgroup;
	public static Object selection;
	private ListViewer listViewer;
	private java.util.List<String> widths = new ArrayList<String>();
	private ListViewer listViewer_1;
	@Inject
	private IEventBroker eventBroker;
	ESelectionService selectionService;
	private ComboViewer comboViewerCat;
	String filterText = "";
	ViewerFilter searchFilter;
	Group poigneeGroup;
	private Text txtFilter;
	Button filterAvecpoignee;
	Button filterAll;
	Button filterAllDesignGroups;
	private java.util.List<Object> categories = new ArrayList<Object>();
	java.util.List<String> designCategories = new ArrayList<String>();
	public static boolean changingSelelection = false;
	private Combo altitudeCombo;
	private ComboViewer CValtitude;
	private Spinner spnAltitude;

	private Object lastseletcteddesignobject = null;

	private HashMap<MechanicDesignGroup, ArrayList<WorldObject>> groups = new HashMap<MechanicDesignGroup, ArrayList<WorldObject>>();
	private Button filterSansPoignee;

	/**
	 * Create the composite.
	 * 
	 * @param parent
	 * @param eventBroker2
	 * @param style
	 */
	public EmfLibraryComposite(Composite parent, IEventBroker eventBroker, int style) {
		super(parent, SWT.NONE);
		EventDriver.getDriver().registerSubscription(SceneEvent.UPDATE_DATAMODEL.name(), this);
		this.eventBroker = eventBroker;
		this.root = ModelProvider.getModelroot();
		this.classgroup = this.root.getClasses();
		this.classe = this.classgroup.getDesignClasse().get(0) != null ? this.classgroup.getDesignClasse().get(0)
				: null;
		this.designgroup = this.classe.getCategorie().get(0) != null ? this.classe.getCategorie().get(0) : null;
		GridLayout gridLayout = new GridLayout(1, false);
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		setLayout(gridLayout);

		ScrolledComposite scrolledComposite = new ScrolledComposite(this, SWT.H_SCROLL | SWT.V_SCROLL);
		GridData gd_scrolledComposite = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_scrolledComposite.heightHint = 547;
		scrolledComposite.setLayoutData(gd_scrolledComposite);
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);

		Composite composite = new Composite(scrolledComposite, SWT.NONE);
		composite.setLayout(new GridLayout(10, false));

		comboViewerCat = new ComboViewer(composite, SWT.READ_ONLY);
		Combo comboCat = comboViewerCat.getCombo();
		comboCat.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 8, 1));

		filterAllDesignGroups = new Button(composite, SWT.CHECK);
		filterAllDesignGroups.setText("Tous");
		filterAllDesignGroups.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		filterAllDesignGroups.setSelection(false);
		filterAllDesignGroups.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {

				if (filterAllDesignGroups.getSelection()) {
					comboCat.setEnabled(false);
					listViewer.setInput(classe);
				} else {
					comboCat.setEnabled(true);
					if (designgroup != null && designgroup instanceof MechanicDesignGroup) {
						listViewer.setInput(((MechanicDesignGroup) designgroup).getMechanicdesign().stream().filter(o1 ->o1.isPublic()).toList());
					}
					if (designgroup instanceof String) {
						String cat = (String) designgroup;
						if (cat.contentEquals("Model3D")) {
							listViewer.setInput(ModelProvider.getDesignObjects(classe.getName()));
						} else {
							listViewer.setInput(ModelProvider.getDesignObjects(cat, classe.getName()));
						}
					}

				}
				listViewer.refresh();
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		});
		new Label(composite, SWT.NONE);
		txtFilter = new Text(composite, SWT.BORDER);

		txtFilter.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 10, 1));
		txtFilter.setText(filterText);
		txtFilter.addKeyListener(new KeyListener() {

			@Override
			public void keyReleased(KeyEvent e) {
				filterText = txtFilter.getText();
				listViewer.refresh();
			}

			@Override
			public void keyPressed(KeyEvent e) {}
		});

		poigneeGroup = new Group(composite, SWT.NONE);
		poigneeGroup.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 10, 1));

		filterAvecpoignee = new Button(poigneeGroup, SWT.RADIO);
		filterAvecpoignee.setText("Avec Poignée");
		
		filterSansPoignee = new Button(poigneeGroup, SWT.RADIO);
		filterSansPoignee.setText("Sans Poignée");

		filterAll = new Button(poigneeGroup, SWT.RADIO);
		filterAll.setText("Tous");

		filterAll.setSelection(true);

		poigneeGroup.setLayout(new FillLayout());

		//

		listViewer = new ListViewer(composite, SWT.BORDER | SWT.V_SCROLL);
		List list = listViewer.getList();
		GridData gd_list = new GridData(SWT.FILL, SWT.FILL, true, true, 10, 1);
		gd_list.widthHint = 262;
		list.setLayoutData(gd_list);

		listViewer_1 = new ListViewer(composite, SWT.BORDER | SWT.V_SCROLL);
		List list_1 = listViewer_1.getList();
		GridData gd_list_1 = new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1);
		gd_list_1.heightHint = 100;
		list_1.setLayoutData(gd_list_1);

		Group grpMesure = new Group(composite, SWT.NONE);
		grpMesure.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, false, 8, 1));
		grpMesure.setText("Dimensions");
		grpMesure.setLayout(new GridLayout(3, false));

		Label lblLongeur = new Label(grpMesure, SWT.NONE);
		lblLongeur.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblLongeur.setText("L");

		spnlongeur = new Spinner(grpMesure, SWT.BORDER | SWT.WRAP);
		spnlongeur.setMaximum(10000000);
		spnlongeur.setSelection(600);
		spnlongeur.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));

		Label lblHauteur = new Label(grpMesure, SWT.NONE);
		lblHauteur.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblHauteur.setText("H");

		spnhauteur = new Spinner(grpMesure, SWT.BORDER | SWT.WRAP);
		spnhauteur.setPageIncrement(1);
		spnhauteur.setMaximum(1000000);
		spnhauteur.setSelection(720);
		spnhauteur.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));

		Label lblProfondeur = new Label(grpMesure, SWT.NONE);
		lblProfondeur.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
		lblProfondeur.setText("P");

		spnpronfondeur = new Spinner(grpMesure, SWT.BORDER | SWT.WRAP);
		spnpronfondeur.setPageIncrement(1);
		spnpronfondeur.setMaximum(1000000000);
		spnpronfondeur.setSelection(560);
		spnpronfondeur.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));

		CValtitude = new ComboViewer(grpMesure, SWT.READ_ONLY);
		altitudeCombo = CValtitude.getCombo();
		GridData gd_altitudeCombo = new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1);
		gd_altitudeCombo.widthHint = 30;
		altitudeCombo.setLayoutData(gd_altitudeCombo);

		spnAltitude = new Spinner(grpMesure, SWT.BORDER | SWT.WRAP);
		spnAltitude.setPageIncrement(1);
		spnAltitude.setMaximum(1000000000);
		spnAltitude.setSelection(0);
		spnAltitude.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		grpMesure.setTabList(new Control[] { spnlongeur, spnhauteur, spnpronfondeur, altitudeCombo, spnAltitude });
		listViewer_1.setLabelProvider(new LabelProvider() {

			@Override
			public String getText(Object element) {
				return (String) element;
			}

		});

		widths.add("150");
		widths.add("200");
		widths.add("250");
		widths.add("300");
		widths.add("350");
		widths.add("400");
		widths.add("450");
		widths.add("500");
		widths.add("550");
		widths.add("600");
		widths.add("650");
		widths.add("700");
		widths.add("750");
		widths.add("800");
		widths.add("850");
		widths.add("900");
		widths.add("950");
		widths.add("1000");
		widths.add("1050");
		widths.add("1100");
		widths.add("1150");
		widths.add("1200");

		listViewer_1.setContentProvider(ArrayContentProvider.getInstance());
		listViewer_1.setInput(widths);
		listViewer_1.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection = (IStructuredSelection) event.getSelection();
				// set the selection to the service
				Object selectionobj = selection.size() == 1 ? selection.getFirstElement() : selection.toList();
				spnlongeur.setSelection(Integer.valueOf((String) selectionobj));
				PreviewModel();
			}
		});
		listViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selections = (IStructuredSelection) event.getSelection();
				// set the selection to the service
				Object selectionobj = selections.getFirstElement();
				if (selectionobj == null) {
					return;
				}
				EmfLibraryComposite.changingSelelection = true;
//				long deb=System.currentTimeMillis();
//				System.err.println("deb:\t"+deb);
				if (selectionobj instanceof Option) {
					Option option = (Option) selectionobj;

					MechanicDesign origin = option.getDesign();
					try {
						selection = EcoreUtil.copy(origin);
						MechanicDesign design = (MechanicDesign) selection;
						design.injectOption(option);
						design.setName(option.getName());
						MechanicPublicParam longeur = design.getPublicParam("global.l");
						MechanicPublicParam hauteur = design.getPublicParam("global.h");
						MechanicPublicParam profondeur = design.getPublicParam("global.p");

						MechanicPublicParam altitude = design.getPublicParam("element.positionY");
						MechanicPublicParam altitudeReference = design.getPublicParam("element_YReference");
						if (longeur != null) {
							String val = longeur.getDefaultvalue();

							if (widths.contains(val)) {
								listViewer_1.getList().setSelection(widths.indexOf(val));
							}
							spnlongeur.setSelection(Integer.valueOf(longeur.getDefaultvalue()));
							spnlongeur.setEnabled(longeur.isChangeable());
							listViewer_1.getControl().setEnabled(longeur.isChangeable());
						}
						if (hauteur != null) {
							spnhauteur.setSelection(Integer.valueOf(hauteur.getDefaultvalue()));
							spnhauteur.setEnabled(hauteur.isChangeable());
						}
						if (profondeur != null) {
							spnpronfondeur.setSelection(Integer.valueOf(profondeur.getDefaultvalue()));
							spnpronfondeur.setEnabled(profondeur.isChangeable());
						}
						if (altitude != null && altitude.getDefaultvalue() != null
								&& !altitude.getDefaultvalue().isEmpty()) {
							spnAltitude.setSelection(Integer.valueOf(altitude.getDefaultvalue()));
							spnAltitude.setEnabled(altitude.isChangeable());
						}
						if (altitudeReference != null && altitudeReference.getTypedefelement() != null) {
							CValtitude.setSelection(new StructuredSelection(altitudeReference.getTypedefelement()));
							CValtitude.getControl().setEnabled(altitudeReference.isChangeable());
						}
					} catch (Exception e) {

						e.printStackTrace();
					}

				} else if (selectionobj instanceof WorldObject) {
					selection = ((WorldObject) selectionobj).clone();

					if (selection != null && ((WorldObject) selection).getRealWorldDimension() != null) {
						int x = (int) (((WorldObject) selection).getRealWorldDimension().x * 1000);
						int y = (int) (((WorldObject) selection).getRealWorldDimension().y * 1000);
						int z = (int) (((WorldObject) selection).getRealWorldDimension().z * 1000);
						if (widths.contains(String.valueOf(x))) {
							listViewer_1.getList().setSelection(widths.indexOf(String.valueOf(x)));
						}
						spnlongeur.setSelection(x);
						spnhauteur.setSelection(y);
						spnpronfondeur.setSelection(z);

					}
					if (selection != null && ((WorldObject) selection).getRealWorldPosition() != null) {
						WorldObject wobject = ((WorldObject) selection);
						int y = (int) ((wobject.getRealWorldPosition().y * 1000)
								- (wobject.getRealWorldDimension().y / 2f) * 1000f);
						spnAltitude.setSelection(y);
						TypeDef altitudeType = ModelProvider.getTypeDef("PositionReference");
						if (altitudeType != null) {
							CValtitude.setSelection(new StructuredSelection(altitudeType.getElement("BOTTOM")));
						}
					}
				}
				PreviewModel();
				EmfLibraryComposite.changingSelelection = false;
			}
		});
		spnlongeur.addListener(SWT.Modify, new Listener() {

			@Override
			public void handleEvent(Event event) {
				if (!EmfLibraryComposite.changingSelelection) {
					if (selection instanceof MechanicDesign) {

						MechanicDesign design = (MechanicDesign) selection;
						try {
							MechanicPublicParam longeur = design.getPublicParam("global.l");
							longeur.setDefaultvalue(String.valueOf(spnlongeur.getSelection()));
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} else if (selection instanceof WorldObject) {
						if (((WorldObject) selection).getRealWorldDimension() != null) {
							float x = (float) (spnlongeur.getSelection() / 1000f);
							((WorldObject) selection).getRealWorldDimension().x = x;
							if (((WorldObject) selection).getModel() != null
									&& ((WorldObject) selection).getModel().getInfo() != null) {
								ModelInfo info = ((WorldObject) selection).getModel().getInfo();
								info.setWidth(x);
							}
						}
					}
				}

			}
		});
		spnAltitude.addListener(SWT.Modify, new Listener() {

			@Override
			public void handleEvent(Event event) {
				if (!EmfLibraryComposite.changingSelelection) {
					float kitchenAltitude = 2500;
					if (ProjectManager.getManager().getCurrentScene() != null) {
						kitchenAltitude = ProjectManager.getManager().getCurrentScene().getPreferences()
								.getWallHeight();
					}
					int y = spnAltitude.getSelection();
					Object sel = CValtitude.getStructuredSelection().getFirstElement();
					TypeDefElement ref;
					if (sel != null && sel instanceof TypeDefElement) {
						ref = (TypeDefElement) sel;
					} else {
						return;
					}
					if (selection instanceof MechanicDesign) {

						MechanicDesign design = (MechanicDesign) selection;
						try {
							MechanicPublicParam altitude = design.getPublicParam("element.positionY");
							altitude.setDefaultvalue(String.valueOf(y));
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} else if (selection instanceof WorldObject) {

						if (((WorldObject) selection).getRealWorldPosition() != null) {
							float al = y;
							if (((WorldObject) selection).getModel() != null
									&& ((WorldObject) selection).getModel().getInfo() != null
									&& ((WorldObject) selection).getModel().getInfo().getTranslation() != null) {

								ModelInfo info = ((WorldObject) selection).getModel().getInfo();
								if (ref.getKey().contentEquals("TOP")) {
									al = (int) (kitchenAltitude - y);
									if (((WorldObject) selection).getRealWorldDimension() != null) {
										al = al - (((WorldObject) selection).getRealWorldDimension().y * 1000);

									}
								}
								int half = (int) ((((WorldObject) selection).getRealWorldDimension().y / 2f) * 1000f);
								info.getTranslation().y = al / 1000f + half / 1000f;
							}
						}

					}
				}

			}
		});
		CValtitude.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				if (!EmfLibraryComposite.changingSelelection) {
					int y = spnAltitude.getSelection();
					float kitchenAltitude = 2500;
					if (ProjectManager.getManager().getCurrentScene() != null) {
						kitchenAltitude = ProjectManager.getManager().getCurrentScene().getPreferences()
								.getWallHeight();
					}
					Object sel = CValtitude.getStructuredSelection().getFirstElement();
					TypeDefElement ref;
					if (sel != null && sel instanceof TypeDefElement) {
						ref = (TypeDefElement) sel;
					} else {
						return;
					}
					if (selection instanceof MechanicDesign) {
						MechanicDesign design = (MechanicDesign) selection;
						try {
							MechanicPublicParam altitudeReference = design.getPublicParam("element_YReference");
							altitudeReference.setTypedefelement(ref);
						} catch (Exception e) {
							e.printStackTrace();
						}

					} else if (selection instanceof WorldObject) {
						if (((WorldObject) selection).getRealWorldPosition() != null) {
							float al = y;
							if (((WorldObject) selection).getModel() != null
									&& ((WorldObject) selection).getModel().getInfo() != null
									&& ((WorldObject) selection).getModel().getInfo().getTranslation() != null) {

								ModelInfo info = ((WorldObject) selection).getModel().getInfo();
								if (ref.getKey().contentEquals("TOP")) {
									al = (int) (kitchenAltitude - y);
									if (((WorldObject) selection).getRealWorldDimension() != null) {
										al = al - (((WorldObject) selection).getRealWorldDimension().y * 1000);

									}
								}
								int half = (int) ((((WorldObject) selection).getRealWorldDimension().y / 2f) * 1000f);
								info.getTranslation().y = al / 1000f + half / 1000f;

							}
						}
					}
				}
			}
		});
		spnhauteur.addListener(SWT.Modify, new Listener() {

			@Override
			public void handleEvent(Event event) {
				if (!EmfLibraryComposite.changingSelelection) {
					if (selection instanceof MechanicDesign) {

						MechanicDesign design = (MechanicDesign) selection;
						try {
							MechanicPublicParam hauteur = design.getPublicParam("global.h");
							hauteur.setDefaultvalue(String.valueOf(spnhauteur.getSelection()));

						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} else if (selection instanceof WorldObject) {
						if (((WorldObject) selection).getRealWorldDimension() != null) {
							float y = (float) (spnhauteur.getSelection() / 1000f);
							((WorldObject) selection).getRealWorldDimension().y = y;
							if (((WorldObject) selection).getModel() != null
									&& ((WorldObject) selection).getModel().getInfo() != null) {
								ModelInfo info = ((WorldObject) selection).getModel().getInfo();
								info.setHeight(y);
							}
						}
					}
				}
			}
		});
		spnpronfondeur.addListener(SWT.Modify, new Listener() {

			@Override
			public void handleEvent(Event event) {
				if (!EmfLibraryComposite.changingSelelection) {
					if (selection instanceof MechanicDesign) {
						MechanicDesign design = (MechanicDesign) selection;
						try {
							MechanicPublicParam profondeur = design.getPublicParam("global.p");
							profondeur.setDefaultvalue(String.valueOf(spnpronfondeur.getSelection()));

						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					} else if (selection instanceof WorldObject) {
						if (((WorldObject) selection).getRealWorldDimension() != null) {
							float z = (float) (spnpronfondeur.getSelection() / 1000f);
							((WorldObject) selection).getRealWorldDimension().z = z;
							if (((WorldObject) selection).getModel() != null
									&& ((WorldObject) selection).getModel().getInfo() != null) {
								ModelInfo info = ((WorldObject) selection).getModel().getInfo();
								info.setDepth(z);
							}
						}
					}

				}

			}
		});
		comboViewerCat.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selections = (IStructuredSelection) event.getSelection();
				Object selectionobj = selections.getFirstElement();
				if (selectionobj != null && !selectionobj.equals(designgroup)) {
					if (selectionobj instanceof MechanicDesignGroup) {
						EmfLibraryComposite.this.designgroup = (MechanicDesignGroup) selectionobj;
						listViewer.setInput(((MechanicDesignGroup) designgroup).getMechanicdesign().stream().filter(o1 ->o1.isPublic()).toList());
					}
					if (selectionobj instanceof String) {
						String cat = (String) selectionobj;
						EmfLibraryComposite.this.designgroup = selectionobj;
						if (cat.contentEquals("Model3D")) {
							listViewer.setInput(ModelProvider.getDesignObjects(classe.getName()));
						} else {
							listViewer.setInput(ModelProvider.getDesignObjects(cat, classe.getName()));
						}
					}
					listViewer.refresh();
				}
			}
		});
		scrolledComposite.setContent(composite);
		scrolledComposite.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		comboViewerCat.setContentProvider(ArrayContentProvider.getInstance());
		listViewer.setContentProvider(ModelEMFContentProvider.getInstance());
		comboViewerCat.setLabelProvider(ModelEMFLabelProvider.getInstance());
		listViewer.setLabelProvider(ModelEMFLabelProvider.getInstance());

		searchFilter = createListFilter();
		listViewer.addFilter(searchFilter);
		categories.clear();
		categories.addAll(classe.getCategorie().stream().filter(group->group.isPublic()).collect(Collectors.toList()));
		designCategories =ModelProvider.getDesignObjectsCategories();
		categories.addAll(designCategories);
		comboViewerCat.setInput(categories);
		if (designgroup != null && designgroup instanceof MechanicDesignGroup) {
			listViewer.setInput(((MechanicDesignGroup) designgroup).getMechanicdesign().stream().filter(o1 ->o1.isPublic()).toList());
		}
		if (designgroup instanceof String) {
			String cat = (String) designgroup;
			if (cat.contentEquals("Model3D")) {
				listViewer.setInput(ModelProvider.getDesignObjects());
			} else {
				listViewer.setInput(ModelProvider.getDesignObjects(cat, classe.getName()));
			}
		}

		comboViewerCat.getCombo().select(designgroup != null ? 0 : -1);
		CValtitude.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		CValtitude.setContentProvider(ArrayContentProvider.getInstance());
		TypeDef altitudeType = ModelProvider.getTypeDef("PositionReference");
		CValtitude.setInput(altitudeType.getTypedefelement());
		CValtitude.setSelection(new StructuredSelection(altitudeType.getTypedefelement().get(0)));
		EmfLibraryComposite.createDragSource(listViewer.getList());
		CreatePoigneeFilter();
		createUpdateModelListener();
		listViewer.addOpenListener(new IOpenListener() {

			@Override
			public void open(OpenEvent event) {
				PreviewModel();

			}
		});
		makedirtycontroller(this);
		setTabList(new Control[] { scrolledComposite });

	}

	public void PreviewModel() {
		if (selection != null) {
			Map<String, Object> eventData = new HashMap<String, Object>();
			if (selection instanceof MechanicDesign) {
				MechanicDesign design = (MechanicDesign) selection;
				if (lastseletcteddesignobject != null ) {
					// check if we are in the same model we dont clear the object
					if (lastseletcteddesignobject != selection) {
						lastseletcteddesignobject = null;
						System.gc();
					}
				}
				lastseletcteddesignobject = selection;
				Map info = PreviewModelProvider.getProvider().getOrCreatePreviewPath(design);
				info.put("has_addons", true);
	    		eventData.putAll(info);
	    	}else if(selection instanceof WorldObject) {
	    		WorldObject worldObject = (WorldObject)selection;
	    		var info = worldObject.getModel().getInfo();
	    		String path = (String) info.getProperties().get("path_to_LP");
	    		if(path != null) {
		    		eventData.put("value", path);
		    		Vector3 dims =  worldObject.getRealWorldDimension().xyz();
		    		eventData.put("size", new float[] { dims.x, dims.y, dims.z});
					eventData.put("has_addons", false);

	    		}
	    		lastseletcteddesignobject = null;
	    	}
    		eventBroker.post("PREVIEW_MODEL", eventData);
		}
	}

	public void createUpdateModelListener() {
		eventBroker.subscribe("update_DataModel", new EventHandler() {

			@Override
			public void handleEvent(org.osgi.service.event.Event event) {
				Object data = event.getProperty("org.eclipse.e4.data");
				if (data != null && data instanceof ModelRoot) {
					EmfLibraryComposite.this.root = (ModelRootImpl) data;
					EmfLibraryComposite.this.classgroup = EmfLibraryComposite.this.root.getClasses();
					EmfLibraryComposite.this.classe = EmfLibraryComposite.this.classgroup.getDesignClasse()
							.get(0) != null ? EmfLibraryComposite.this.classgroup.getDesignClasse().get(0) : null;

					EmfLibraryComposite.this.designgroup = EmfLibraryComposite.this.classe.getCategorie().get(0) != null
							? EmfLibraryComposite.this.classe.getCategorie().get(0)
							: null;

					categories.clear();
					categories.addAll(classe.getCategorie().stream().filter(group->group.isPublic()).collect(Collectors.toList()));
					designCategories=ModelProvider.getDesignObjectsCategories();
					categories.addAll(designCategories);
					comboViewerCat.setInput(categories);

					comboViewerCat.getCombo().select(designgroup != null ? 0 : -1);
					if (designgroup != null && designgroup instanceof MechanicDesignGroup) {
						listViewer.setInput(((MechanicDesignGroup) designgroup).getMechanicdesign().stream().filter(o1 ->o1.isPublic()).toList());
					}
					if (designgroup instanceof String) {
						String cat = (String) designgroup;
						if (cat.contentEquals("Model3D")) {
							listViewer.setInput(ModelProvider.getDesignObjects());
						} else {
							listViewer.setInput(ModelProvider.getDesignObjects(cat, classe.getName()));
						}
					}
				}
			}
		});
	}

	public void CreatePoigneeFilter() {
		
		
		filterSansPoignee.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				SANS_POIGNEE = true;
				AVEC_POIGNEE = false;
				ALL = false;
				listViewer.refresh();

			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		});
		

		filterAvecpoignee.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				SANS_POIGNEE = false;
				AVEC_POIGNEE = true;
				ALL = false;
				listViewer.refresh();

			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		});

		filterAll.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				SANS_POIGNEE = false;
				AVEC_POIGNEE = false;
				ALL = true;
				listViewer.refresh();

			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

			}
		});
	}

	public static void createDragSource(Control control) {
		int operations = DND.DROP_MOVE | DND.DROP_COPY;
		DragSource source = new DragSource(control, operations);
		Transfer[] types = new Transfer[] { TextTransfer.getInstance() };
		source.setTransfer(types);
		source.addDragListener(new DragSourceListener() {
//			long deb=0;
			@Override
			public void dragStart(DragSourceEvent event) {
				// TODO Auto-generated method stub
				event.doit = !EmfLibraryComposite.changingSelelection;
				if (ProjectManager.getManager().getCurrentKitchen() == null) {
					event.doit = false;
				}
				if (event.doit) {
					// ProgressBarMonitor.addtask();
				}
//				 deb=System.currentTimeMillis();
//				System.err.println("drag deb:\t"+deb);
			}

			@Override
			public void dragSetData(DragSourceEvent event) {

				event.data = "caisson_canvas3D";
				if (selection != null) {
					Object sel = null;
					if (selection instanceof MechanicDesign) {
						MechanicDesign design = (MechanicDesign) selection;
						sel = design;
					}
					if (selection instanceof WorldObject) {
						sel = selection;

					}
					DnDHelper.transferedObject = sel;
				}
			}

			@Override
			public void dragFinished(DragSourceEvent event) {
				// TODO Auto-generated method stub
				if (event.detail == DND.DROP_MOVE)
					;
//					long fin=System.currentTimeMillis();
//					System.err.println("drag fin1:\t");
//					System.err.println("drag time consumed:\t"+(fin-deb)+"\t element"+ ((MechanicDesign) selection).getName());
				// ProgressBarMonitor.removetask();

			}

		});
	}

	public void customozeDesign(MechanicDesign design) {
		try {
			MechanicPublicParam longeur = design.getPublicParam("global.l");
			MechanicPublicParam hauteur = design.getPublicParam("global.h");
			MechanicPublicParam profondeur = design.getPublicParam("global.p");

			longeur.setDefaultvalue(String.valueOf(spnlongeur.getSelection()));
			hauteur.setDefaultvalue(String.valueOf(spnhauteur.getSelection()));
			profondeur.setDefaultvalue(String.valueOf(spnpronfondeur.getSelection()));

		} catch (Exception e) {
			MessageBox dialog = new MessageBox(this.getShell(), SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
			dialog.setText("Error");
			dialog.setMessage("un erreur est servenue lors de création du model à cause de :" + e.getMessage());
		}
	}



	public ViewerFilter createListFilter() {
		return new ViewerFilter() {
			@Override
			public boolean select(Viewer arg0, Object parantElement, Object element) {
				if ((element instanceof WorldObject)) {
					return selectWorldObject((WorldObject)element);
				}else if (element instanceof MechanicDesign){
					return selectDesign((MechanicDesign) element);
				}else if (element instanceof OptionImpl){
					return selectOption((OptionImpl) element);
				}
				else {
					String elementName = ModelEMFLabelProvider.getInstance().getText(element);
					return elementName.toUpperCase().contains(filterText.toUpperCase());
				}
			}
			
			boolean selectWorldObject(WorldObject worldObject) {
				if(worldObject.getName() == null )
					return false;
				if(filterText == null)
					return true;
				return worldObject.getName().toUpperCase().contains(filterText.toUpperCase());
			}
			
			boolean selectDesign(MechanicDesign design) {
				MechanicPublicParam param;
				try {
					param = design.getPublicParam("POIGNEE_TYPE");
					if(filterByHandlerType(param)) {
						String elementName = ModelEMFLabelProvider.getInstance().getText(design);
						return elementName.toUpperCase().contains(filterText.toUpperCase());
					}
					return false;
				} catch (Exception e) {
					e.printStackTrace();
					return false;
				}
			}
			
			boolean selectOption(OptionImpl option) {
				MechanicDesign design = EcoreUtil.copy(option.getDesign());
				try {
					design.injectOption(option);
					design.setName(option.getLabel());
					return selectDesign(design);
				} catch (Exception e) {
					e.printStackTrace();
					return false;
				}
			}
			boolean filterByHandlerType(MechanicPublicParam param) {
				boolean sansPoignee;
				try {
					if(param == null) {
						sansPoignee = false;
					}else {
					
						sansPoignee = param.getTypedefelement().getKey().equals("SANS_POIGNEE")?true:false;
					}
				} catch (Exception e) {
					sansPoignee = false;
				}
				if(sansPoignee && AVEC_POIGNEE  || !sansPoignee && SANS_POIGNEE)
					return false;
				return true;
			}
		};
	}
	
	

	protected void makedirtycontroller(Composite comp) {
		// Faire la mise ajour des controel pour qui enregistre le dirty
		for (Control ctr : comp.getChildren()) {

			if (ctr instanceof Composite) {
				makedirtycontroller((Composite) ctr);
			}
			if (ctr instanceof Spinner) {
				ctr.addListener(SWT.Selection, event -> updateCaretposition(ctr));
			}
		}
	}

	// Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr) {
		Event ke = new Event();
		ke.type = SWT.MENU_KEYBOARD;
		ke.keyCode = SWT.ARROW_RIGHT;
		ctr.getDisplay().post(ke);
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public void seteventBroker(IEventBroker eventBroker) {

		this.eventBroker = eventBroker;
	}

	public void setSelectionService(ESelectionService selectionService) {
		this.selectionService = selectionService;
	}

	public Object getDesigngroup() {
		return designgroup;
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		return bindingContext;
	}

	@Override
	public void handle(dressing.events.Event event) {
		Display.getDefault().asyncExec(new Runnable() {
			
			@Override
			public void run() {
				EmfLibraryComposite.this.classgroup = EmfLibraryComposite.this.root.getClasses();
				EmfLibraryComposite.this.classe = EmfLibraryComposite.this.classgroup.getDesignClasse().get(0) != null
						? EmfLibraryComposite.this.classgroup.getDesignClasse().get(0)
						: null;

				EmfLibraryComposite.this.designgroup = EmfLibraryComposite.this.classe.getCategorie().get(0) != null
						? EmfLibraryComposite.this.classe.getCategorie().get(0)
						: null;

				categories.clear();
				categories.addAll(classe.getCategorie().stream().filter(group->group.isPublic()).collect(Collectors.toList()));
				designCategories = ModelProvider.getDesignObjectsCategories();
				categories.addAll(designCategories);
				comboViewerCat.setInput(categories);

				comboViewerCat.getCombo().select(designgroup != null ? 0 : -1);
				if (designgroup != null && designgroup instanceof MechanicDesignGroup) {
					listViewer.setInput(((MechanicDesignGroup) designgroup).getMechanicdesign().stream().filter(o1 ->o1.isPublic()).toList());
				}
				if (designgroup instanceof String) {
					String cat = (String) designgroup;
					if (cat.contentEquals("Model3D")) {
						listViewer.setInput(ModelProvider.getDesignObjects());
					} else {
						listViewer.setInput(ModelProvider.getDesignObjects(cat, classe.getName()));
					}
				}
				System.err.println("update model");
				
			}
		});
		

	}

}
