package dressing.ui.caisson;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import dressing.ui.project.ElementConfigComposite;
import gdxapp.object3d.KitchenElement;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;

public class ElementConfigWindow{

	private KitchenElement element;
	private Shell shell;

	public ElementConfigWindow(KitchenElement element) {
		this.element = element;
		shell = new Shell(Display.getDefault(), SWT.CLOSE);
		shell.setText(element.getMechanicDesign().getName());
		createControl();
	}
	
	private void createControl() {
		shell.setLayout(new FillLayout(SWT.HORIZONTAL));
		Composite mainContainer = new Composite(shell, SWT.NONE);
		mainContainer.setLayout(new GridLayout(1, false));
		
		Composite editingComposite = new Composite(mainContainer, SWT.NONE);
		editingComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		editingComposite.setLayout(new FillLayout());
		
		
		Composite buttonComposite = new Composite(mainContainer, SWT.NONE);
		buttonComposite.setLayout(new GridLayout(2, false));
		buttonComposite.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));
		
		Button btnAnnuler = new Button(buttonComposite, SWT.NONE);
		btnAnnuler.setText("Annuler");

		Button btnModifier = new Button(buttonComposite, SWT.NONE);
		btnModifier.setText("Modifier");
		
		ElementConfigurerComposite configurerComposite = new ElementConfigurerComposite(editingComposite, element);
		
		btnModifier.addListener(SWT.MouseDown, event -> {
			configurerComposite.update();
			close();
		});
		btnAnnuler.addListener(SWT.MouseDown, event -> shell.close());

	}

	public void open() {
		shell.open();
	}
	
	public void close() {
		shell.dispose();
	}
}
