package dressing.mathutils;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class Matrix23 {

	private float[] values;
	
	
	public Matrix23(float[] values) {
		this.values = values;
	}
	
	
	public Vector2 mult(Vector3 vector) {
		float[] result = new float[2];
		float[] vec = new float[] {vector.x, vector.y, vector.z};
		for(int i = 0; i < 2; i ++) {
			result[i] = 0;
			for(int j = 0; j < 3; j++) {
				result[i] += values[3 * i + j] * vec[j];  
			}
		}
		return new Vector2(result[0], result[1]);
	}
	
	
	


	public float[] getValues() {
		return values;
	}


	public void setValues(float[] values) {
		this.values = values;
	}


	@Override
	public String toString() {
		String str = values[0] + " | " + values[1] +  " | " + values[2] + "\n" +
					 values[3] + " | " + values[4] + " | " + values[5];
		return str;
	}
	
	
	
	public static void main(String[] args) {
		float[] values = new float[] {
				0,1,0,
				0,0,1
		};
		Matrix23 matrix = new Matrix23(values);
		Vector2 result = matrix.mult(new Vector3(1,2,3));
		System.out.println(matrix);
		System.out.println(result);
		
	}
	
}
