package dressing.ui.project;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

import dressing.model.ProjectManager;
import dressing.ui.shapedrawer.FinalPage;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.PlinthObject;
import geometry.CompoundObject;

public class SocleWizardPage extends WizardPage implements FinalPage {

	
	private SocleSettingComposite composite;
	private PlinthObject plinthObject;
	private CompoundObject geometry;
	
	
	public static SocleWizardPage  instance;
		
	public static SocleWizardPage getInstance() {
		return instance;
	}
	
	public SocleWizardPage(CompoundObject geometry) {
		super("socleWizardPage");
		setTitle("Création du Socle");
		this.geometry = geometry;
		createNewPlinth();
	}

	private void createNewPlinth() {
		try {
			geometry.getBorder().setMaterial(AssetsTextures.getInstance().getMaterial("Plastique"));
			this.plinthObject = new PlinthObject(geometry);
		}catch (Exception e) {
			System.err.println("failed to create new plinth");
			e.printStackTrace();
		}
	}

	@Override
	public void createControl( Composite grandparent) {
		composite = new SocleSettingComposite(grandparent, SWT.EMBEDDED, plinthObject);
		grandparent.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		composite.setParent(grandparent);
		setControl(composite);
		getWizard().getContainer().updateButtons();
	}


	@Override
	public boolean isPageComplete() {
		return true;
	}

	@Override
	public void onHide() {
		ProjectManager.getManager().getCurrentScene().addActor(plinthObject, true);
	}
	
}
