package reporting.htmlReporting.model;

import java.util.HashMap;

public class HtmlTableCell extends HtmlElement{
	int colspan=1;
	HtmlTableRowElement row;
	HtmlTableElement table;
	public HtmlTableCell(HtmlTableRowElement row) {
		super(row.isHeader()?"th":"td");
		this.row=row;
		this.table=row.getTable();
	}
	
	@Override
	public HashMap<String, HtmlAttribute> getAttributes() {
		return super.getAttributes();
	}


	public int getColspan() {
		return colspan;
	}


	public void setColspan(int colspan) {
		this.colspan = colspan;
		appendAttribute("colspan", String.valueOf(colspan));
	}


	public HtmlTableRowElement getRow() {
		return row;
	}


	public void setRow(HtmlTableRowElement row) {
		this.row = row;
	}


	public HtmlTableElement getTable() {
		return table;
	}


	public void setTable(HtmlTableElement table) {
		this.table = table;
	}
	
}
