package gdxapp.tests;


import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import gdxapp.Commun.ScreenshotFactory;


public class ModelViewer implements Screen {
	Camera camera;
    ModelBatch batch;
    Environment environment;
    CameraInputController camController;
	boolean render = false;
	boolean initialized = false;
	ModelInstance instance;
	Array<ModelInstance> instances = new Array<ModelInstance>();
	
	InputMultiplexer inputMultiplexer = new InputMultiplexer();
	InputProcessor inputProcessor = new InputProcessor() {
		
		  
		 

		
		@Override
		public boolean touchUp(int arg0, int arg1, int arg2, int arg3) {
			// TODO Auto-generated method stub
			return false;
		}
		
		@Override
		public boolean touchDragged(int arg0, int arg1, int arg2) {
			// TODO Auto-generated method stub
			return false;
		}
		
		@Override
		public boolean touchDown(int arg0, int arg1, int arg2, int arg3) {
			// TODO Auto-generated method stub
			return false;
		}
		
		@Override
		public boolean scrolled(int arg0) {
			// TODO Auto-generated method stub
//			Gdx.app.debug(inputProcessor.getClass().getName(), "scroll detected..");
			if(Gdx.input.isKeyPressed(Input.Keys.CONTROL_LEFT)) {
//				Gdx.app.debug(inputProcessor.getClass().getName(), "ctl is pressed and scroll detected :" + arg0);
				Vector3 scale = instance.nodes.get(0).scale.cpy();
				instance.nodes.get(0).scale.set((10 - arg0) * 0.1f *  scale.x  ,(10 - arg0) * 0.1f *scale.y,(10 - arg0) * 0.1f *scale.z);
				instance.calculateTransforms();
				return true;
			}
			if(Gdx.input.isKeyPressed(Input.Keys.SHIFT_LEFT)) {
//				Gdx.app.debug(inputProcessor.getClass().getName(), "ctl is pressed and scroll detected :" + arg0);
				instance.transform.translate(0,arg0,0);
				instance.calculateTransforms();
				return true;
			}
			return false;
		}
		
		@Override
		public boolean mouseMoved(int arg0, int arg1) {
			// TODO Auto-generated method stub
			return false;
		}
		
		@Override
		public boolean keyUp(int arg0) {
			// TODO Auto-generated method stub
			return false;
		}
		
		@Override
		public boolean keyTyped(char arg0) {
			// TODO Auto-generated method stub
			return false;
		}
		
		@Override
		public boolean keyDown(int arg0) {
				debugNodes();
			return false;
		}
	};
	
	void init(){ 
		
		instance =  new ModelInstance( new Model());
		instance.nodes.get(0).scale.set(0.01f, 0.01f, 0.01f);
		instance.calculateTransforms();
		instance.transform.setToTranslation(0,0,0);
		instances.add(instance);

		ModelInstance ground = new ModelInstance(new ModelBuilder().
				createCylinder(5, 5, 0.1f, 20, new Material(ColorAttribute.createDiffuse(Color.BLACK)),
						VertexAttributes.Usage.Position));
		instances.add(ground);
		Vector3 position = new Vector3();
		instance.transform.getTranslation(position);
		initialized = true;
	}

	@Override
	public void show() {
		// TODO Auto-generated method stub
		 environment = new Environment();
	     environment.set(new ColorAttribute(ColorAttribute.AmbientLight, 0.4f, 0.4f, 0.4f, 1f));
	     environment.add(new DirectionalLight().set(0.8f, 0.8f, 0.8f, 1f, 0.8f, -0.9f));
	     camera = new PerspectiveCamera(60,Gdx.graphics.getWidth(),Gdx.graphics.getHeight());
	     camera.position.set(5,0,0);
	     camera.lookAt(0,0,0);
	     camera.up.set(0,0,1);
	     camera.near = 1;
	     camera.far = 1000;
	     camera.update();
	     camController = new CameraInputController(camera);
	     
	     inputMultiplexer.addProcessor(inputProcessor);
	     inputMultiplexer.addProcessor(camController);
	     Gdx.input.setInputProcessor(inputMultiplexer);
	     batch = new ModelBatch();
	     init();
	}
	
	void debugNodes(){
		Color[] colors = new Color[] {Color.BLACK,Color.RED, Color.YELLOW, Color.BLUE,Color.GREEN,
				Color.WHITE, Color.GOLD, Color.OLIVE, Color.SKY, Color.BROWN, Color.GRAY, Color.LIME,
				Color.CYAN, Color.DARK_GRAY,Color.LIGHT_GRAY, Color.SKY,Color.VIOLET,Color.NAVY};
		int  i = 0;
		float r,g,b;
		r = 1; g = 1; b =1;
		for(Material node: instance.materials) {
			if(node.id.equals("Material #115")) {
				node.clear();
				node.set(ColorAttribute.createDiffuse(1,1,1,0));
				continue;
			}
				
			r *= 0.8;
			g *= 0.8;
			b *= 0.8;
			node.clear();
			node.set(ColorAttribute.createDiffuse(new Color(r,g,b,1)));
			i++;
		}
	}
	public void inputHandler() {
		if(Gdx.input.isKeyPressed(Keys.H))
			ScreenshotFactory.saveScreen(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), "article");
	}

	@Override
	public void render(float delta) {
		inputHandler();
		// TODO Auto-generated method stub
		Gdx.gl.glClearColor(0x00/255.0f, 0xff/255.0f, 0xff/255.0f,
                0xff/255.0f);
	    //Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
        camController.update();
        batch.begin(camera);
        for(ModelInstance instance: instances) {
    		batch.render(instance,environment);

        }
		batch.end();
	}

	@Override
	public void resize(int width, int height) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resume() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void hide() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		batch.dispose();
		instance.model.dispose();
		
	}
	
}

