package gdxapp.object3d;

import java.util.ArrayList;
import java.util.UUID;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.Vector2;
import dressing.mathutils.MathUtilities;
import dressing.model.Piece2D;
import gdxapp.shaders.PbrMaterial;
import supercad.provider.FacadeHandleProvider;

public class DoorHandle {
	
	public static final Vector2 handlerPadding = new Vector2(0.03f, 0.03f);
	
	protected UUID modelId;
	protected String name;
	protected float price;
	protected PbrMaterial material;
	protected transient Model model;
	protected transient Image previewImg;
	protected Vector3 dimension = new Vector3();
	protected int rotation;
	protected int[] relativePosition = {0,0};
	protected String previewPath;
	
	public DoorHandle cpy() {
		DoorHandle clone = new DoorHandle();
		clone.setModelId(modelId);
		clone.setName(name);
		clone.setDimension(dimension.cpy());
		clone.setPrice(price);
		if(material != null)
			clone.setMaterial(material.cpy());
		clone.setDimension(dimension);
		clone.setRotation(rotation);
		clone.setRelativePosition(relativePosition[0], relativePosition[1]);
		clone.setPreviewPath(this.previewPath);
		clone.setPreviewImg(previewImg);
		return clone;
	}

	
	public Vector3 getPosition(Piece2D relativeTo) {
		Vector2 dims = new Vector2(dimension.x, dimension.y).scl(0.5f);
		ArrayList<Vector2> rotatedVertices = new ArrayList<Vector2>();
		rotatedVertices.add(dims.cpy().rotate(rotation));
		rotatedVertices.add(dims.cpy().scl(1,-1).rotate(rotation));
		rotatedVertices.add(dims.cpy().scl(-1,1).rotate(rotation));
		rotatedVertices.add(dims.cpy().scl(-1,-1).rotate(rotation));
		Vector2[] bounds = MathUtilities.getBoundariesPlane(rotatedVertices);
		dims = bounds[1].sub(bounds[0]).scl(0.5f);
		Vector2 clamp = new Vector2(handlerPadding).add(dims.x, dims.y).scl(-relativePosition[0], -relativePosition[1]);
		Vector3 hostSize3D = relativeTo.getSize().scl(0.001f).scl(0.5f,0.5f,1.0f);
		Vector3 hostCenter = relativeTo.getPosition().scl(0.001f).add(hostSize3D);
		//Vector3 r = new Vector3(clamp.cpy(), 0);
		hostCenter.add(hostSize3D.cpy().scl(relativePosition[0], relativePosition[1], 0));
		hostCenter.add(clamp.x, clamp.y, 0);
		return hostCenter;
	}	
	
		
	public UUID getModelId() {
		return modelId;
	}
	public void setModelId(UUID modelId) {
		this.modelId = modelId;
	}

	public Model getModel() {
		if(model == null && modelId != null) {
			fetchModel();

		}
		return model;
	}
	private void fetchModel() {
		this.model = FacadeHandleProvider.getInstance().getHandleById(modelId).getModel();
	}
	public void setModel(Model model) {
		this.model = model;
	}
	public Vector3 getDimension() {
		return dimension;
	}
	public void setDimension(Vector3 dimension) {
		this.dimension.set(dimension);
	}
	
	public void setDimension(float width, float height, float depth) {
		this.dimension.set(width, height, depth);
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public String getPreviewPath() {
		return previewPath;
	}
	public void setPreviewPath(String previewPath) {
		this.previewPath = previewPath;
	}
	
	public PbrMaterial getMaterial() {
		return material;
	}
	public void setMaterial(PbrMaterial material) {
		this.material = material;
	}
	public int getRotation() {
		return rotation;
	}
	public void setRotation(int rotation) {
		this.rotation = rotation;
	}
	
	public float getPrice() {
		return price;
	}

	public void setPrice(float price) {
		this.price = price;
	}


	public int[] getRelativePosition() {
		return relativePosition;
	}
	public void setRelativePosition(int h, int v) {
		this.relativePosition[0] = h;
		this.relativePosition[1] = v;
	}
	
	


	public Image getPreviewImg() {
		if(previewImg == null && previewPath != null) {
			try {
				ImageData imageData =  new ImageData(previewPath).scaledTo(160, 160);
				previewImg = new Image(Display.getDefault(), imageData);
				
			}catch (Exception e) {
				e.printStackTrace();
			}
		}
		return previewImg;
	}

	public void setPreviewImg(Image previewImg) {
		this.previewImg = previewImg;
	}


	@Override
	public String toString() {
		return name;
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((dimension == null) ? 0 : dimension.hashCode());
		result = prime * result + ((modelId == null) ? 0 : modelId.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DoorHandle other = (DoorHandle) obj;
		if (modelId == null) {
			if (other.modelId != null)
				return false;
		} else if (!modelId.equals(other.modelId))
			return false;
		if (dimension == null) {
			if (other.dimension != null)
				return false;
		} else if (!dimension.epsilonEquals(other.dimension))
			return false;
		
		return true;
	}
	
}
