package reporting.htmlReporting;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.frs.html.CrudeHtmlElement;
import org.frs.html.JavaCodeEvaluator;
import org.frs.svg.DressingDrawingConfig;
import org.frs.svg.SvgDrawer.RENDERING_MODE;
import com.badlogic.gdx.math.Vector2;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.Materiaux;
import dressing.model.Piece2D;
import dressing.model.ProjectManager;
import dressing.model.Space3DFree;
import dressing.model.stock.ModelAccessoire;
import gdxapp.object3d.KitchenElement;
import reporting.SVGGnerator;

public class ElementReport extends HtmlReport{
	
	private KitchenElement kitchenElement;
	private final String template_path = "src/reporting/htmlReporting/templates/ElementReport.html";
	private String pathToBackImg;
	private String pathToFrontImg;
	
	
	public ElementReport(KitchenElement kitchenElement) {
		this.kitchenElement = kitchenElement;
		compiler = JavaCodeEvaluator.getInstance();
		svgGen = new SVGGnerator();
	}
	
	public void bind() {
		
		binding.put("$path_to_back_img$", pathToBackImg);
		binding.put("$path_to_front_img$", pathToFrontImg);
		ArrayList<Piece2D> pieces = (ArrayList<Piece2D>) this.kitchenElement.getDesignObject().getListPieces();
		binding.put("$element$", kitchenElement);
		binding.put("$pieces$", pieces);
		HashMap<Piece2D, String> svgs = new HashMap<Piece2D, String>();
		DesignObjectSvgDrawer drawer = new DesignObjectSvgDrawer();
		DressingDrawingConfig config = new DressingDrawingConfig();
		config.setMode(RENDERING_MODE.LINES);
		config.setHeight(300);
		String svg = drawer.draw(kitchenElement.getDesignObject(), config);
		binding.put("$front$", svg);
		int length = (int) Math.round(kitchenElement.getDesignObject().getLongeurext());
		int height = (int) Math.round(kitchenElement.getDesignObject().getHauteurext());
		int depth = (int) Math.round(kitchenElement.getDesignObject().getProfondeurext());
		
		// accessories
		final HashMap<ModelAccessoire, String> previewURLS = new HashMap<ModelAccessoire, String>();
		Space3DFree element = (Space3DFree) this.kitchenElement.getDesignObject();
		
		String folderPath = ProjectManager.getManager().getCurrentProjectDirectory() + File.separator + "reporting" +
		File.separator + "accessories";
		
		
		final List<ModelAccessoire> accessories = new ArrayList<ModelAccessoire>();
		element.getAccessoires().stream().forEach(
				acc -> {
					String imagePath = "";
					try {
						imagePath = acc.getAccessoire().getAccessoire().getImage().getPath();
						File dest = new File(folderPath + File.separator + acc.getName() + ".jpg");
						IOUtilities.copyFileUsingChannel(new File(imagePath), dest);
						String relativePath = "accessories" + File.separator + acc.getName() + ".jpg";
						previewURLS.put(acc, WorkspaceConfiguration.JETTY_HOST + File.separator +  relativePath);
					}catch (Exception e) {
						e.printStackTrace();
					}
				});
		accessories.addAll(element.getAccessoires());
		binding.put("$accessories$", accessories);
		binding.put("$accessoryUrl$", previewURLS);

		
		
		String dims =  length + "x" + height + "x" + depth;
		binding.put("$dims$", dims);
		Materiaux boxMtl = kitchenElement.getDesignObject().getBasematerial();
		Materiaux backMtl = kitchenElement.getDesignObject().getBackmaterial();
		Materiaux facadeMtl = kitchenElement.getDesignObject().getFacadeMaterial();
		binding.put("$facadeMtl$", facadeMtl.getName());
		binding.put("$backMtl$", backMtl.getName());
		binding.put("$boxMtl$", boxMtl.getName());

		for(Piece2D piece2d: pieces) {
			String face = svgGen.genSingleImageProjections(piece2d, new Vector2(297 * 3,210 * 3), 50, 100, 100);
			svgs.put(piece2d, face);
		}
		binding.put("$svgs$", svgs);
	}

	@Override
	public void loadTemplate( ) {
		loadTemplateFile(this.template_path);
	}
	
	public String getContentAsPlaintext() {
		CrudeHtmlElement body = this.doc.getChildrenByType("body").get(0);
		String plainText = "";
		for(CrudeHtmlElement child: body.getChildren()) {
			plainText += child.toString() + "\n";
		}
		return plainText;
	}

	public KitchenElement getKitchenElement() {
		return kitchenElement;
	}

	public void setKitchenElement(KitchenElement kitchenElement) {
		this.kitchenElement = kitchenElement;
	}

	public String getPathToBackImg() {
		return pathToBackImg;
	}

	public void setPathToBackImg(String pathToBackImg) {
		this.pathToBackImg = pathToBackImg;
	}

	public String getPathToFrontImg() {
		return pathToFrontImg;
	}

	public void setPathToFrontImg(String pathToFrontImg) {
		this.pathToFrontImg = pathToFrontImg;
	}
	
	
	
}
