package gdxapp;

import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import dressing.config.LicenseChecker;
import dressing.config.UserPreference;
import dressing.model.ProjectManager;
import dressing.ui.parts.GdxPart;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.ModelsLoader;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomScreen;
import gdxapp.tests.ElementBuilder;
import supercad.provider.FacadeHandleProvider;

public class DressingRoomApp extends Game {

	public static final String TAG = DressingRoomApp.class.getName();
	private static boolean rebuildAtlas = false;
	private static boolean drawDebugOutline = false;

	ESelectionService selectionService;

	public void setSelectionService(ESelectionService selectionService) {
		this.selectionService = selectionService;
		ProjectManager.instance.getCurrentKitchen().getScene().setSelectionService(this.selectionService);
	}

	@Override
	public void create() {
		// ProgressBarMonitor.addtask();
		try {
			Scene.game = this;
			UserPreference.getPreference().load();
			AssetsTextures.getInstance().init();
			ModelsLoader.getInstance().loadModels();
			Gdx.app.postRunnable(() -> FacadeHandleProvider.getInstance().loadHandles());
			// setScreen(new ElementBuilder());
			setScreen(RoomScreen.getInstance());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void dispose() {
	}

	@Override
	public void setScreen(Screen screen) {
		if (screen.equals(getScreen())) {
			return;
		}
		super.setScreen(screen);
		System.gc();
	}

	@Override
	public void render() {
		try {
			if (screen != null)
				screen.render(Gdx.graphics.getDeltaTime());

		} catch (Exception e) {
			e.printStackTrace();
			System.err.println("gdx crushed");
		}
	}

}
