package dressing.ui.util;

import org.eclipse.swt.widgets.Composite;

import param.MechanicDesignElment;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.model.ModelProvider;
import dressing.ui.emf.MechanicdesignLibrary.ModelEMFLabelProvider;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Control;

public class DesignELementMaterialComposite extends Composite {
	private DataBindingContext m_bindingContext;

	MechanicDesignElment element;
	boolean dirty=false;
	private Label lblName;
	private TableComboViewer tableComboViewerMaterial;
	private TableCombo tableComboMaterial;
	private Button btnLibre;
	private Button btnFacade;
	private Button btnElement;
	private Button btnDos;
	private MaterialTypeInstanceComposite elementMaterialType;
	
	
	public DesignELementMaterialComposite(Composite parent,MechanicDesignElment element, int style) {
		this(parent, style);
		setElement(element);
	}
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	
	public DesignELementMaterialComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(6, false));
		Label lblMaterial = new Label(this, SWT.NONE);
		lblMaterial.setText("Matériaux");
		tableComboViewerMaterial = new TableComboViewer(this, SWT.NONE);
		tableComboMaterial = tableComboViewerMaterial.getTableCombo();
		tableComboMaterial.setEditable(false);
		tableComboMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboMaterial.defineColumns(StaticUiObjects.MaterialColumns);
		tableComboViewerMaterial.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewerMaterial.setLabelProvider(new SingleImageItemLabelProvider(this));
		tableComboViewerMaterial.setInput(ModelProvider.getModelroot().getMaterialgroup().getMaterial());
		btnLibre = new Button(this, SWT.RADIO);
		btnLibre.setText("Libre");
		
		btnFacade = new Button(this, SWT.RADIO);
		btnFacade.setText("Façade");
		
		btnElement = new Button(this, SWT.RADIO);
		btnElement.setText("Élément");
		
		btnDos = new Button(this, SWT.RADIO);
		btnDos.setText("Dos");
		
		Label lblMaterialType = new Label(this, SWT.NONE);
		lblMaterialType.setText("Type Matériaux");
		
		elementMaterialType = new MaterialTypeInstanceComposite(this,SWT.NONE);
		elementMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));
		elementMaterialType.setSize(elementMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		setTabList(new Control[]{tableComboMaterial, btnLibre, btnFacade, btnElement, btnDos, elementMaterialType});
		if(this.element!=null) {
			m_bindingContext = initDataBindings();
		}

	}

	public Label getLblName() {
		return lblName;
	}
	public void setLblName(Label lblName) {
		this.lblName = lblName;
	}
	public MechanicDesignElment getElement() {
		return element;
	}

	public MaterialTypeInstanceComposite getElementMaterialType() {
		return elementMaterialType;
	}
	public void setElementMaterialType(MaterialTypeInstanceComposite elementMaterialType) {
		this.elementMaterialType = elementMaterialType;
	}
	public void setElement(MechanicDesignElment element) {
		this.element = EcoreUtil.copy(element);
		this.element.addPropertyChangeListener(new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				dirty=true;
			}
		});
		if (m_bindingContext != null) {
			m_bindingContext.dispose();
			m_bindingContext = null;
		}
		if (element != null) {
			m_bindingContext = initDataBindings();
		}
		this.elementMaterialType.setMaterial(this.element.getMaterialType());
	}

	public boolean isDirty() {
		return dirty;
	}

	public void setDirty(boolean dirty) {
		this.dirty = dirty;
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionTableComboViewer = ViewerProperties.singleSelection().observe(tableComboViewerMaterial);
		IObservableValue materialElementObserveValue = BeanProperties.value("material").observe(element);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer, materialElementObserveValue, null, null);
		//
		IObservableValue observeEnabledTableComboObserveWidget = WidgetProperties.enabled().observe(tableComboMaterial);
		IObservableValue freeMaterialElementObserveValue = BeanProperties.value("freeMaterial").observe(element);
		bindingContext.bindValue(observeEnabledTableComboObserveWidget, freeMaterialElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLibreObserveWidget = WidgetProperties.widgetSelection().observe(btnLibre);
		bindingContext.bindValue(observeSelectionBtnLibreObserveWidget, freeMaterialElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnFacadeObserveWidget = WidgetProperties.widgetSelection().observe(btnFacade);
		IObservableValue faceMaterialElementObserveValue = BeanProperties.value("faceMaterial").observe(element);
		bindingContext.bindValue(observeSelectionBtnFacadeObserveWidget, faceMaterialElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnElementObserveWidget = WidgetProperties.widgetSelection().observe(btnElement);
		IObservableValue primaryMaterialElementObserveValue = BeanProperties.value("primaryMaterial").observe(element);
		bindingContext.bindValue(observeSelectionBtnElementObserveWidget, primaryMaterialElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnDosObserveWidget = WidgetProperties.widgetSelection().observe(btnDos);
		IObservableValue backMaterialElementObserveValue = BeanProperties.value("backMaterial").observe(element);
		bindingContext.bindValue(observeSelectionBtnDosObserveWidget, backMaterialElementObserveValue, null, null);
		//
		IObservableValue observeEnabledElementMaterialTypeObserveWidget = WidgetProperties.enabled().observe(elementMaterialType);
		bindingContext.bindValue(observeEnabledElementMaterialTypeObserveWidget, freeMaterialElementObserveValue, null, null);
		//
		return bindingContext;
	}
}
