package dressing.ui.util;

import org.eclipse.swt.widgets.Composite;

import param.MechanicDesignElment;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import dressing.model.ModelProvider;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Control;

public class DesignELementFacadeTypeComposite extends Composite {
	
	private DataBindingContext m_bindingContext;
	MechanicDesignElment element;
	boolean dirty=false;
	private Label lblName;
	private ComboViewer comboViewer_FacadeType;
	private Button btnLibre;
	private Button btnLibre_1;
	private Combo combo_FacadeType;

	private MaterialTypeInstanceComposite elementMaterialType;
	
	
	public DesignELementFacadeTypeComposite(Composite parent, MechanicDesignElment element, int style) {
		this(parent, style);
		setElement(element);

	}
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	
	public DesignELementFacadeTypeComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(3, false));
		Label lblfacadeType = new Label(this, SWT.NONE);
		lblfacadeType.setText("Type Façade");
		comboViewer_FacadeType = new ComboViewer(this, SWT.READ_ONLY);
		combo_FacadeType = comboViewer_FacadeType.getCombo();
		combo_FacadeType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_FacadeType.setContentProvider(TypeDefContentProvider.getInstance());
		comboViewer_FacadeType.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		
		comboViewer_FacadeType.setInput(ModelProvider.getTypeDef("FACADE_TYPE"));
		btnLibre = new Button(this, SWT.CHECK);
		btnLibre.setText("Libre");
		
		Label lblMaterialType = new Label(this, SWT.NONE);
		lblMaterialType.setText("Type Matériaux du Vitre");
		
		elementMaterialType = new MaterialTypeInstanceComposite(this,SWT.NONE);
		elementMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		elementMaterialType.setSize(elementMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		btnLibre_1 = new Button(this, SWT.CHECK);
		btnLibre_1.setText("Libre");
		setTabList(new Control[]{combo_FacadeType, btnLibre, elementMaterialType, btnLibre_1});
		if(this.element!=null) {
			m_bindingContext = initDataBindings();
		}

	}

	public MaterialTypeInstanceComposite getElementMaterialType() {
		return elementMaterialType;
	}
	public void setElementMaterialType(MaterialTypeInstanceComposite elementMaterialType) {
		this.elementMaterialType = elementMaterialType;
	}
	public Label getLblName() {
		return lblName;
	}
	public void setLblName(Label lblName) {
		this.lblName = lblName;
	}
	public MechanicDesignElment getElement() {
		return element;
	}

	public void setElement(MechanicDesignElment element) {
		this.element = EcoreUtil.copy(element);
		this.element.addPropertyChangeListener(new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				dirty=true;
			}
		});
		if (m_bindingContext != null) {
			m_bindingContext.dispose();
			m_bindingContext = null;
		}
		if (element != null) {
			m_bindingContext = initDataBindings();
		}
		this.elementMaterialType.setMaterial(this.element.getVitreMaterialType());
	}

	public boolean isDirty() {
		return dirty;
	}

	public void setDirty(boolean dirty) {
		this.dirty = dirty;
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionComboViewer_FacadeType = ViewerProperties.singleSelection().observe(comboViewer_FacadeType);
		IObservableValue facadeTypeElementObserveValue = BeanProperties.value("facadeType").observe(element);
		bindingContext.bindValue(observeSingleSelectionComboViewer_FacadeType, facadeTypeElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLibreObserveWidget = WidgetProperties.buttonSelection().observe(btnLibre);
		IObservableValue facadeTypeFreeElementObserveValue = BeanProperties.value("facadeTypeFree").observe(element);
		bindingContext.bindValue(observeSelectionBtnLibreObserveWidget, facadeTypeFreeElementObserveValue, null, null);
		//
		IObservableValue observeEnabledCombo_FacadeTypeObserveWidget = WidgetProperties.enabled().observe(combo_FacadeType);
		bindingContext.bindValue(observeEnabledCombo_FacadeTypeObserveWidget, facadeTypeFreeElementObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLibre_1ObserveWidget = WidgetProperties.buttonSelection().observe(btnLibre_1);
		IObservableValue vitreMaterialTypeFreeElementObserveValue = BeanProperties.value("vitreMaterialTypeFree").observe(element);
		bindingContext.bindValue(observeSelectionBtnLibre_1ObserveWidget, vitreMaterialTypeFreeElementObserveValue, null, null);
		//
		IObservableValue observeEnabledElementMaterialTypeObserveWidget = WidgetProperties.enabled().observe(elementMaterialType);
		bindingContext.bindValue(observeEnabledElementMaterialTypeObserveWidget, vitreMaterialTypeFreeElementObserveValue, null, null);
		//
		return bindingContext;
	}
}
