package dressing.model.types;

public enum PieceType {
	PORTE, PORTE_GAUCHE, PORTE_DROITE, PORTE_HAUT, PORTE_BAS, ETAGERE_FIXE, ETAGERE_MOBILE_HAUT, ETAGERE_MOBILE_BAS,
	HAUT_CUISSON, BAS_CUISSON, DROITE_CUISSON, GAUCHE_CUISSON, DOS_INTERIEUR, DOS_EXTERIRUR, SEPRATEUR_TRANSVERSANT,
	SEPRATEUR_NORMAL, ETAGERE_MOBILE, FACADE, FACADE_INTERIEUR_TIROIR, FACADE_EXTERIEUR_TIROIR, BAS_TIROIR,
	COTE_DROITE_TIROIR, COTE_GAUCHE_TIROIR, DERIERE_TIROIR, BAS_CUISSON_SOUSEVIER, BANDE_ARRIERE, BANDE_AVANT,
	BANDE_FOUR_BAS_FACE, BANDE_FOUR_BAS_GAUCHE1, BANDE_FOUR_BAS_GAUCHE2, BANDE_FOUR_BAS_DROITE1, BANDE_FOUR_BAS_DROITE2,
	BANDE, COTE_GAUCHE, COTE_DROITE, GENERIC, FAUSSE_FACADE, SEPARATOR_FACADE, PARTITION_FACADE;

	public boolean isBase() {
		switch (this) {
		case BAS_CUISSON:
			return true;
		default:
			return false;
		}
	}
	
	public boolean isShelf() {
		switch (this) {
		case ETAGERE_FIXE:
			return true;
		case ETAGERE_MOBILE:
			return true;
		default:
			return false;
		}
	}

	public boolean isSeperator() {
		switch (this) {
		case SEPRATEUR_NORMAL:
			return true;
		case SEPRATEUR_TRANSVERSANT:
			return true;
		case COTE_DROITE:
			return true;
		case COTE_GAUCHE:
			return true;
		default:
			return false;
		}
	}

	public boolean isBack() {
		switch (this) {
		case DOS_EXTERIRUR:
			return true;
		case DOS_INTERIEUR:
			return true;
		default:
			return false;
		}
	}

	public boolean isFacade() {
		switch (this) {
		case PORTE:
		case PORTE_GAUCHE:
		case PORTE_DROITE:
		case FACADE:
		case PORTE_BAS:
		case PORTE_HAUT:
			return true;
		default:
			return false;
		}
	}

}
