package dressing.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;

import dressing.config.WorkspaceConfiguration;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="supercad-project")
public class SuperCadProject extends ObservableEntity implements TreeElement {

	public static final long serialVersionUID = 2L;

	private UUID id;
	private String name;
	private ProjectType type;
	private ArrayList<Kitchen> kitchens = new ArrayList<>();
	private LocalDateTime creationDate;
	transient ProjectRoot root;
	private String client;
	private String site;
	private String commercial;
	private String commercialPhone;
	transient private Kitchen currentKitchen;
	private String projectDirectory;
	private String clientNumber;
	transient private boolean loaded = false;
	
	public SuperCadProject() {
		super();
	}
	
	public void removeKitchen(Kitchen kitchen) {
		if(this.kitchens.contains(kitchen)) {
			this.kitchens.remove(kitchen);
			propagatePropertyChangeEvent("kitchens", kitchen, null);
		}
	}
	public void addElement(Kitchen child ) throws DesignException {
		if(child ==null)
		{
			throw new DesignException("Impossible d'ajouter un child null");
		}else {
			child.addPropertyChangeListener(new PropertyChangeListener() {
				
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					// TODO Auto-generated method stub
					if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
						propagatePropertyChangeEvent("project.modify", null, child);
					}
				}
			});
			kitchens.add(child);
			child.setProject(this);	
			propagatePropertyChangeEvent("project.child.added", null, child);
		}
	}
	
	public UUID getId() {return id;}
	public void setId(UUID id) {
		UUID oldValue=this.id;
		this.id = id;
		firePropertyChangeEvent("id", oldValue, this.id);
	}
	
	public String getSite() {
		return site;
	}


	public void setSite(String site) {
		String oldValue=this.site;
		this.site = site;
		firePropertyChangeEvent("site", oldValue, this.site);
	}


	public String getCommercial() {
		return commercial;
	}


	public void setCommercial(String commercial) {
		String oldValue=this.commercial;
		this.commercial = commercial;
		firePropertyChangeEvent("commercial", oldValue, this.commercial);
	}


	public String getName() {return name;}
	public void setName(String name) {
		String oldValue=this.name;
		this.name = name;
		firePropertyChangeEvent("name", oldValue,this.name);
	}
	public List<Kitchen> getKitchens() {
		return kitchens;
	}
	public void setKitchens(List<Kitchen> kitchens) {
		List<Kitchen> oldValue=this.kitchens;
		this.kitchens.clear();
		this.kitchens.addAll(kitchens);
		firePropertyChangeEvent("kitchens", oldValue,this.kitchens);
	}
	public LocalDateTime getCreationDate() {
		return creationDate;
	}
	public void setCreationDate(LocalDateTime creationDate) {
		LocalDateTime oldValue=this.creationDate;
		this.creationDate = creationDate;
		firePropertyChangeEvent("creationDate", oldValue,this.creationDate);
	}
	public String getClient() {
		return client;
	}
	public void setClient(String client) {		
		String oldValue=this.client;
		this.client = client;
		firePropertyChangeEvent("client", oldValue, client);
	}
	public ProjectType getType() {
		return type;
	}
	public void setType(ProjectType type) {
		ProjectType oldValue=this.type;
		this.type = type;
		firePropertyChangeEvent("type", oldValue, this.type);
	}
	public ProjectRoot getRoot() {
		return root;
	}
	public void setRoot(ProjectRoot root) {
		ProjectRoot oldValue=this.root;
		this.root = root;
		firePropertyChangeEvent("root", oldValue, this.root);
	}
	
	@Override
	public Object getDirectParent() {
		return this.root;
	}

	@Override
	public boolean hasChildren() {
		// TODO Auto-generated method stub
		return this.getKitchens().size() > 0;
	}

	@Override
	public Object[] getChildren() {
		// TODO Auto-generated method stub
		return this.getKitchens().toArray();
	}

	@Override
	public String getNodeName() {
		// TODO Auto-generated method stub
		String nodeName = (this.name != null)?this.name:"unnamed project";
		return nodeName;
	}

	public String getProjectDirectory() {
		if(projectDirectory == null)
			setProjectDirectory(WorkspaceConfiguration.getProjectsPath() + File.separator + getName());
		return projectDirectory;
	}


	public void setProjectDirectory(String projectDirectory) {
		this.projectDirectory = projectDirectory;
	}


	@Override
	public String getLabelIconPath() {
		// TODO Auto-generated method stub
		return "icons/project3d.png";
	}
	public void initAfterRead() {
    	this.propertyChangeSupport = new PropertyChangeSupport(this);
    	for(Kitchen child : kitchens)
	    {	
    		child.init();
    		child.addPropertyChangeListener(new PropertyChangeListener() {
				
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
						propagatePropertyChangeEvent("project.modify", null, child);
					}
				}
			});
	    }
		
	}
	@Override
	public void propagatePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
		firePropertyChangeEvent(propertyName, oldValue, newValue);
		Object parent = this.getDirectParent();
		if(parent != null) {
			if(parent instanceof ObservableEntity) {
				((ObservableEntity)parent).firePropertyChangeEvent(propertyName, oldValue, newValue);
				((ObservableEntity)parent).propagatePropertyChangeEvent(propertyName, oldValue, newValue);
			}
		}
	}
	
	public Kitchen getCurrentKitchen() {
		if(currentKitchen == null) {
			if(kitchens != null && !kitchens.isEmpty()) {
				currentKitchen = kitchens.get(0);
			}
		}
		return currentKitchen;
	}
	public void generateElementsUsinage() {
		try {
			for(Kitchen kitchen: getKitchens()) {
				kitchen.generateElementsUsinage();
			}
		} catch (Exception e) {
			MessageBox dialog = new MessageBox(null, SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
			dialog.setText("Error");
			dialog.setMessage("un erreur est servenue lors de mise à jour du model à cause de :" + e.getMessage());

			// open dialog and await user selection
			int returnCode = dialog.open();
			e.printStackTrace();
		}
		
	}
	public void setCurrentKitchen(Kitchen kitchen) {
		currentKitchen = kitchen;
	}


	public enum ProjectType{
		KITCHEN, DRESSING
	}
	
	public SuperCadProject copy() {
		SuperCadProject project=new SuperCadProject();
		project.setId(getId());
		project.setName(getName());
		project.setType(getType());
		project.setKitchens(getKitchens());
		project.setCreationDate(getCreationDate());
		project.setRoot(getRoot());
		project.setClient(getClient());
		project.setClientNumber(getClientNumber());
		project.setSite(getSite());
		project.setCommercial(getCommercial());
		project.setProjectDirectory(getProjectDirectory());
		project.setCurrentKitchen(getCurrentKitchen());
		return project;
	}
	
	

	public String getClientNumber() {
		return clientNumber;
	}

	public void setClientNumber(String clientNumber) {
		this.clientNumber = clientNumber;
	}
	

	public String getCommercialPhone() {
		return commercialPhone;
	}

	public void setCommercialPhone(String commercialPhone) {
		this.commercialPhone = commercialPhone;
	}

	public boolean isLoaded() {
		return loaded;
	}

	public void setLoaded(boolean loaded) {
		this.loaded = loaded;
	}

	public void set(SuperCadProject other) {
		setId(other.getId());
		setName(other.getName());
		setType(other.getType());
		setKitchens(other.getKitchens());
		setCreationDate(other.getCreationDate());
		setRoot(other.getRoot());
		setClient(other.getClient());
		setSite(other.getSite());
		setCommercial(other.getCommercial());
		setProjectDirectory(other.getProjectDirectory());
		setCurrentKitchen(other.getCurrentKitchen());
		setClientNumber(other.getClientNumber());
	}

}
