package dressing.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.io.IOUtilities;
import dressing.model.ModelProvider;
import dressing.model.Project3D;
import dressing.model.persistence.mappers.MapperProvider;
import jakarta.xml.bind.JAXBException;
public class OpenHandler {

	@Execute
	public void execute(Shell shell){
		FileDialog dialog = new FileDialog(shell);
		dialog.setFilterExtensions(new String[] {"*.xml"});
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("project3d");
		String defaultpath=projectpref.get("directory", "c:");
		String dirpath = projectpref.get("directoryread", defaultpath);
		
		dialog.setFilterPath(dirpath);
		String filepath = dialog.open();
		if(filepath!=null && !filepath.isEmpty())
		{
			Project3D prj = new Project3D();
		      
			try {
				 File f = new File(filepath);
				 if(f.getParent()!=null)
				 {	
					 dirpath = f.getParent();
					 projectpref.put("directoryread", f.getParent());
					 projectpref.flush();
					 readformXmlFile(filepath, prj);
					 prj.initafterread();
					 prj.setDirectory(dirpath);
					 String s  = f.getName();
					 int indexextension= s.indexOf(".xml");
					 if(indexextension>0)
					 {
						 s = s.substring(0, indexextension);
					 }
					 prj.setName(s);
				 }
				 if(ModelProvider.RootInstance().getProjects().contains(prj))
				 {
					 MessageDialog.openInformation(shell, "Projet déja ouvert", "Ce projet est d�ja ouvert");
				 }
				 else
				 {
						ModelProvider.RootInstance().addProject(prj,true);

				 }
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (BackingStoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}


			

		}
	}
	
	private void readformXmlFile(String filepath , Project3D prj ) throws IOException
	{
		File file = new File(filepath);
	    prj =  MapperProvider.getXmlMapper().fromXml(file, Project3D.class);
	}
	

}
